/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file.formatter.msgpack;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.common.Response;
import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.health.Step;
import io.gravitee.reporter.api.jackson.FieldFilterMixin;
import io.gravitee.reporter.api.jackson.FieldFilterProvider;
import io.gravitee.reporter.file.formatter.AbstractFormatter;
import io.vertx.core.buffer.Buffer;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MsgPackFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public MsgPackFormatter(Rules rules) {
        this.mapper.addMixIn(Reportable.class, FieldFilterMixin.class);
        this.mapper.addMixIn(Request.class, FieldFilterMixin.class);
        this.mapper.addMixIn(Response.class, FieldFilterMixin.class);
        this.mapper.addMixIn(EndpointStatus.class, FieldFilterMixin.class);
        this.mapper.addMixIn(Step.class, FieldFilterMixin.class);
        this.mapper.setFilterProvider((FilterProvider)new FieldFilterProvider(rules));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public Buffer format0(T data) {
        try {
            return Buffer.buffer((byte[])this.mapper.writeValueAsBytes(data));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

