/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.tcp;

import io.gravitee.common.service.AbstractService;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.gravitee.reporter.tcp.MetricsType;
import io.gravitee.reporter.tcp.configuration.TcpReporterConfiguration;
import io.gravitee.reporter.tcp.formatter.Formatter;
import io.gravitee.reporter.tcp.formatter.FormatterFactory;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class TcpReporter
extends AbstractService
implements Reporter {
    private final Logger logger = LoggerFactory.getLogger(TcpReporter.class);
    @Autowired
    private TcpReporterConfiguration configuration;
    @Autowired
    private Vertx vertx;
    private NetClient netClient;
    private NetSocket netSocket;
    private Map<Class<? extends Reportable>, Formatter> formatters = new HashMap<Class<? extends Reportable>, Formatter>(4);
    private CircuitBreaker circuitBreaker;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final byte[] END_OF_LINE = new byte[]{13, 10};

    public boolean canHandle(Reportable reportable) {
        return this.configuration.isEnabled() && this.formatters.containsKey(reportable.getClass());
    }

    public void report(Reportable reportable) {
        if (this.configuration.isEnabled() && this.netSocket != null && !this.netSocket.writeQueueFull()) {
            this.vertx.executeBlocking(event -> {
                Buffer buffer = this.formatters.get(reportable.getClass()).format(reportable);
                if (buffer != null) {
                    event.complete((Object)buffer);
                } else {
                    event.fail("Invalid data");
                }
            }, event -> {
                if (event.succeeded() && !this.netSocket.writeQueueFull()) {
                    this.netSocket.write((Object)((Buffer)event.result()).appendBytes(END_OF_LINE));
                }
            });
        }
    }

    public void doStart() throws Exception {
        if (this.configuration.isEnabled()) {
            this.logger.info("Starting TCP reporter...");
            for (MetricsType type : MetricsType.values()) {
                Formatter formatter = FormatterFactory.getFormatter(this.configuration.getOutputType(), this.configuration.getRules(type));
                this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)formatter);
                this.formatters.put(type.getClazz(), formatter);
            }
            this.circuitBreaker = CircuitBreaker.create((String)"tcp-reporter", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxRetries(Integer.MAX_VALUE).setTimeout((long)this.configuration.getConnectTimeout())).retryPolicy(integer -> this.configuration.getRetryTimeout());
            this.netClient = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(this.configuration.getConnectTimeout()).setReconnectAttempts(this.configuration.getReconnectAttempts()).setReconnectInterval(this.configuration.getReconnectInterval()));
            this.connect();
        }
    }

    private void connect() {
        this.circuitBreaker.execute(this::doConnect).onComplete(event -> {
            if (event.succeeded()) {
                this.netSocket = (NetSocket)event.result();
                this.netSocket.closeHandler(event1 -> {
                    this.netSocket = null;
                    this.logger.info("TCP reporter connection has been closed, trying to reconnect...");
                    this.connect();
                }).exceptionHandler(throwable -> {
                    this.netSocket = null;
                    this.logger.error("An error occurs with the TCP reporter", throwable);
                });
            } else {
                this.connect();
            }
        });
    }

    private void doConnect(Promise<NetSocket> netSocketPromise) {
        this.netClient.connect(this.configuration.getPort(), this.configuration.getHost(), event -> {
            if (event.failed()) {
                netSocketPromise.fail(event.cause());
                this.logger.error("An error occurs while trying to connect TCP reporter to {}:{}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), event.cause()});
            } else {
                netSocketPromise.complete((Object)((NetSocket)event.result()));
                this.logger.info("TCP reporter connected to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            }
        });
    }

    protected void doStop() throws Exception {
        if (this.configuration.isEnabled() && this.netClient != null) {
            this.logger.info("Stopping TCP reporter...");
            if (this.netSocket != null) {
                this.netSocket.close(event -> this.logger.info("TCP reporter socket closed successfully"));
            }
            this.netClient.close();
            this.logger.info("Stopping TCP reporter... DONE");
        }
    }
}

