/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.tcp.configuration;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.tcp.MetricsType;
import io.gravitee.reporter.tcp.formatter.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;

public class TcpReporterConfiguration {
    private static final String TCP_REPORTER_PREFIX = "reporters.tcp.";
    @Value(value="${reporters.tcp.output:json}")
    private String outputType;
    @Value(value="${reporters.tcp.enabled:false}")
    private boolean enabled;
    @Value(value="${reporters.tcp.host:localhost}")
    private String host;
    @Value(value="${reporters.tcp.port:8123}")
    private int port;
    @Value(value="${reporters.tcp.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${reporters.tcp.retryTimeout:5000}")
    private long retryTimeout;
    @Value(value="${reporters.tcp.reconnectAttempts:10}")
    private int reconnectAttempts;
    @Value(value="${reporters.tcp.reconnectInterval:500}")
    private long reconnectInterval;
    @Autowired
    private ConfigurableEnvironment environment;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Type getOutputType() {
        return this.outputType == null ? Type.JSON : Type.valueOf(this.outputType.toUpperCase());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public Rules getRules(MetricsType type) {
        Rules rules = new Rules();
        rules.setRenameFields(this.getMapProperties(TCP_REPORTER_PREFIX + type.getType() + ".rename"));
        rules.setExcludeFields(this.getArrayProperties(TCP_REPORTER_PREFIX + type.getType() + ".exclude"));
        rules.setIncludeFields(this.getArrayProperties(TCP_REPORTER_PREFIX + type.getType() + ".include"));
        return rules;
    }

    private Map<String, String> getMapProperties(String prefix) {
        Map properties = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, (String)prefix);
        if (!properties.isEmpty()) {
            return properties.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(EnvironmentUtils.encodedKey((String)prefix).length() + 1), entry -> entry.getValue().toString()));
        }
        return Collections.emptyMap();
    }

    private Set<String> getArrayProperties(String prefix) {
        HashSet<String> properties = new HashSet<String>();
        boolean found = true;
        int idx = 0;
        while (found) {
            String property;
            if (!(found = (property = this.environment.getProperty(prefix + "[" + idx++ + "]")) != null && !property.isEmpty())) continue;
            properties.add(property);
        }
        return properties;
    }
}

