/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.tcp.formatter.csv;

import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.tcp.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import java.util.Iterator;
import java.util.Map;

public final class MetricsFormatter
extends SingleValueFormatter<Metrics> {
    @Override
    public Buffer format0(Metrics metrics) {
        Map customMetrics = metrics.getCustomMetrics();
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, metrics.getTransactionId());
        this.appendString(buffer, metrics.getRequestId());
        this.appendLong(buffer, metrics.timestamp().toEpochMilli());
        this.appendString(buffer, metrics.getRemoteAddress());
        this.appendString(buffer, metrics.getLocalAddress());
        this.appendString(buffer, metrics.getApi());
        this.appendString(buffer, metrics.getApplication());
        this.appendString(buffer, metrics.getPlan());
        this.appendString(buffer, metrics.getSubscription());
        this.appendString(buffer, metrics.getUser());
        this.appendString(buffer, metrics.getTenant());
        this.appendString(buffer, metrics.getUri());
        this.appendString(buffer, metrics.getPath());
        this.appendString(buffer, metrics.getMappedPath());
        this.appendString(buffer, metrics.getHttpMethod().name());
        this.appendInt(buffer, metrics.getStatus());
        this.appendString(buffer, metrics.getEndpoint());
        this.appendString(buffer, metrics.getErrorKey());
        this.appendString(buffer, metrics.getMessage(), true, false);
        this.appendString(buffer, metrics.getUserAgent(), true, false);
        this.appendString(buffer, metrics.getHost());
        this.appendLong(buffer, metrics.getRequestContentLength());
        this.appendLong(buffer, metrics.getResponseContentLength());
        this.appendLong(buffer, metrics.getApiResponseTimeMs());
        this.appendLong(buffer, metrics.getProxyResponseTimeMs());
        this.appendLong(buffer, metrics.getProxyLatencyMs());
        this.appendString(buffer, metrics.getSecurityType() != null ? metrics.getSecurityType().name() : null);
        this.appendString(buffer, metrics.getSecurityToken() != null ? metrics.getApi() : null, customMetrics.isEmpty());
        if (!customMetrics.isEmpty()) {
            Iterator i = customMetrics.keySet().iterator();
            while (i.hasNext()) {
                this.appendString(buffer, (String)customMetrics.get(i.next()), true, !i.hasNext());
            }
        }
        return buffer;
    }
}

