/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.tcp.formatter.elasticsearch.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FreeMarkerComponent
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(FreeMarkerComponent.class);
    private static final String DIRECTORY_NAME = "/elasticsearch";
    private Configuration configuration;

    public void afterPropertiesSet() throws IOException {
        this.configuration = new Configuration(Configuration.VERSION_2_3_23);
        this.configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.configuration.setDateFormat("iso_utc");
        this.configuration.setLocale(Locale.ENGLISH);
        this.configuration.setNumberFormat("computer");
        this.configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreeMarkerComponent.class.getClassLoader(), DIRECTORY_NAME));
    }

    public String generateFromTemplate(String templateName, Map<String, Object> data) {
        String string;
        StringWriter output = new StringWriter();
        try {
            this.generateFromTemplate(templateName, data, output);
            string = output.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                this.logger.error("Impossible to generate from template {}", (Object)templateName, (Object)exception);
                throw new IllegalArgumentException();
            }
        }
        output.close();
        return string;
    }

    public void generateFromTemplate(String templateName, Map<String, Object> data, Writer writer) {
        try {
            Template template = this.configuration.getTemplate(templateName);
            template.process(data, writer);
        }
        catch (TemplateException | IOException exception) {
            this.logger.error("Impossible to generate from template " + templateName, exception);
            throw new IllegalArgumentException();
        }
    }

    public String generateFromTemplate(String templateName) {
        return this.generateFromTemplate(templateName, Collections.emptyMap());
    }
}

