/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.tcp.formatter.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.common.Response;
import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.health.Step;
import io.gravitee.reporter.api.jackson.FieldFilterMixin;
import io.gravitee.reporter.api.jackson.FieldFilterProvider;
import io.gravitee.reporter.api.jackson.HttpHeadersSerializer;
import io.gravitee.reporter.tcp.formatter.AbstractFormatter;
import io.vertx.core.buffer.Buffer;

public class JsonFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonFormatter(Rules rules) {
        if (rules != null && rules.containsRules()) {
            this.mapper.addMixIn(Reportable.class, FieldFilterMixin.class);
            this.mapper.addMixIn(Request.class, FieldFilterMixin.class);
            this.mapper.addMixIn(Response.class, FieldFilterMixin.class);
            this.mapper.addMixIn(EndpointStatus.class, FieldFilterMixin.class);
            this.mapper.addMixIn(Step.class, FieldFilterMixin.class);
            this.mapper.setFilterProvider((FilterProvider)new FieldFilterProvider(rules));
        }
        SimpleModule module = new SimpleModule();
        module.addSerializer(HttpHeaders.class, (JsonSerializer)new HttpHeadersSerializer(rules));
        this.mapper.registerModule((Module)module);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public Buffer format0(T data) {
        try {
            return Buffer.buffer((byte[])this.mapper.writeValueAsBytes(data));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

