/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.AlertEventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.AlertEvent;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class AlertEventRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/alertevent-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        AlertEvent event = new AlertEvent();
        event.setId("new-alert-event");
        event.setAlert("1111-2222-3333-4444");
        event.setMessage("an alert message");
        Date date = new Date(1439022010883L);
        event.setCreatedAt(date);
        event.setUpdatedAt(date);
        this.alertEventRepository.create((Object)event);
        Optional optional = this.alertEventRepository.findById((Object)"new-alert-event");
        Assert.assertTrue((String)"Alert event saved not found", (boolean)optional.isPresent());
        AlertEvent fetchedAlert = (AlertEvent)optional.get();
        Assert.assertEquals((Object)event.getId(), (Object)fetchedAlert.getId());
        Assert.assertEquals((Object)event.getAlert(), (Object)fetchedAlert.getAlert());
        Assert.assertEquals((Object)event.getMessage(), (Object)fetchedAlert.getMessage());
        Assert.assertTrue((boolean)DateUtils.compareDate(event.getCreatedAt(), fetchedAlert.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(event.getUpdatedAt(), fetchedAlert.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.alertEventRepository.findById((Object)"an-alert-to-update");
        Assert.assertTrue((String)"Alert event to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved alert name.", (Object)"an-alert-to-update", (Object)((AlertEvent)optional.get()).getId());
        AlertEvent event = (AlertEvent)optional.get();
        event.setMessage("An updated message");
        Date date = new Date(1439022010883L);
        event.setCreatedAt(date);
        event.setUpdatedAt(date);
        this.alertEventRepository.update((Object)event);
        Optional optionalUpdated = this.alertEventRepository.findById((Object)"an-alert-to-update");
        Assert.assertTrue((String)"Alert event to update not found", (boolean)optionalUpdated.isPresent());
        AlertEvent fetchedAlert = (AlertEvent)optionalUpdated.get();
        Assert.assertEquals((Object)event.getId(), (Object)fetchedAlert.getId());
        Assert.assertEquals((Object)event.getAlert(), (Object)fetchedAlert.getAlert());
        Assert.assertEquals((Object)event.getMessage(), (Object)fetchedAlert.getMessage());
        Assert.assertTrue((boolean)DateUtils.compareDate(event.getCreatedAt(), fetchedAlert.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(event.getUpdatedAt(), fetchedAlert.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbAlertsBeforeDeletion = (int)this.alertEventRepository.search(new AlertEventCriteria.Builder().build(), new PageableBuilder().pageNumber(0).pageSize(10).build()).getTotalElements();
        this.alertEventRepository.delete((Object)"an-alert-to-update");
        int nbAlertsAfterDeletion = (int)this.alertEventRepository.search(new AlertEventCriteria.Builder().build(), new PageableBuilder().pageNumber(0).pageSize(10).build()).getTotalElements();
        Assert.assertEquals((long)(nbAlertsBeforeDeletion - 1), (long)nbAlertsAfterDeletion);
    }

    @Test
    public void shouldFindByAlert() throws Exception {
        Page pageEvents = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert("alert-parent-id2").build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertNotNull((Object)pageEvents);
        Assert.assertEquals((long)1L, (long)pageEvents.getTotalElements());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownAlert() throws Exception {
        AlertEvent unknownAlertEvent = new AlertEvent();
        unknownAlertEvent.setId("unknown");
        this.alertEventRepository.update((Object)unknownAlertEvent);
        Assert.fail((String)"An unknown alert event should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.alertEventRepository.update(null);
        Assert.fail((String)"A null alert event should not be updated");
    }

    @Test
    public void shouldDeleteAll() throws Exception {
        long before = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert("alert-id-to-delete").build(), new PageableBuilder().pageNumber(0).pageSize(10).build()).getTotalElements();
        this.alertEventRepository.deleteAll("alert-id-to-delete");
        long after = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert("alert-id-to-delete").build(), new PageableBuilder().pageNumber(0).pageSize(10).build()).getTotalElements();
        Assert.assertEquals((String)"2 before", (long)2L, (long)before);
        Assert.assertEquals((String)"0 after", (long)0L, (long)after);
    }
}

