/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AlertRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/alerttrigger-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set alerts = this.alertRepository.findAll();
        Assert.assertNotNull((Object)alerts);
        Assert.assertEquals((long)3L, (long)alerts.size());
        Optional<AlertTrigger> optionalAlert = alerts.stream().filter(alert -> "quota90".equals(alert.getId())).findAny();
        Assert.assertTrue((boolean)optionalAlert.isPresent());
        Assert.assertEquals((Object)"Quota90", (Object)optionalAlert.get().getName());
        Assert.assertEquals((Object)"Description for alert API quota 90%", (Object)optionalAlert.get().getDescription());
        Assert.assertEquals((Object)"APPLICATION", (Object)optionalAlert.get().getReferenceType());
        Assert.assertEquals((Object)"application-id", (Object)optionalAlert.get().getReferenceId());
        Assert.assertEquals((Object)"QUOTA", (Object)optionalAlert.get().getType());
        Assert.assertEquals((Object)"{}", (Object)optionalAlert.get().getDefinition());
        Assert.assertTrue((boolean)optionalAlert.get().isEnabled());
        Assert.assertTrue((boolean)DateUtils.compareDate(1439022010883L, optionalAlert.get().getCreatedAt().getTime()));
        Assert.assertTrue((boolean)DateUtils.compareDate(1439022010883L, optionalAlert.get().getUpdatedAt().getTime()));
        Assert.assertTrue((boolean)optionalAlert.get().isTemplate());
        Assert.assertEquals((long)1L, (long)optionalAlert.get().getEventRules().size());
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional alert = this.alertRepository.findById((Object)"health-check");
        Assert.assertNotNull((Object)alert);
        Assert.assertTrue((boolean)alert.isPresent());
        Assert.assertEquals((Object)"health-check", (Object)((AlertTrigger)alert.get()).getId());
        Assert.assertEquals((Object)"Health-check", (Object)((AlertTrigger)alert.get()).getName());
        Assert.assertEquals((long)1L, (long)((AlertTrigger)alert.get()).getEventRules().size());
    }

    @Test
    public void shouldCreate() throws Exception {
        AlertTrigger alert = new AlertTrigger();
        alert.setId("new-alert");
        alert.setName("Alert name");
        alert.setDescription("Description for the new alert");
        alert.setReferenceType("API");
        alert.setReferenceId("api-id");
        alert.setType("HEALTH_CHECK");
        alert.setDefinition("{}");
        Date date = new Date(1439022010883L);
        alert.setCreatedAt(date);
        alert.setUpdatedAt(date);
        int nbAlertsBeforeCreation = this.alertRepository.findAll().size();
        this.alertRepository.create((Object)alert);
        int nbAlertsAfterCreation = this.alertRepository.findAll().size();
        Assert.assertEquals((long)(nbAlertsBeforeCreation + 1), (long)nbAlertsAfterCreation);
        Optional optional = this.alertRepository.findById((Object)"new-alert");
        Assert.assertTrue((String)"Alert saved not found", (boolean)optional.isPresent());
        AlertTrigger fetchedAlert = (AlertTrigger)optional.get();
        Assert.assertEquals((Object)alert.getName(), (Object)fetchedAlert.getName());
        Assert.assertEquals((Object)alert.getDescription(), (Object)fetchedAlert.getDescription());
        Assert.assertEquals((Object)alert.getReferenceType(), (Object)fetchedAlert.getReferenceType());
        Assert.assertEquals((Object)alert.getReferenceId(), (Object)fetchedAlert.getReferenceId());
        Assert.assertEquals((Object)alert.getType(), (Object)fetchedAlert.getType());
        Assert.assertEquals((Object)alert.getDefinition(), (Object)fetchedAlert.getDefinition());
        Assert.assertEquals((Object)alert.isEnabled(), (Object)fetchedAlert.isEnabled());
        Assert.assertTrue((boolean)DateUtils.compareDate(alert.getCreatedAt(), fetchedAlert.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(alert.getUpdatedAt(), fetchedAlert.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.alertRepository.findById((Object)"quota80");
        Assert.assertTrue((String)"Alert to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved alert name.", (Object)"Quota80", (Object)((AlertTrigger)optional.get()).getName());
        AlertTrigger alert = (AlertTrigger)optional.get();
        alert.setName("New name");
        alert.setDescription("New description");
        alert.setReferenceType("New reference type");
        alert.setReferenceId("New reference id");
        alert.setType("New type");
        alert.setDefinition("{}");
        alert.setEnabled(true);
        Date date = new Date(1439022010883L);
        alert.setCreatedAt(date);
        alert.setUpdatedAt(date);
        int nbAlertsBeforeUpdate = this.alertRepository.findAll().size();
        this.alertRepository.update((Object)alert);
        int nbAlertsAfterUpdate = this.alertRepository.findAll().size();
        Assert.assertEquals((long)nbAlertsBeforeUpdate, (long)nbAlertsAfterUpdate);
        Optional optionalUpdated = this.alertRepository.findById((Object)"quota80");
        Assert.assertTrue((String)"Alert to update not found", (boolean)optionalUpdated.isPresent());
        AlertTrigger fetchedAlert = (AlertTrigger)optionalUpdated.get();
        Assert.assertEquals((Object)alert.getName(), (Object)fetchedAlert.getName());
        Assert.assertEquals((Object)alert.getDescription(), (Object)fetchedAlert.getDescription());
        Assert.assertEquals((Object)alert.getReferenceType(), (Object)fetchedAlert.getReferenceType());
        Assert.assertEquals((Object)alert.getReferenceId(), (Object)fetchedAlert.getReferenceId());
        Assert.assertEquals((Object)alert.getType(), (Object)fetchedAlert.getType());
        Assert.assertEquals((Object)alert.getDefinition(), (Object)fetchedAlert.getDefinition());
        Assert.assertEquals((Object)alert.isEnabled(), (Object)fetchedAlert.isEnabled());
        Assert.assertTrue((boolean)DateUtils.compareDate(alert.getCreatedAt(), fetchedAlert.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(alert.getUpdatedAt(), fetchedAlert.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbAlertsBeforeDeletion = this.alertRepository.findAll().size();
        this.alertRepository.delete((Object)"quota80");
        int nbAlertsAfterDeletion = this.alertRepository.findAll().size();
        Assert.assertEquals((long)(nbAlertsBeforeDeletion - 1), (long)nbAlertsAfterDeletion);
    }

    @Test
    public void shouldFindByReference() throws Exception {
        List alerts = this.alertRepository.findByReference("API", "api-id");
        Assert.assertNotNull((Object)alerts);
        Assert.assertEquals((long)1L, (long)alerts.size());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownAlert() throws Exception {
        AlertTrigger unknownAlert = new AlertTrigger();
        unknownAlert.setId("unknown");
        this.alertRepository.update((Object)unknownAlert);
        Assert.fail((String)"An unknown alert should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.alertRepository.update(null);
        Assert.fail((String)"A null alert should not be updated");
    }
}

