/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.ApiHeader;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ApiHeaderTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/apiheader-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set all = this.apiHeaderRepository.findAll();
        Assert.assertEquals((long)3L, (long)all.size());
    }

    @Test
    public void shouldFindAllByEnvironment() throws Exception {
        Set all = this.apiHeaderRepository.findAllByEnvironment("DEFAULT");
        Assert.assertEquals((long)2L, (long)all.size());
    }

    @Test
    public void shouldDelete() throws Exception {
        Optional optionalApiHeader = this.apiHeaderRepository.findById((Object)"1");
        Assert.assertTrue((boolean)optionalApiHeader.isPresent());
        this.apiHeaderRepository.delete((Object)"1");
        optionalApiHeader = this.apiHeaderRepository.findById((Object)"1");
        Assert.assertFalse((boolean)optionalApiHeader.isPresent());
    }

    @Test
    public void shouldUpdate() throws Exception {
        ApiHeader up = new ApiHeader();
        up.setId("toUpdate");
        up.setEnvironmentId("new_DEFAULT");
        up.setName("newName");
        up.setValue("newValue");
        up.setOrder(123);
        up.setCreatedAt(new Date(1439027010882L));
        up.setUpdatedAt(new Date(1439027010883L));
        this.apiHeaderRepository.update((Object)up);
        Optional updated = this.apiHeaderRepository.findById((Object)"toUpdate");
        Assert.assertTrue((boolean)updated.isPresent());
        Assert.assertEquals((Object)up.getId(), (Object)((ApiHeader)updated.get()).getId());
        Assert.assertEquals((Object)up.getEnvironmentId(), (Object)((ApiHeader)updated.get()).getEnvironmentId());
        Assert.assertEquals((Object)up.getName(), (Object)((ApiHeader)updated.get()).getName());
        Assert.assertEquals((Object)up.getValue(), (Object)((ApiHeader)updated.get()).getValue());
        Assert.assertEquals((long)up.getOrder(), (long)((ApiHeader)updated.get()).getOrder());
        Assert.assertTrue((boolean)DateUtils.compareDate(up.getCreatedAt(), ((ApiHeader)updated.get()).getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(up.getUpdatedAt(), ((ApiHeader)updated.get()).getUpdatedAt()));
    }
}

