/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.ApiKeyCriteria;
import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ApiKeyRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/apikey-tests/";
    }

    @Test
    public void createKeyTest() throws Exception {
        String key = "apiKey";
        ApiKey apiKey = new ApiKey();
        apiKey.setKey(key);
        apiKey.setCreatedAt(new Date());
        apiKey.setRevoked(true);
        apiKey.setPaused(true);
        apiKey.setExpireAt(DateUtils.parse("11/02/2016"));
        this.apiKeyRepository.create(apiKey);
        Optional optional = this.apiKeyRepository.findById(key);
        Assert.assertTrue((String)"ApiKey not found", (boolean)optional.isPresent());
        ApiKey keyFound = (ApiKey)optional.get();
        Assert.assertNotNull((String)"ApiKey not found", (Object)keyFound);
        Assert.assertEquals((String)"Key value saved doesn't match", (Object)apiKey.getKey(), (Object)keyFound.getKey());
        Assert.assertTrue((String)"Key expiration doesn't match", (boolean)DateUtils.compareDate(apiKey.getExpireAt(), keyFound.getExpireAt()));
        Assert.assertEquals((String)"Key paused status doesn't match", (Object)apiKey.isPaused(), (Object)keyFound.isPaused());
        Assert.assertEquals((String)"Key revoked status doesn't match", (Object)apiKey.isRevoked(), (Object)keyFound.isRevoked());
    }

    @Test
    public void retrieveKeyTest() throws Exception {
        String key = "d449098d-8c31-4275-ad59-8dd707865a33";
        Optional optional = this.apiKeyRepository.findById(key);
        Assert.assertTrue((String)"ApiKey not found", (boolean)optional.isPresent());
        ApiKey keyFound = (ApiKey)optional.get();
        Assert.assertNotNull((String)"ApiKey not found", (Object)keyFound);
        Assert.assertNotNull((String)"No subscription relative to the key", (Object)keyFound.getSubscription());
        Assert.assertTrue((String)"Key paused status doesn't match", (boolean)keyFound.isPaused());
        Assert.assertTrue((String)"Key revoked status doesn't match", (boolean)keyFound.isRevoked());
    }

    @Test
    public void retrieveMissingKeyTest() throws Exception {
        String key = "d449098d-8c31-4275-ad59-000000000";
        Optional optional = this.apiKeyRepository.findById(key);
        Assert.assertFalse((String)"Invalid ApiKey found", (boolean)optional.isPresent());
    }

    @Test
    public void findBySubscriptionTest() throws Exception {
        Set apiKeys = this.apiKeyRepository.findBySubscription("subscription1");
        Assert.assertNotNull((String)"ApiKey not found", (Object)apiKeys);
        Assert.assertEquals((String)"Invalid number of ApiKey found", (long)2L, (long)apiKeys.size());
    }

    @Test
    public void findBySubscriptionNoResult() throws Exception {
        Set apiKeys = this.apiKeyRepository.findBySubscription("subscription-no-api-key");
        Assert.assertNotNull((String)"ApiKey Set is null", (Object)apiKeys);
        Assert.assertTrue((String)"Api found on subscription with no api", (boolean)apiKeys.isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownApiKey() throws Exception {
        ApiKey unknownApiKey = new ApiKey();
        unknownApiKey.setKey("unknown");
        this.apiKeyRepository.update(unknownApiKey);
        Assert.fail((String)"An unknown apiKey should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.apiKeyRepository.update(null);
        Assert.fail((String)"A null apiKey should not be updated");
    }

    @Test
    public void shouldFindByCriteriaWithoutTimeRange() throws Exception {
        List apiKeys = this.apiKeyRepository.findByCriteria(new ApiKeyCriteria.Builder().includeRevoked(false).plans(Collections.singleton("plan1")).build());
        Assert.assertNotNull((String)"found api key", (Object)apiKeys);
        Assert.assertFalse((String)"found api key", (boolean)apiKeys.isEmpty());
        Assert.assertEquals((String)"found 2 apikeys", (long)2L, (long)apiKeys.size());
        Assert.assertTrue((boolean)Arrays.asList("findByCriteria1", "findByCriteria2").contains(((ApiKey)apiKeys.get(0)).getKey()));
        Assert.assertTrue((boolean)Arrays.asList("findByCriteria1", "findByCriteria2").contains(((ApiKey)apiKeys.get(1)).getKey()));
        Assert.assertNotEquals((Object)((ApiKey)apiKeys.get(0)).getKey(), (Object)((ApiKey)apiKeys.get(1)).getKey());
    }

    @Test
    public void shouldFindByCriteriaWithTimeRange() throws Exception {
        List apiKeys = this.apiKeyRepository.findByCriteria(new ApiKeyCriteria.Builder().includeRevoked(false).from(1486771200000L).to(1486771400000L).plans(Collections.singleton("plan1")).build());
        Assert.assertNotNull((String)"found api key", (Object)apiKeys);
        Assert.assertFalse((String)"found api key", (boolean)apiKeys.isEmpty());
        Assert.assertEquals((String)("found 1 api key " + apiKeys.stream().map(ApiKey::getKey).collect(Collectors.toList())), (long)1L, (long)apiKeys.size());
        Assert.assertEquals((Object)"findByCriteria1", (Object)((ApiKey)apiKeys.get(0)).getKey());
    }

    @Test
    public void shouldFindByCriteriaWithoutTimeRangeAndRevoked() throws Exception {
        List apiKeys = this.apiKeyRepository.findByCriteria(new ApiKeyCriteria.Builder().includeRevoked(true).plans(Collections.singleton("plan1")).build());
        Assert.assertNotNull((String)"found api key", (Object)apiKeys);
        Assert.assertFalse((String)"found api key", (boolean)apiKeys.isEmpty());
        Assert.assertEquals((String)"found 3 apikeys", (long)3L, (long)apiKeys.size());
        Assert.assertEquals((Object)"findByCriteria2", (Object)((ApiKey)apiKeys.get(0)).getKey());
        Assert.assertEquals((Object)"findByCriteria1Revoked", (Object)((ApiKey)apiKeys.get(1)).getKey());
        Assert.assertEquals((Object)"findByCriteria1", (Object)((ApiKey)apiKeys.get(2)).getKey());
    }
}

