/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.ApiQualityRule;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class ApiQualityRuleRepositoryTest
extends AbstractRepositoryTest {
    public static final Date DATE = new Date(1439022010883L);
    public static final Date NEW_DATE = new Date(1546305346000L);

    @Override
    protected String getTestCasesPath() {
        return "/data/qualityrule-tests/";
    }

    @Test
    public void shouldFindByApi() throws Exception {
        List apiQualityRules = this.apiQualityRuleRepository.findByApi("api2");
        Assert.assertNotNull((Object)apiQualityRules);
        Assert.assertEquals((long)1L, (long)apiQualityRules.size());
        ApiQualityRule apiQualityRuleProduct = apiQualityRules.stream().filter(apiQualityRule -> "quality-rule1".equals(apiQualityRule.getQualityRule())).findAny().get();
        Assert.assertTrue((boolean)apiQualityRuleProduct.isChecked());
        Assert.assertTrue((boolean)DateUtils.compareDate(DATE, apiQualityRuleProduct.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(DATE, apiQualityRuleProduct.getUpdatedAt()));
    }

    @Test
    public void shouldCreate() throws Exception {
        ApiQualityRule apiQualityRule = new ApiQualityRule();
        apiQualityRule.setApi("api2");
        apiQualityRule.setQualityRule("new-apiQualityRule");
        apiQualityRule.setChecked(true);
        apiQualityRule.setCreatedAt(DATE);
        apiQualityRule.setUpdatedAt(DATE);
        int nbApiQualityRulesBeforeCreation = this.apiQualityRuleRepository.findByApi("api2").size();
        this.apiQualityRuleRepository.create(apiQualityRule);
        int nbApiQualityRulesAfterCreation = this.apiQualityRuleRepository.findByApi("api2").size();
        Assert.assertEquals((long)(nbApiQualityRulesBeforeCreation + 1), (long)nbApiQualityRulesAfterCreation);
        Optional optional = this.apiQualityRuleRepository.findById("api2", "new-apiQualityRule");
        Assert.assertTrue((String)"ApiQualityRule saved not found", (boolean)optional.isPresent());
        ApiQualityRule apiQualityRuleSaved = (ApiQualityRule)optional.get();
        Assert.assertEquals((String)"Invalid saved apiQualityRule checked.", (Object)apiQualityRule.isChecked(), (Object)apiQualityRuleSaved.isChecked());
        Assert.assertTrue((String)"Invalid createdAt.", (boolean)DateUtils.compareDate(apiQualityRule.getCreatedAt(), apiQualityRuleSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid updatedAt.", (boolean)DateUtils.compareDate(apiQualityRule.getUpdatedAt(), apiQualityRuleSaved.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.apiQualityRuleRepository.findById("api2", "quality-rule1");
        Assert.assertTrue((String)"ApiQualityRule to update not found", (boolean)optional.isPresent());
        Assert.assertTrue((String)"Invalid saved apiQualityRule checked.", (boolean)((ApiQualityRule)optional.get()).isChecked());
        ApiQualityRule apiQualityRule = (ApiQualityRule)optional.get();
        apiQualityRule.setChecked(false);
        apiQualityRule.setCreatedAt(NEW_DATE);
        apiQualityRule.setUpdatedAt(NEW_DATE);
        int nbApiQualityRulesBeforeUpdate = this.apiQualityRuleRepository.findByApi("api2").size();
        this.apiQualityRuleRepository.update(apiQualityRule);
        int nbApiQualityRulesAfterUpdate = this.apiQualityRuleRepository.findByApi("api2").size();
        Assert.assertEquals((long)nbApiQualityRulesBeforeUpdate, (long)nbApiQualityRulesAfterUpdate);
        Optional optionalUpdated = this.apiQualityRuleRepository.findById("api2", "quality-rule1");
        Assert.assertTrue((String)"ApiQualityRule to update not found", (boolean)optionalUpdated.isPresent());
        ApiQualityRule apiQualityRuleUpdated = (ApiQualityRule)optionalUpdated.get();
        Assert.assertFalse((String)"Invalid apiQualityRule checked.", (boolean)apiQualityRuleUpdated.isChecked());
        Assert.assertTrue((String)"Invalid createdAt.", (boolean)DateUtils.compareDate(NEW_DATE, apiQualityRuleUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid updatedAt.", (boolean)DateUtils.compareDate(NEW_DATE, apiQualityRuleUpdated.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbApiQualityRulesBeforeDeletion = this.apiQualityRuleRepository.findByApi("api1").size();
        this.apiQualityRuleRepository.delete("api1", "quality-rule2");
        int nbApiQualityRulesAfterDeletion = this.apiQualityRuleRepository.findByApi("api1").size();
        Assert.assertEquals((long)(nbApiQualityRulesBeforeDeletion - 1), (long)nbApiQualityRulesAfterDeletion);
    }

    @Test
    public void shouldDeleteByApi() throws Exception {
        int nbApiQualityRulesBeforeDeletion = this.apiQualityRuleRepository.findByApi("api1").size();
        Assert.assertNotEquals((long)0L, (long)nbApiQualityRulesBeforeDeletion);
        this.apiQualityRuleRepository.deleteByApi("api1");
        int nbApiQualityRulesAfterDeletion = this.apiQualityRuleRepository.findByApi("api1").size();
        Assert.assertEquals((long)0L, (long)nbApiQualityRulesAfterDeletion);
    }

    @Test
    public void shouldDeleteByQualityRule() throws Exception {
        int nbApiQualityRulesBeforeDeletion = this.apiQualityRuleRepository.findByQualityRule("quality-rule2").size();
        Assert.assertNotEquals((long)0L, (long)nbApiQualityRulesBeforeDeletion);
        this.apiQualityRuleRepository.deleteByQualityRule("quality-rule2");
        int nbApiQualityRulesAfterDeletion = this.apiQualityRuleRepository.findByQualityRule("quality-rule2").size();
        Assert.assertEquals((long)0L, (long)nbApiQualityRulesAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownApiQualityRule() throws Exception {
        ApiQualityRule unknownApiQualityRule = new ApiQualityRule();
        unknownApiQualityRule.setApi("unknown");
        unknownApiQualityRule.setQualityRule("unknown");
        this.apiQualityRuleRepository.update(unknownApiQualityRule);
        Assert.fail((String)"An unknown apiQualityRule should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.apiQualityRuleRepository.update(null);
        Assert.fail((String)"A null apiQualityRule should not be updated");
    }
}

