/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ApiRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/api-tests/";
    }

    @Test
    public void createAndDeleteApiTest() throws Exception {
        String apiId = "newApi-Id";
        Api api = new Api();
        api.setId(apiId);
        api.setEnvironmentId("DEFAULT");
        api.setName("sample-new name");
        api.setVersion("1");
        api.setLifecycleState(LifecycleState.STOPPED);
        api.setVisibility(Visibility.PRIVATE);
        api.setDefinition("{}");
        api.setCreatedAt(DateUtils.parse("11/02/2016"));
        api.setUpdatedAt(DateUtils.parse("12/02/2016"));
        api.setDisableMembershipNotifications(true);
        this.apiRepository.create((Object)api);
        Optional optional = this.apiRepository.findById((Object)apiId);
        Assert.assertTrue((String)"Api saved not found", (boolean)optional.isPresent());
        Api apiSaved = (Api)optional.get();
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)api.getEnvironmentId(), (Object)apiSaved.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved api version.", (Object)api.getVersion(), (Object)apiSaved.getVersion());
        Assert.assertEquals((String)"Invalid deployment lifecycle.", (Object)api.getLifecycleState(), (Object)apiSaved.getLifecycleState());
        Assert.assertEquals((String)"Invalid api private api status.", (Object)api.getVisibility(), (Object)apiSaved.getVisibility());
        Assert.assertEquals((String)"Invalid api definition.", (Object)api.getDefinition(), (Object)apiSaved.getDefinition());
        Assert.assertTrue((String)"Invalid api createdAt.", (boolean)DateUtils.compareDate(api.getCreatedAt(), apiSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid api updateAt.", (boolean)DateUtils.compareDate(api.getUpdatedAt(), apiSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid api lifecycle.", (Object)api.getApiLifecycleState(), (Object)apiSaved.getApiLifecycleState());
        Assert.assertTrue((String)"Invalid api disable membership notifications", (boolean)apiSaved.isDisableMembershipNotifications());
        int nbApplicationBefore = this.apiRepository.search(null).size();
        this.apiRepository.delete((Object)apiId);
        int nbApplicationAfter = this.apiRepository.search(null).size();
        Assert.assertFalse((String)"api was deleted", (boolean)this.apiRepository.findById((Object)apiId).isPresent());
        Assert.assertEquals((String)"Invalid number of apis after deletion", (long)(nbApplicationBefore - 1), (long)nbApplicationAfter);
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.apiRepository.findById((Object)"api-to-update");
        Assert.assertTrue((String)"API to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved api name.", (Object)"api-to-update name", (Object)((Api)optional.get()).getName());
        Api api = (Api)optional.get();
        api.setName("New API name");
        api.setEnvironmentId("new_DEFAULT");
        api.setDescription("New description");
        api.setCategories(new HashSet<String>(Arrays.asList("category1", "category2")));
        api.setDefinition("New definition");
        api.setDeployedAt(DateUtils.parse("11/02/2016"));
        api.setGroups(Collections.singleton("New group"));
        api.setLifecycleState(LifecycleState.STARTED);
        api.setPicture("New picture");
        api.setBackground("New background");
        api.setCreatedAt(DateUtils.parse("11/02/2016"));
        api.setUpdatedAt(DateUtils.parse("13/11/2016"));
        api.setVersion("New version");
        api.setVisibility(Visibility.PRIVATE);
        api.setApiLifecycleState(ApiLifecycleState.UNPUBLISHED);
        api.setDisableMembershipNotifications(false);
        int nbAPIsBeforeUpdate = this.apiRepository.search(null).size();
        this.apiRepository.update((Object)api);
        int nbAPIsAfterUpdate = this.apiRepository.search(null).size();
        Assert.assertEquals((long)nbAPIsBeforeUpdate, (long)nbAPIsAfterUpdate);
        Optional optionalUpdated = this.apiRepository.findById((Object)"api-to-update");
        Assert.assertTrue((String)"API to update not found", (boolean)optionalUpdated.isPresent());
        Api apiUpdated = (Api)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved API name.", (Object)"New API name", (Object)apiUpdated.getName());
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)"new_DEFAULT", (Object)apiUpdated.getEnvironmentId());
        Assert.assertEquals((String)"Invalid API description.", (Object)"New description", (Object)apiUpdated.getDescription());
        Assert.assertEquals((String)"Invalid API categories.", new HashSet<String>(Arrays.asList("category1", "category2")), (Object)apiUpdated.getCategories());
        Assert.assertEquals((String)"Invalid API definition.", (Object)"New definition", (Object)apiUpdated.getDefinition());
        Assert.assertTrue((String)"Invalid API deployment date.", (boolean)DateUtils.compareDate("11/02/2016", apiUpdated.getDeployedAt()));
        Assert.assertEquals((String)"Invalid API group.", Collections.singleton("New group"), (Object)apiUpdated.getGroups());
        Assert.assertEquals((String)"Invalid deployment lifecycle state.", (Object)LifecycleState.STARTED, (Object)apiUpdated.getLifecycleState());
        Assert.assertEquals((String)"Invalid API picture.", (Object)"New picture", (Object)apiUpdated.getPicture());
        Assert.assertEquals((String)"Invalid API background.", (Object)"New background", (Object)apiUpdated.getBackground());
        Assert.assertTrue((String)"Invalid API create date.", (boolean)DateUtils.compareDate("11/02/2016", apiUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid API update date.", (boolean)DateUtils.compareDate("13/11/2016", apiUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid API version.", (Object)"New version", (Object)apiUpdated.getVersion());
        Assert.assertEquals((String)"Invalid API visibility.", (Object)Visibility.PRIVATE, (Object)apiUpdated.getVisibility());
        Assert.assertEquals((String)"Invalid API lifecycle state.", (Object)ApiLifecycleState.UNPUBLISHED, (Object)apiUpdated.getApiLifecycleState());
        Assert.assertFalse((String)"Invalid API disable membership notifications", (boolean)apiUpdated.isDisableMembershipNotifications());
    }

    @Test
    public void findByIdTest() throws Exception {
        Optional optional = this.apiRepository.findById((Object)"api-to-findById");
        Assert.assertTrue((String)"Find api by name return no result ", (boolean)optional.isPresent());
        Api api = (Api)optional.get();
        Assert.assertEquals((String)"Invalid environment id.", (Object)"DEFAULT", (Object)api.getEnvironmentId());
        Assert.assertEquals((String)"Invalid api name", (Object)"api-to-findById name", (Object)api.getName());
        Assert.assertEquals((String)"Invalid api version", (Object)"1", (Object)api.getVersion());
        Assert.assertEquals((String)"Invalid api visibility", (Object)Visibility.PUBLIC, (Object)api.getVisibility());
        Assert.assertEquals((String)"Invalid deployment lifecycle state", (Object)LifecycleState.STOPPED, (Object)api.getLifecycleState());
        Assert.assertEquals((String)"Invalid api labels", (long)2L, (long)api.getLabels().size());
        Assert.assertEquals((String)"Invalid api label at position 0", (Object)"label 1", api.getLabels().iterator().next());
        Assert.assertEquals((String)"Invalid api lifecycle state", (Object)ApiLifecycleState.DEPRECATED, (Object)api.getApiLifecycleState());
        Assert.assertTrue((String)"Invalid api disable membership notifications", (boolean)api.isDisableMembershipNotifications());
    }

    @Test
    public void findByIdMissingTest() throws Exception {
        Optional optional = this.apiRepository.findById((Object)"findByNameMissing");
        Assert.assertFalse((String)"Find api by name on missing api return a result", (boolean)optional.isPresent());
    }

    @Test
    public void findAllTest() {
        List apis = this.apiRepository.search(null);
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((String)"Api list is empty", (boolean)apis.isEmpty());
        Assert.assertNotNull((String)"Api is null", apis.iterator().next());
    }

    @Test
    public void findAllTestCriteriaEmpty() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((String)"Api list is empty", (boolean)apis.isEmpty());
        Assert.assertNotNull((String)"Api is null", apis.iterator().next());
    }

    @Test
    public void deleteApiTest() throws Exception {
        Optional api = this.apiRepository.findById((Object)"api-to-delete");
        Assert.assertTrue((String)"api exists", (boolean)api.isPresent());
        this.apiRepository.delete((Object)"api-to-delete");
        api = this.apiRepository.findById((Object)"api-to-delete");
        Assert.assertFalse((String)"api was deleted", (boolean)api.isPresent());
    }

    @Test
    public void shouldFindApiWithGroup() throws Exception {
        Optional api = this.apiRepository.findById((Object)"grouped-api");
        Assert.assertTrue((boolean)api.isPresent());
        Assert.assertNotNull((Object)((Api)api.get()).getGroups());
        Assert.assertEquals(Collections.singleton("api-group"), (Object)((Api)api.get()).getGroups());
    }

    @Test
    public void shouldFindByIds() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().ids(new String[]{"api-to-delete", "api-to-update", "unknown"}).build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)2L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api-to-delete", "api-to-update")));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownApi() throws TechnicalException {
        Api unknownApi = new Api();
        unknownApi.setId("unknown");
        this.apiRepository.update((Object)unknownApi);
        Assert.fail((String)"An unknown api should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws TechnicalException {
        this.apiRepository.update(null);
        Assert.fail((String)"A null api should not be updated");
    }

    @Test
    public void shouldFindByGroups() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().groups(new String[]{"api-group", "unknown"}).build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"grouped-api", (Object)((Api)apis.iterator().next()).getId());
    }

    @Test
    public void shouldFindByName() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apis.iterator().next()).getId());
    }

    @Test
    public void shouldFindByLabel() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().label("label 1").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apis.iterator().next()).getId());
    }

    @Test
    public void shouldFindByState() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().state(LifecycleState.STOPPED).build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)4L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api-to-delete", "api-to-update", "api-to-findById", "grouped-api")));
    }

    @Test
    public void shouldFindByEnvironment() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().environmentId("DEFAULT").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)2L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("grouped-api", "api-to-findById")));
    }

    @Test
    public void shouldFindByVersion() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().version("1").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)4L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api-to-delete", "api-to-update", "api-to-findById", "grouped-api")));
    }

    @Test
    public void shouldFindByView() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().category("my-category").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apis.iterator().next()).getId());
    }

    @Test
    public void shouldFindByVisibility() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().visibility(Visibility.PUBLIC).build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)2L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api-to-findById", "grouped-api")));
    }

    @Test
    public void shouldFindByNameAndVersion() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").version("1").build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apis.iterator().next()).getId());
    }

    @Test
    public void shouldFindByNameAndVersionWithoutDefinition() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").version("1").build(), new ApiFieldExclusionFilter.Builder().excludeDefinition().build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)1L, (long)apis.size());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apis.iterator().next()).getId());
        Assert.assertNull((Object)((Api)apis.iterator().next()).getDefinition());
    }

    @Test
    public void searchByPageable() {
        Page apiPage = this.apiRepository.search(new ApiCriteria.Builder().version("1").build(), new PageableBuilder().pageNumber(0).pageSize(2).build());
        Assert.assertEquals((long)4L, (long)apiPage.getTotalElements());
        Assert.assertEquals((long)2L, (long)apiPage.getPageElements());
        Iterator apiIterator = apiPage.getContent().iterator();
        Assert.assertEquals((Object)"api-to-delete", (Object)((Api)apiIterator.next()).getId());
        Assert.assertEquals((Object)"api-to-findById", (Object)((Api)apiIterator.next()).getId());
        apiPage = this.apiRepository.search(new ApiCriteria.Builder().version("1").build(), new PageableBuilder().pageNumber(1).pageSize(2).build());
        Assert.assertEquals((long)4L, (long)apiPage.getTotalElements());
        Assert.assertEquals((long)2L, (long)apiPage.getPageElements());
        apiIterator = apiPage.getContent().iterator();
        Assert.assertEquals((Object)"api-to-update", (Object)((Api)apiIterator.next()).getId());
        Assert.assertEquals((Object)"grouped-api", (Object)((Api)apiIterator.next()).getId());
    }

    @Test
    public void shouldFindByLifecycleStates() {
        List apis = this.apiRepository.search(new ApiCriteria.Builder().lifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED)).build());
        Assert.assertNotNull((Object)apis);
        Assert.assertFalse((boolean)apis.isEmpty());
        Assert.assertEquals((long)3L, (long)apis.size());
        Assert.assertTrue((boolean)apis.stream().map(Api::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api-to-update", "grouped-api")));
        Assert.assertEquals((Object)ApiLifecycleState.PUBLISHED, (Object)((Api)apis.get(0)).getApiLifecycleState());
        Assert.assertEquals((Object)ApiLifecycleState.PUBLISHED, (Object)((Api)apis.get(1)).getApiLifecycleState());
        Assert.assertEquals((Object)ApiLifecycleState.PUBLISHED, (Object)((Api)apis.get(2)).getApiLifecycleState());
    }
}

