/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/application-tests/";
    }

    @Test
    public void findAllTest() throws Exception {
        Set applications = this.applicationRepository.findAll(new ApplicationStatus[0]);
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((String)"Fail to resolve application in findAll", (long)10L, (long)applications.size());
    }

    @Test
    public void findAllByEnvironmentTest() throws Exception {
        Set applications = this.applicationRepository.findAllByEnvironment("DEFAULT", new ApplicationStatus[0]);
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((String)"Fail to resolve application in findAllByEnvironment", (long)5L, (long)applications.size());
    }

    @Test
    public void findAllArchivedTest() throws Exception {
        Set applications = this.applicationRepository.findAll(new ApplicationStatus[]{ApplicationStatus.ARCHIVED});
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((String)"Fail to resolve application in findAll with application status", (long)1L, (long)applications.size());
        Assert.assertEquals((Object)"grouped-app2", (Object)((Application)applications.iterator().next()).getId());
    }

    @Test
    public void createTest() throws Exception {
        String name = "created-app";
        Application application = new Application();
        application.setId(name);
        application.setEnvironmentId("DEFAULT");
        application.setName(name);
        application.setDescription("Application description");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("type", "app-type");
        application.setMetadata(metadata);
        application.setType(ApplicationType.SIMPLE);
        application.setStatus(ApplicationStatus.ACTIVE);
        application.setCreatedAt(DateUtils.parse("11/02/2016"));
        application.setUpdatedAt(DateUtils.parse("12/02/2016"));
        application.setDisableMembershipNotifications(true);
        this.applicationRepository.create((Object)application);
        Optional optional = this.applicationRepository.findById((Object)name);
        Assert.assertNotNull((Object)optional);
        Assert.assertTrue((String)"Application saved not found", (boolean)optional.isPresent());
        Application appSaved = (Application)optional.get();
        Assert.assertEquals((String)"Invalid environment id.", (Object)application.getEnvironmentId(), (Object)appSaved.getEnvironmentId());
        Assert.assertEquals((String)"Invalid application name.", (Object)application.getName(), (Object)appSaved.getName());
        Assert.assertEquals((String)"Invalid application description.", (Object)application.getDescription(), (Object)appSaved.getDescription());
        Assert.assertEquals((String)"Invalid application status.", (Object)application.getStatus(), (Object)appSaved.getStatus());
        Assert.assertTrue((String)"Invalid application createdAt.", (boolean)DateUtils.compareDate(application.getCreatedAt(), appSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid application updateAt.", (boolean)DateUtils.compareDate(application.getUpdatedAt(), appSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid application metadata.", application.getMetadata().get("type"), appSaved.getMetadata().get("type"));
        Assert.assertTrue((String)"Invalid application disable membership notifications", (boolean)appSaved.isDisableMembershipNotifications());
    }

    @Test
    public void updateTest() throws Exception {
        String applicationName = "updated-app";
        Application application = new Application();
        application.setId(applicationName);
        application.setEnvironmentId("new_DEFAULT");
        application.setName(applicationName);
        application.setDescription("Updated description");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("type", "update-type");
        application.setMetadata(metadata);
        application.setPicture("New picture");
        application.setBackground("New background");
        application.setStatus(ApplicationStatus.ARCHIVED);
        application.setType(ApplicationType.SIMPLE);
        application.setCreatedAt(DateUtils.parse("11/02/2016"));
        application.setUpdatedAt(DateUtils.parse("22/02/2016"));
        application.setDisableMembershipNotifications(true);
        this.applicationRepository.update((Object)application);
        Optional optional = this.applicationRepository.findById((Object)applicationName);
        Assert.assertTrue((String)"Application updated not found", (boolean)optional.isPresent());
        Application appUpdated = (Application)optional.get();
        Assert.assertEquals((String)"Invalid updated environment id.", (Object)application.getEnvironmentId(), (Object)appUpdated.getEnvironmentId());
        Assert.assertEquals((String)"Invalid updated application name.", (Object)application.getName(), (Object)appUpdated.getName());
        Assert.assertEquals((String)"Invalid updated application description.", (Object)application.getDescription(), (Object)appUpdated.getDescription());
        Assert.assertEquals((String)"Invalid updated application status.", (Object)application.getStatus(), (Object)appUpdated.getStatus());
        Assert.assertTrue((String)"Invalid updated application createdAt.", (boolean)DateUtils.compareDate(application.getCreatedAt(), appUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid updated application updateAt.", (boolean)DateUtils.compareDate(application.getUpdatedAt(), appUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid application metadata.", application.getMetadata().get("type"), appUpdated.getMetadata().get("type"));
        Assert.assertTrue((String)"Invalid application disable membership notifications", (boolean)appUpdated.isDisableMembershipNotifications());
        Assert.assertEquals((String)"Invalid updated application picture.", (Object)application.getPicture(), (Object)appUpdated.getPicture());
        Assert.assertEquals((String)"Invalid updated application background.", (Object)application.getBackground(), (Object)appUpdated.getBackground());
    }

    @Test
    public void deleteTest() throws Exception {
        String applicationName = "deleted-app";
        int nbApplicationBefore = this.applicationRepository.findAll(new ApplicationStatus[0]).size();
        this.applicationRepository.delete((Object)applicationName);
        Optional optional = this.applicationRepository.findById((Object)applicationName);
        int nbApplicationAfter = this.applicationRepository.findAll(new ApplicationStatus[0]).size();
        Assert.assertFalse((String)"Deleted application always present", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid number of applications after deletion", (long)(nbApplicationBefore - 1), (long)nbApplicationAfter);
    }

    @Test
    public void findByIdTest() throws Exception {
        Optional optional = this.applicationRepository.findById((Object)"application-sample");
        Assert.assertTrue((String)"Find application by name return no result ", (boolean)optional.isPresent());
        Assert.assertNotNull((Object)((Application)optional.get()).getMetadata());
        Assert.assertEquals((long)2L, (long)((Application)optional.get()).getMetadata().size());
    }

    @Test
    public void findByIdsTest() throws Exception {
        Set apps = this.applicationRepository.findByIds(Arrays.asList("searched-app1", "searched-app2"));
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)2L, (long)apps.size());
    }

    @Test
    public void shouldFindApplicationWithGroup() throws Exception {
        Optional application = this.applicationRepository.findById((Object)"grouped-app1");
        Assert.assertTrue((boolean)application.isPresent());
        Assert.assertNotNull((Object)((Application)application.get()).getGroups());
        Assert.assertEquals(Collections.singleton("application-group"), (Object)((Application)application.get()).getGroups());
    }

    @Test
    public void shouldFindApplicationByExactName() throws Exception {
        Set apps = this.applicationRepository.findByName("searched-app1");
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)"searched-app1", (Object)((Application)apps.iterator().next()).getId());
    }

    @Test
    public void shouldNotFindApplicationByName() throws Exception {
        Set apps = this.applicationRepository.findByName("unknowd-app");
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)0L, (long)apps.size());
    }

    @Test
    public void shouldFindApplicationByPartialName() throws Exception {
        Set apps = this.applicationRepository.findByName("arched");
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)2L, (long)apps.size());
    }

    @Test
    public void shouldFindApplicationByPartialNameIgnoreCase() throws Exception {
        Set apps = this.applicationRepository.findByName("aRcHEd");
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)2L, (long)apps.size());
    }

    @Test
    public void shouldFindByGroups() throws Exception {
        Set apps = this.applicationRepository.findByGroups(Collections.singletonList("application-group"), new ApplicationStatus[0]);
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)2L, (long)apps.size());
    }

    @Test
    public void shouldFindByGroupsAndStatus() throws Exception {
        Set apps = this.applicationRepository.findByGroups(Collections.singletonList("application-group"), new ApplicationStatus[]{ApplicationStatus.ARCHIVED});
        Assert.assertNotNull((Object)apps);
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)"grouped-app2", (Object)((Application)apps.iterator().next()).getId());
    }

    @Test
    public void shouldFindByEmptyGroups() throws Exception {
        Set apps = this.applicationRepository.findByGroups(Collections.emptyList(), new ApplicationStatus[0]);
        Assert.assertNotNull((Object)apps);
        Assert.assertTrue((boolean)apps.isEmpty());
    }

    @Test
    public void shouldFindByIds() throws Exception {
        Set apps = this.applicationRepository.findByIds(Arrays.asList("application-sample", "updated-app", "unknown"));
        Assert.assertNotNull((Object)apps);
        Assert.assertFalse((boolean)apps.isEmpty());
        Assert.assertEquals((long)2L, (long)apps.size());
        Assert.assertTrue((boolean)apps.stream().map(Application::getId).collect(Collectors.toList()).containsAll(Arrays.asList("application-sample", "updated-app")));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownApplication() throws Exception {
        Application unknownApplication = new Application();
        unknownApplication.setId("unknown");
        this.applicationRepository.update((Object)unknownApplication);
        Assert.fail((String)"An unknown application should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.applicationRepository.update(null);
        Assert.fail((String)"A null application should not be updated");
    }
}

