/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.AuditCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.utils.DateUtils;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class AuditRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/audit-tests/";
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional auditOptional = this.auditRepository.findById((Object)"new");
        Assert.assertTrue((boolean)auditOptional.isPresent());
        Audit audit = (Audit)auditOptional.get();
        Assert.assertEquals((String)"id", (Object)"new", (Object)audit.getId());
        Assert.assertEquals((String)"referenceId", (Object)"1", (Object)audit.getReferenceId());
        Assert.assertEquals((String)"referenceType", (Object)Audit.AuditReferenceType.API, (Object)audit.getReferenceType());
        Assert.assertEquals((String)"event", (Object)Plan.AuditEvent.PLAN_CREATED.name(), (Object)audit.getEvent());
        Assert.assertEquals((String)"properties", Collections.singletonMap(Audit.AuditProperties.PLAN.name(), "123"), (Object)audit.getProperties());
        Assert.assertEquals((String)"user", (Object)"JohnDoe", (Object)audit.getUser());
        Assert.assertTrue((String)"createdAt", (boolean)DateUtils.compareDate(new Date(1486771200000L), audit.getCreatedAt()));
        Assert.assertEquals((String)"patch", (Object)"diff", (Object)audit.getPatch());
    }

    @Test
    public void shouldSearchWithPagination() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().references(Audit.AuditReferenceType.API, Collections.singletonList("2")).build();
        Pageable page = new PageableBuilder().pageNumber(0).pageSize(1).build();
        Page auditPage = this.auditRepository.search(auditCriteria, page);
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)2L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)1L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
        Assert.assertEquals((String)"find audit with id 'searchable2'", (Object)"searchable2", (Object)((Audit)auditPage.getContent().get(0)).getId());
    }

    @Test
    public void shouldSearchWithEvent() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().events(Collections.singletonList(Plan.AuditEvent.PLAN_UPDATED.name())).build();
        Pageable page = new PageableBuilder().pageNumber(0).pageSize(10).build();
        Page auditPage = this.auditRepository.search(auditCriteria, page);
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)1L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)1L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
        Assert.assertEquals((String)"find audit with id 'searchable2'", (Object)"searchable2", (Object)((Audit)auditPage.getContent().get(0)).getId());
    }

    @Test
    public void shouldSearchAll() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().build();
        Pageable page = new PageableBuilder().pageNumber(0).pageSize(10).build();
        Page auditPage = this.auditRepository.search(auditCriteria, page);
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)3L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)3L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
        Assert.assertEquals((String)"find audit with id 'searchable2'", (Object)"searchable2", (Object)((Audit)auditPage.getContent().get(0)).getId());
        Assert.assertEquals((String)"find audit with id 'new'", (Object)"new", (Object)((Audit)auditPage.getContent().get(1)).getId());
        Assert.assertEquals((String)"find audit with id 'searchable1'", (Object)"searchable1", (Object)((Audit)auditPage.getContent().get(2)).getId());
    }

    @Test
    public void shouldSearchFromTo() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().from(1900000000000L).to(2999999999999L).build();
        Pageable page = new PageableBuilder().pageNumber(0).pageSize(10).build();
        Page auditPage = this.auditRepository.search(auditCriteria, page);
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)1L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)1L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
        Assert.assertEquals((String)"find audit with id 'searchable2'", (Object)"searchable2", (Object)((Audit)auditPage.getContent().get(0)).getId());
    }

    @Test
    public void shouldSearchFrom() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().from(1000000000000L).build();
        Page auditPage = this.auditRepository.search(auditCriteria, new PageableBuilder().pageNumber(0).pageSize(2).build());
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)3L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)2L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
        auditPage = this.auditRepository.search(auditCriteria, new PageableBuilder().pageNumber(1).pageSize(2).build());
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)3L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)1L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)1L, (long)auditPage.getPageNumber());
    }

    @Test
    public void shouldSearchTo() throws TechnicalException {
        AuditCriteria auditCriteria = new AuditCriteria.Builder().to(1000000000000L).build();
        Pageable page = new PageableBuilder().pageNumber(0).pageSize(10).build();
        Page auditPage = this.auditRepository.search(auditCriteria, page);
        Assert.assertNotNull((Object)auditPage);
        Assert.assertEquals((String)"total elements", (long)1L, (long)auditPage.getTotalElements());
        Assert.assertEquals((String)"page elements", (long)1L, (long)auditPage.getPageElements());
        Assert.assertEquals((String)"page number", (long)0L, (long)auditPage.getPageNumber());
    }
}

