/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Category;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CategoryRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/category-tests/";
    }

    @Test
    public void shouldFindByKey() throws Exception {
        Optional optionalCategory = this.categoryRepository.findByKey("my-category", "DEFAULT");
        Assert.assertTrue((boolean)optionalCategory.isPresent());
        Assert.assertEquals((Object)"123", (Object)((Category)optionalCategory.get()).getId());
    }

    @Test
    public void shouldFindByPage() throws Exception {
        Set categories = this.categoryRepository.findByPage("documentationPageId");
        Assert.assertNotNull((Object)categories);
        Assert.assertFalse((boolean)categories.isEmpty());
        Assert.assertEquals((long)3L, (long)categories.size());
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set categories = this.categoryRepository.findAll();
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)4L, (long)categories.size());
    }

    @Test
    public void shouldFindAllByEnvironment() throws Exception {
        Set categories = this.categoryRepository.findAllByEnvironment("DEFAULT");
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)4L, (long)categories.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        Category category = new Category();
        category.setId("fd19297e-01a3-4828-9929-7e01a3782809");
        category.setKey("new-category");
        category.setEnvironmentId("DEFAULT");
        category.setName("Category name");
        category.setDescription("Description for the new category");
        category.setCreatedAt(new Date(1486771200000L));
        category.setUpdatedAt(new Date(1486771200000L));
        category.setHidden(true);
        category.setOrder(1);
        category.setPicture("New picture");
        category.setBackground("New background");
        category.setPage("documentationPageId");
        int nbCategorysBeforeCreation = this.categoryRepository.findAll().size();
        this.categoryRepository.create(category);
        int nbCategorysAfterCreation = this.categoryRepository.findAll().size();
        Assert.assertEquals((long)(nbCategorysBeforeCreation + 1), (long)nbCategorysAfterCreation);
        Optional optional = this.categoryRepository.findById("fd19297e-01a3-4828-9929-7e01a3782809");
        Assert.assertTrue((String)"Category saved not found", (boolean)optional.isPresent());
        Category categorySaved = (Category)optional.get();
        Assert.assertEquals((String)"Invalid saved category id.", (Object)category.getId(), (Object)categorySaved.getId());
        Assert.assertEquals((String)"Invalid saved category key.", (Object)category.getKey(), (Object)categorySaved.getKey());
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)category.getEnvironmentId(), (Object)categorySaved.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved category name.", (Object)category.getName(), (Object)categorySaved.getName());
        Assert.assertEquals((String)"Invalid category description.", (Object)category.getDescription(), (Object)categorySaved.getDescription());
        Assert.assertTrue((String)"Invalid category createdAt.", (boolean)DateUtils.compareDate(category.getCreatedAt(), categorySaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid category updatedAt.", (boolean)DateUtils.compareDate(category.getUpdatedAt(), categorySaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid category hidden.", (Object)category.isHidden(), (Object)categorySaved.isHidden());
        Assert.assertEquals((String)"Invalid category order.", (long)category.getOrder(), (long)categorySaved.getOrder());
        Assert.assertEquals((String)"Invalid category picture.", (Object)"New picture", (Object)categorySaved.getPicture());
        Assert.assertEquals((String)"Invalid category background.", (Object)"New background", (Object)categorySaved.getBackground());
        Assert.assertEquals((String)"Invalid category page.", (Object)"documentationPageId", (Object)categorySaved.getPage());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.categoryRepository.findById("products");
        Assert.assertTrue((String)"Category to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved category name.", (Object)"Products", (Object)((Category)optional.get()).getName());
        Category category = (Category)optional.get();
        category.setName("New product");
        category.setDescription("New description");
        category.setOrder(10);
        category.setHidden(true);
        category.setCreatedAt(new Date(1486771200000L));
        category.setUpdatedAt(new Date(1486771200000L));
        category.setHighlightApi("new Highlighted API");
        category.setPicture("New picture");
        category.setBackground("New background");
        category.setPage("documentationPageId");
        int nbCategorysBeforeUpdate = this.categoryRepository.findAll().size();
        this.categoryRepository.update(category);
        int nbCategorysAfterUpdate = this.categoryRepository.findAll().size();
        Assert.assertEquals((long)nbCategorysBeforeUpdate, (long)nbCategorysAfterUpdate);
        Optional optionalUpdated = this.categoryRepository.findById("products");
        Assert.assertTrue((String)"Category to update not found", (boolean)optionalUpdated.isPresent());
        Category categoryUpdated = (Category)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)category.getEnvironmentId(), (Object)categoryUpdated.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved category name.", (Object)category.getName(), (Object)categoryUpdated.getName());
        Assert.assertEquals((String)"Invalid category description.", (Object)category.getDescription(), (Object)categoryUpdated.getDescription());
        Assert.assertTrue((String)"Invalid category createdAt.", (boolean)DateUtils.compareDate(category.getCreatedAt(), categoryUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid category updatedAt.", (boolean)DateUtils.compareDate(category.getUpdatedAt(), categoryUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid category hidden.", (Object)category.isHidden(), (Object)categoryUpdated.isHidden());
        Assert.assertEquals((String)"Invalid category order.", (long)category.getOrder(), (long)categoryUpdated.getOrder());
        Assert.assertEquals((String)"Invalid category highlight API.", (Object)category.getHighlightApi(), (Object)categoryUpdated.getHighlightApi());
        Assert.assertEquals((String)"Invalid category picture.", (Object)"New picture", (Object)categoryUpdated.getPicture());
        Assert.assertEquals((String)"Invalid category background.", (Object)"New background", (Object)categoryUpdated.getBackground());
        Assert.assertEquals((String)"Invalid category page.", (Object)"documentationPageId", (Object)categoryUpdated.getPage());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbCategorysBeforeDeletion = this.categoryRepository.findAll().size();
        this.categoryRepository.delete("international");
        int nbCategorysAfterDeletion = this.categoryRepository.findAll().size();
        Assert.assertEquals((long)(nbCategorysBeforeDeletion - 1), (long)nbCategorysAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownCategory() throws Exception {
        Category unknownCategory = new Category();
        unknownCategory.setId("unknown");
        this.categoryRepository.update(unknownCategory);
        Assert.fail((String)"An unknown category should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.categoryRepository.update(null);
        Assert.fail((String)"A null category should not be updated");
    }
}

