/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.ClientRegistrationProvider;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ClientRegistrationProviderRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/clientregistrationprovider-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set clientRegistrationProviders = this.clientRegistrationProviderRepository.findAll();
        Assert.assertNotNull((Object)clientRegistrationProviders);
        Assert.assertEquals((long)3L, (long)clientRegistrationProviders.size());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional clientRegistrationProviderOpt = this.clientRegistrationProviderRepository.findById((Object)"oidc3");
        Assert.assertNotNull((Object)clientRegistrationProviderOpt);
        Assert.assertTrue((boolean)clientRegistrationProviderOpt.isPresent());
        ClientRegistrationProvider clientRegistrationProvider = (ClientRegistrationProvider)clientRegistrationProviderOpt.get();
        Assert.assertNotNull((Object)clientRegistrationProvider);
        Assert.assertEquals((Object)"OIDC-3", (Object)clientRegistrationProvider.getName());
        Assert.assertEquals((Object)"OIDC Client registration provider", (Object)clientRegistrationProvider.getDescription());
        Assert.assertEquals((Object)"http://localhost:8092/oidc/.well-known/openid-configuration", (Object)clientRegistrationProvider.getDiscoveryEndpoint());
        Assert.assertEquals((Object)ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS, (Object)clientRegistrationProvider.getInitialAccessTokenType());
        Assert.assertEquals((Object)"my-client-id", (Object)clientRegistrationProvider.getClientId());
        Assert.assertEquals((Object)"my-client-secret", (Object)clientRegistrationProvider.getClientSecret());
        Assert.assertEquals((long)3L, (long)clientRegistrationProvider.getScopes().size());
        Assert.assertEquals((Object)"scope1", clientRegistrationProvider.getScopes().iterator().next());
        Assert.assertTrue((boolean)clientRegistrationProvider.isRenewClientSecretSupport());
        Assert.assertEquals((Object)"http://localhost/endpoint", (Object)clientRegistrationProvider.getRenewClientSecretEndpoint());
        Assert.assertEquals((Object)"POST", (Object)clientRegistrationProvider.getRenewClientSecretMethod());
    }

    @Test
    public void shouldCreate() throws Exception {
        ClientRegistrationProvider clientRegistrationProvider = new ClientRegistrationProvider();
        clientRegistrationProvider.setId("new-dcr");
        clientRegistrationProvider.setName("new DCR");
        clientRegistrationProvider.setDescription("Description for my new DCR");
        clientRegistrationProvider.setDiscoveryEndpoint("http://localhost:8092/oidc/.well-known/openid-configuration");
        clientRegistrationProvider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
        clientRegistrationProvider.setClientId("my-client-id");
        clientRegistrationProvider.setClientSecret("my-client-secret");
        clientRegistrationProvider.setScopes(Arrays.asList("scope1", "scope2", "scope3"));
        clientRegistrationProvider.setCreatedAt(new Date(1000000000000L));
        clientRegistrationProvider.setUpdatedAt(new Date(1486771200000L));
        int nbClientRegistrationProvidersBeforeCreation = this.clientRegistrationProviderRepository.findAll().size();
        this.clientRegistrationProviderRepository.create((Object)clientRegistrationProvider);
        int nbClientRegistrationProvidersAfterCreation = this.clientRegistrationProviderRepository.findAll().size();
        Assert.assertEquals((long)(nbClientRegistrationProvidersBeforeCreation + 1), (long)nbClientRegistrationProvidersAfterCreation);
        Optional optional = this.clientRegistrationProviderRepository.findById((Object)"new-dcr");
        Assert.assertTrue((String)"Client registration provider saved not found", (boolean)optional.isPresent());
        ClientRegistrationProvider clientRegistrationProviderSaved = (ClientRegistrationProvider)optional.get();
        Assert.assertEquals((String)"Invalid saved client registration provider name.", (Object)clientRegistrationProvider.getName(), (Object)clientRegistrationProviderSaved.getName());
        Assert.assertEquals((String)"Invalid client registration provider description.", (Object)clientRegistrationProvider.getDescription(), (Object)clientRegistrationProviderSaved.getDescription());
        Assert.assertTrue((String)"Invalid client registration provider createdAt.", (boolean)DateUtils.compareDate(clientRegistrationProvider.getCreatedAt(), clientRegistrationProviderSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid client registration provider updatedAt.", (boolean)DateUtils.compareDate(clientRegistrationProvider.getUpdatedAt(), clientRegistrationProviderSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid client registration provider discovery endpoint.", (Object)clientRegistrationProvider.getDiscoveryEndpoint(), (Object)clientRegistrationProviderSaved.getDiscoveryEndpoint());
        Assert.assertEquals((String)"Invalid client registration provider initial access token type.", (Object)clientRegistrationProvider.getInitialAccessTokenType(), (Object)clientRegistrationProviderSaved.getInitialAccessTokenType());
        Assert.assertEquals((String)"Invalid client registration provider client id.", (Object)clientRegistrationProvider.getClientId(), (Object)clientRegistrationProviderSaved.getClientId());
        Assert.assertEquals((String)"Invalid client registration provider client secret.", (Object)clientRegistrationProvider.getClientSecret(), (Object)clientRegistrationProviderSaved.getClientSecret());
        Assert.assertEquals((String)"Invalid client registration provider scopes.", (long)clientRegistrationProvider.getScopes().size(), (long)clientRegistrationProviderSaved.getScopes().size());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.clientRegistrationProviderRepository.findById((Object)"oidc1");
        Assert.assertTrue((String)"Client registration provider to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved client registration provider name.", (Object)"OIDC-1", (Object)((ClientRegistrationProvider)optional.get()).getName());
        ClientRegistrationProvider identityProvider = (ClientRegistrationProvider)optional.get();
        identityProvider.setName("OIDC-1");
        identityProvider.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
        identityProvider.setDescription("OIDC 1 Client registration provider");
        identityProvider.setCreatedAt(new Date(1000000000000L));
        identityProvider.setUpdatedAt(new Date(1486771200000L));
        int nbIdentityProvidersBeforeUpdate = this.clientRegistrationProviderRepository.findAll().size();
        this.clientRegistrationProviderRepository.update((Object)identityProvider);
        int nbIdentityProvidersAfterUpdate = this.clientRegistrationProviderRepository.findAll().size();
        Assert.assertEquals((long)nbIdentityProvidersBeforeUpdate, (long)nbIdentityProvidersAfterUpdate);
        Optional optionalUpdated = this.clientRegistrationProviderRepository.findById((Object)"oidc1");
        Assert.assertTrue((String)"Client registration provider to update not found", (boolean)optionalUpdated.isPresent());
        ClientRegistrationProvider identityProviderUpdated = (ClientRegistrationProvider)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved client registration provider name.", (Object)identityProvider.getName(), (Object)identityProviderUpdated.getName());
        Assert.assertEquals((String)"Invalid client registration provider description.", (Object)identityProvider.getDescription(), (Object)identityProviderUpdated.getDescription());
        Assert.assertTrue((String)"Invalid client registration provider createdAt.", (boolean)DateUtils.compareDate(identityProvider.getCreatedAt(), identityProviderUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid client registration provider updatedAt.", (boolean)DateUtils.compareDate(identityProvider.getUpdatedAt(), identityProviderUpdated.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbClientRegistrationProvidersBeforeDeletion = this.clientRegistrationProviderRepository.findAll().size();
        this.clientRegistrationProviderRepository.delete((Object)"oidc3");
        int nbClientRegistrationProvidersAfterDeletion = this.clientRegistrationProviderRepository.findAll().size();
        Assert.assertEquals((long)(nbClientRegistrationProvidersBeforeDeletion - 1), (long)nbClientRegistrationProvidersAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownClientRegistrationProvider() throws Exception {
        ClientRegistrationProvider unknownClientRegistrationProvider = new ClientRegistrationProvider();
        unknownClientRegistrationProvider.setId("unknown");
        this.clientRegistrationProviderRepository.update((Object)unknownClientRegistrationProvider);
        Assert.fail((String)"An unknown client registration provider should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.clientRegistrationProviderRepository.update(null);
        Assert.fail((String)"A null client registration provider should not be updated");
    }
}

