/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class CommandRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/command-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        Optional optMessage = this.commandRepository.findById((Object)"msg-to-create");
        Assert.assertTrue((boolean)optMessage.isPresent());
        Command command = (Command)optMessage.get();
        Assert.assertEquals((String)"id", (Object)"msg-to-create", (Object)command.getId());
        Assert.assertEquals((String)"environment id", (Object)"DEFAULT", (Object)command.getEnvironmentId());
        Assert.assertEquals((String)"to", (Object)"someone", (Object)command.getTo());
        Assert.assertTrue((String)"tags: DATA_TO_INDEX", (boolean)command.getTags().contains("DATA_TO_INDEX"));
        Assert.assertTrue((String)"tags: INSERT", (boolean)command.getTags().contains("INSERT"));
        Assert.assertEquals((String)"content", (Object)"Hello, is it me you're looking for?", (Object)command.getContent());
        Assert.assertTrue((String)"acknowledgments: 1", (boolean)command.getAcknowledgments().contains("1"));
        Assert.assertTrue((String)"acknowledgments: a", (boolean)command.getAcknowledgments().contains("a"));
        Assert.assertTrue((String)"createdAt", (boolean)DateUtils.compareDate(new Date(1546305346000L), command.getCreatedAt()));
        Assert.assertTrue((String)"updatedAt", (boolean)DateUtils.compareDate(new Date(1548983746000L), command.getUpdatedAt()));
        Assert.assertTrue((String)"deleteAt", (boolean)DateUtils.compareDate(new Date(1551402946000L), command.getExpiredAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Command command = new Command();
        command.setId("msg-to-update");
        command.setEnvironmentId("new_DEFAULT");
        command.setFrom("from updated");
        command.setTo("message updated");
        command.setTags(Collections.singletonList("DELETE"));
        command.setContent("updated content");
        command.setAcknowledgments(Arrays.asList("up", "date"));
        command.setCreatedAt(new Date(1546405346000L));
        command.setUpdatedAt(new Date(1546505346000L));
        command.setExpiredAt(new Date(1546605346000L));
        Command updatedCommand = (Command)this.commandRepository.update((Object)command);
        Assert.assertEquals((String)"id", (Object)command.getId(), (Object)updatedCommand.getId());
        Assert.assertEquals((String)"environmment id.", (Object)command.getEnvironmentId(), (Object)updatedCommand.getEnvironmentId());
        Assert.assertEquals((String)"to", (Object)command.getTo(), (Object)updatedCommand.getTo());
        Assert.assertEquals((String)"from", (Object)command.getFrom(), (Object)updatedCommand.getFrom());
        Assert.assertTrue((String)"tags: DATA_TO_INDEX", (boolean)command.getTags().containsAll(updatedCommand.getTags()));
        Assert.assertEquals((String)"content", (Object)command.getContent(), (Object)updatedCommand.getContent());
        Assert.assertTrue((String)("acknowledgments: " + updatedCommand.getAcknowledgments().size() + "/" + command.getAcknowledgments().size()), (boolean)command.getAcknowledgments().containsAll(updatedCommand.getAcknowledgments()));
        Assert.assertTrue((String)"createdAt", (boolean)DateUtils.compareDate(command.getCreatedAt(), updatedCommand.getCreatedAt()));
        Assert.assertTrue((String)"updatedAt", (boolean)DateUtils.compareDate(command.getUpdatedAt(), updatedCommand.getUpdatedAt()));
        Assert.assertTrue((String)"deleteAt", (boolean)DateUtils.compareDate(command.getExpiredAt(), updatedCommand.getExpiredAt()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownMessage() throws Exception {
        Command unknownCommand = new Command();
        this.commandRepository.update((Object)unknownCommand);
        Assert.fail((String)"An unknown message should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.commandRepository.update(null);
        Assert.fail((String)"A null message should not be updated");
    }

    @Test
    public void shouldDelete() throws Exception {
        String idToDelete = "msg-to-delete";
        Optional message = this.commandRepository.findById((Object)idToDelete);
        Assert.assertTrue((String)"msg should exists before being deleted", (boolean)message.isPresent());
        this.commandRepository.delete((Object)idToDelete);
        message = this.commandRepository.findById((Object)idToDelete);
        Assert.assertFalse((String)"msg should not exists after being deleted", (boolean)message.isPresent());
    }

    @Test
    public void shouldSearchByNotFrom() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().notFrom("node1").build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)5L, (long)commands.size());
        List ids = commands.stream().map(Command::getId).collect(Collectors.toList());
        Assert.assertFalse((String)"not contain 'search1'", (boolean)ids.contains("search1"));
        Assert.assertTrue((String)"contain 'search2'", (boolean)ids.contains("search2"));
        Assert.assertTrue((String)"contain 'search3'", (boolean)ids.contains("search3"));
    }

    @Test
    public void shouldSearchByTo() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().to("node1").build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)1L, (long)commands.size());
        Assert.assertEquals((String)"contain 'search3'", (Object)"search3", (Object)((Command)commands.get(0)).getId());
    }

    @Test
    public void shouldSearchByTag() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().tags(new String[]{"INSERT"}).build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)4L, (long)commands.size());
        List ids = commands.stream().map(Command::getId).collect(Collectors.toList());
        Assert.assertTrue((String)"contain 'msg-to-create'", (boolean)ids.contains("msg-to-create"));
        Assert.assertTrue((String)"contain 'msg-to-update'", (boolean)ids.contains("msg-to-update"));
        Assert.assertTrue((String)"contain 'search1'", (boolean)ids.contains("search1"));
        Assert.assertTrue((String)"contain 'search2'", (boolean)ids.contains("search2"));
    }

    @Test
    public void shouldSearchByTags() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().tags(new String[]{"DATA_TO_INDEX", "DELETE"}).build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)1L, (long)commands.size());
        Assert.assertEquals((String)"contain 'search3'", (Object)"search3", (Object)((Command)commands.get(0)).getId());
    }

    @Test
    public void shouldSearchByNotAck() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().notAckBy("node3").build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)4L, (long)commands.size());
        List ids = commands.stream().map(Command::getId).collect(Collectors.toList());
        Assert.assertFalse((String)"not contain 'search1'", (boolean)ids.contains("search1"));
        Assert.assertFalse((String)"not contain 'search3'", (boolean)ids.contains("search3"));
    }

    @Test
    public void shouldSearchByNotDeleted() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().notDeleted().build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)1L, (long)commands.size());
        Assert.assertEquals((String)"contain 'search2'", (Object)"search2", (Object)((Command)commands.get(0)).getId());
    }

    @Test
    public void shouldSearchByEnvironment() {
        List commands = this.commandRepository.search(new CommandCriteria.Builder().environmentId("DEFAULT").build());
        Assert.assertNotNull((String)"not null", (Object)commands);
        Assert.assertFalse((String)"not empty", (boolean)commands.isEmpty());
        Assert.assertEquals((String)"result size", (long)1L, (long)commands.size());
        Assert.assertEquals((String)"contain 'msg-to-create'", (Object)"msg-to-create", (Object)((Command)commands.get(0)).getId());
    }
}

