/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.CustomUserField;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CustomUserFieldsRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/customuserfields-tests/";
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optionalCustomUserField = this.customUserFieldsRepository.findById("string", "DEFAULT", CustomUserFieldReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)optionalCustomUserField);
        Assert.assertTrue((boolean)optionalCustomUserField.isPresent());
        Assert.assertEquals((String)"FindById('string, default) : Invalid CustomUserField.key", (Object)"string", (Object)((CustomUserField)optionalCustomUserField.get()).getKey());
        Assert.assertEquals((String)"FindById('string, default) : Invalid CustomUserField.refId", (Object)"DEFAULT", (Object)((CustomUserField)optionalCustomUserField.get()).getReferenceId());
        Assert.assertEquals((String)"FindById('string, default) : Invalid CustomUserField.refType", (Object)CustomUserFieldReferenceType.ORGANIZATION, (Object)((CustomUserField)optionalCustomUserField.get()).getReferenceType());
        Assert.assertEquals((String)"FindById('string, default) : Invalid CustomUserField.label", (Object)"String", (Object)((CustomUserField)optionalCustomUserField.get()).getLabel());
        Assert.assertFalse((String)"FindById('string, default) : Invalid CustomUserField.required", (boolean)((CustomUserField)optionalCustomUserField.get()).isRequired());
        Assert.assertTrue((String)"FindById('string, default) : Invalid CustomUserField.createdAt", (boolean)DateUtils.compareDate(new Date(1486771200000L), ((CustomUserField)optionalCustomUserField.get()).getCreatedAt()));
        Assert.assertTrue((String)"FindById('string, default) : Invalid CustomUserField.updatedAt", (boolean)DateUtils.compareDate(new Date(1486771200000L), ((CustomUserField)optionalCustomUserField.get()).getUpdatedAt()));
        Assert.assertNotNull((String)"FindById('string, default) : Invalid CustomUserField.values", (Object)((CustomUserField)optionalCustomUserField.get()).getValues());
        Assert.assertThat((String)"FindById('string, default) : Invalid CustomUserField.values", (Object)((CustomUserField)optionalCustomUserField.get()).getValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test_values"}));
    }

    @Test
    public void shouldFindByRef() throws Exception {
        List customUserFields = this.customUserFieldsRepository.findByReferenceIdAndReferenceType("DEFAULT", CustomUserFieldReferenceType.ORGANIZATION);
        Assert.assertNotNull((String)"FindByRef(Default) Should return non null list ", (Object)customUserFields);
        Assert.assertEquals((String)"FindByRef(Default) Should return 4 elements", (long)4L, (long)customUserFields.size());
        Assert.assertThat(customUserFields.stream().map(CustomUserField::getKey).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"string", "boolean", "updateKey", "deleteKey"}));
    }

    @Test
    public void shouldCreate() throws Exception {
        CustomUserField newCufCustomUserField = new CustomUserField();
        newCufCustomUserField.setKey("newkey");
        newCufCustomUserField.setLabel("newkeyLabel");
        newCufCustomUserField.setReferenceId("DEFAULT");
        newCufCustomUserField.setReferenceType(CustomUserFieldReferenceType.ORGANIZATION);
        newCufCustomUserField.setFormat(MetadataFormat.MAIL);
        newCufCustomUserField.setRequired(false);
        newCufCustomUserField.setValues(Arrays.asList("test@domain.net"));
        Optional beforeCreateBean = this.customUserFieldsRepository.findById(newCufCustomUserField.getKey(), newCufCustomUserField.getReferenceId(), CustomUserFieldReferenceType.ORGANIZATION);
        CustomUserField createdCustomUserField = this.customUserFieldsRepository.create(newCufCustomUserField);
        Optional afterCreateBean = this.customUserFieldsRepository.findById(newCufCustomUserField.getKey(), newCufCustomUserField.getReferenceId(), CustomUserFieldReferenceType.ORGANIZATION);
        Assert.assertNotNull((String)"customUserFieldsRepository.create should return an CustomUserField", (Object)createdCustomUserField);
        Assert.assertNotNull((Object)beforeCreateBean);
        Assert.assertFalse((String)"customUserFieldsRepository should not found value before create", (boolean)beforeCreateBean.isPresent());
        Assert.assertNotNull((Object)afterCreateBean);
        Assert.assertTrue((String)"customUserFieldsRepository should found value before create", (boolean)afterCreateBean.isPresent());
        Assert.assertEquals((String)"Invalid CustomUserField.key", (Object)newCufCustomUserField.getKey(), (Object)((CustomUserField)afterCreateBean.get()).getKey());
        Assert.assertEquals((String)"Invalid CustomUserField.label", (Object)newCufCustomUserField.getLabel(), (Object)((CustomUserField)afterCreateBean.get()).getLabel());
        Assert.assertEquals((String)"Invalid CustomUserField.format", (Object)newCufCustomUserField.getFormat(), (Object)((CustomUserField)afterCreateBean.get()).getFormat());
        Assert.assertEquals((String)"Invalid CustomUserField.refId", (Object)newCufCustomUserField.getReferenceId(), (Object)((CustomUserField)afterCreateBean.get()).getReferenceId());
        Assert.assertEquals((String)"Invalid CustomUserField.refType", (Object)newCufCustomUserField.getReferenceType(), (Object)((CustomUserField)afterCreateBean.get()).getReferenceType());
        Assert.assertEquals((String)"Invalid CustomUserField.values", ((CustomUserField)afterCreateBean.get()).getValues().get(0), newCufCustomUserField.getValues().get(0));
        Assert.assertEquals((String)"Invalid CustomUserField.key", (Object)newCufCustomUserField.getKey(), (Object)createdCustomUserField.getKey());
        Assert.assertEquals((String)"Invalid CustomUserField.label", (Object)newCufCustomUserField.getLabel(), (Object)createdCustomUserField.getLabel());
        Assert.assertEquals((String)"Invalid CustomUserField.format", (Object)newCufCustomUserField.getFormat(), (Object)createdCustomUserField.getFormat());
        Assert.assertEquals((String)"Invalid CustomUserField.refId", (Object)newCufCustomUserField.getReferenceId(), (Object)createdCustomUserField.getReferenceId());
        Assert.assertEquals((String)"Invalid CustomUserField.refType", (Object)newCufCustomUserField.getReferenceType(), (Object)createdCustomUserField.getReferenceType());
        Assert.assertEquals((String)"Invalid CustomUserField.values", createdCustomUserField.getValues().get(0), newCufCustomUserField.getValues().get(0));
    }

    @Test
    public void shouldUpdate() throws Exception {
        CustomUserField customUserField = new CustomUserField();
        customUserField.setKey("updateKey");
        customUserField.setLabel("LabelUPDATED");
        customUserField.setReferenceId("DEFAULT");
        customUserField.setReferenceType(CustomUserFieldReferenceType.ORGANIZATION);
        customUserField.setFormat(MetadataFormat.MAIL);
        customUserField.setRequired(true);
        customUserField.setValues(Arrays.asList("test@domain.net2"));
        Optional beforeUpdateBean = this.customUserFieldsRepository.findById(customUserField.getKey(), customUserField.getReferenceId(), customUserField.getReferenceType());
        CustomUserField updatedCustomUserField = this.customUserFieldsRepository.update(customUserField);
        Optional afterUpdateBean = this.customUserFieldsRepository.findById(customUserField.getKey(), customUserField.getReferenceId(), customUserField.getReferenceType());
        Assert.assertNotNull((Object)customUserField);
        Assert.assertNotNull((Object)beforeUpdateBean);
        Assert.assertTrue((boolean)beforeUpdateBean.isPresent());
        Assert.assertNotNull((Object)afterUpdateBean);
        Assert.assertTrue((boolean)afterUpdateBean.isPresent());
        Assert.assertNotNull((Object)updatedCustomUserField);
        Assert.assertEquals((String)"Invalid CustomUserField.key", (Object)customUserField.getKey(), (Object)((CustomUserField)afterUpdateBean.get()).getKey());
        Assert.assertEquals((String)"Invalid CustomUserField.label", (Object)customUserField.getLabel(), (Object)((CustomUserField)afterUpdateBean.get()).getLabel());
        Assert.assertEquals((String)"Invalid CustomUserField.format", (Object)customUserField.getFormat(), (Object)((CustomUserField)afterUpdateBean.get()).getFormat());
        Assert.assertEquals((String)"Invalid CustomUserField.refId", (Object)customUserField.getReferenceId(), (Object)((CustomUserField)afterUpdateBean.get()).getReferenceId());
        Assert.assertEquals((String)"Invalid CustomUserField.values.size = 1", (long)customUserField.getValues().size(), (long)((CustomUserField)afterUpdateBean.get()).getValues().size());
        Assert.assertEquals((String)"Invalid CustomUserField.key", (Object)customUserField.getKey(), (Object)((CustomUserField)afterUpdateBean.get()).getKey());
        Assert.assertEquals((String)"Invalid CustomUserField.refId", (Object)((CustomUserField)beforeUpdateBean.get()).getReferenceId(), (Object)((CustomUserField)afterUpdateBean.get()).getReferenceId());
        Assert.assertEquals((String)"Invalid CustomUserField.format", (Object)((CustomUserField)beforeUpdateBean.get()).getFormat(), (Object)((CustomUserField)afterUpdateBean.get()).getFormat());
        Assert.assertNotEquals((String)"Invalid CustomUserField.label", (Object)((CustomUserField)beforeUpdateBean.get()).getLabel(), (Object)((CustomUserField)afterUpdateBean.get()).getLabel());
        Assert.assertNotEquals((String)"Invalid CustomUserField.required", (Object)((CustomUserField)beforeUpdateBean.get()).isRequired(), (Object)((CustomUserField)afterUpdateBean.get()).isRequired());
        Assert.assertTrue((String)"Invalid CustomUserField.values.empty", (((CustomUserField)beforeUpdateBean.get()).getValues() == null || ((CustomUserField)beforeUpdateBean.get()).getValues().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void shouldDelete() throws Exception {
        Optional beforeDelete = this.customUserFieldsRepository.findById("deleteKey", "DEFAULT", CustomUserFieldReferenceType.ORGANIZATION);
        this.customUserFieldsRepository.delete("deleteKey", "DEFAULT", CustomUserFieldReferenceType.ORGANIZATION);
        Optional afterDelete = this.customUserFieldsRepository.findById("deleteKey", "DEFAULT", CustomUserFieldReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)beforeDelete);
        Assert.assertTrue((boolean)beforeDelete.isPresent());
        Assert.assertNotNull((Object)afterDelete);
        Assert.assertFalse((boolean)afterDelete.isPresent());
    }
}

