/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Dashboard;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DashboardRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/dashboard-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set dashboards = this.dashboardRepository.findAll();
        Assert.assertNotNull((Object)dashboards);
        Assert.assertEquals((long)4L, (long)dashboards.size());
    }

    @Test
    public void shouldFindByReferenceType() throws Exception {
        List dashboards = this.dashboardRepository.findByReferenceType("PLATFORM");
        Assert.assertNotNull((Object)dashboards);
        Assert.assertEquals((long)3L, (long)dashboards.size());
        Dashboard dashboardProduct = dashboards.stream().filter(dashboard -> "4eeb1c56-6f4a-4925-ab1c-566f4aa925b8".equals(dashboard.getId())).findAny().get();
        Assert.assertEquals((Object)"Geo dashboard", (Object)dashboardProduct.getName());
        Iterator iterator = dashboards.iterator();
        Assert.assertEquals((Object)"Global dashboard", (Object)((Dashboard)iterator.next()).getName());
        Assert.assertEquals((Object)"Geo dashboard", (Object)((Dashboard)iterator.next()).getName());
        Assert.assertEquals((Object)"Device dashboard", (Object)((Dashboard)iterator.next()).getName());
    }

    @Test
    public void shouldCreate() throws Exception {
        Dashboard dashboard = new Dashboard();
        dashboard.setId("new-dashboard");
        dashboard.setReferenceType("API");
        dashboard.setReferenceId("DEFAULT");
        dashboard.setName("Dashboard name");
        dashboard.setQueryFilter("api:apiId");
        dashboard.setOrder(1);
        dashboard.setEnabled(true);
        dashboard.setDefinition("{\"def\": \"value\"}");
        dashboard.setCreatedAt(new Date(1000000000000L));
        dashboard.setUpdatedAt(new Date(1111111111111L));
        int nbDashboardsBeforeCreation = this.dashboardRepository.findByReferenceType("API").size();
        this.dashboardRepository.create((Object)dashboard);
        int nbDashboardsAfterCreation = this.dashboardRepository.findByReferenceType("API").size();
        Assert.assertEquals((long)(nbDashboardsBeforeCreation + 1), (long)nbDashboardsAfterCreation);
        Optional optional = this.dashboardRepository.findById((Object)"new-dashboard");
        Assert.assertTrue((String)"Dashboard saved not found", (boolean)optional.isPresent());
        Dashboard dashboardSaved = (Dashboard)optional.get();
        Assert.assertEquals((String)"Invalid saved dashboard id.", (Object)dashboard.getId(), (Object)dashboardSaved.getId());
        Assert.assertEquals((String)"Invalid saved dashboard reference id.", (Object)dashboard.getReferenceId(), (Object)dashboardSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid saved dashboard reference type.", (Object)dashboard.getReferenceType(), (Object)dashboardSaved.getReferenceType());
        Assert.assertEquals((String)"Invalid saved dashboard name.", (Object)dashboard.getName(), (Object)dashboardSaved.getName());
        Assert.assertEquals((String)"Invalid saved dashboard query filter.", (Object)dashboard.getQueryFilter(), (Object)dashboardSaved.getQueryFilter());
        Assert.assertEquals((String)"Invalid saved dashboard order.", (long)dashboard.getOrder(), (long)dashboardSaved.getOrder());
        Assert.assertEquals((String)"Invalid saved dashboard enabled.", (Object)dashboard.isEnabled(), (Object)dashboardSaved.isEnabled());
        Assert.assertEquals((String)"Invalid saved dashboard definition.", (Object)dashboard.getDefinition(), (Object)dashboardSaved.getDefinition());
        Assert.assertTrue((String)"Invalid saved dashboard created at.", (boolean)DateUtils.compareDate(dashboard.getCreatedAt(), dashboardSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid saved dashboard updated at.", (boolean)DateUtils.compareDate(dashboard.getUpdatedAt(), dashboardSaved.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.dashboardRepository.findById((Object)"6e0d09f0-ba5d-4571-8d09-f0ba5d7571c3");
        Assert.assertTrue((String)"Dashboard to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved dashboard name.", (Object)"Device dashboard", (Object)((Dashboard)optional.get()).getName());
        Dashboard dashboard = (Dashboard)optional.get();
        dashboard.setReferenceType("PLATFORM");
        dashboard.setReferenceId("1");
        dashboard.setName("New dashboard");
        dashboard.setQueryFilter("api:apiId");
        dashboard.setOrder(3);
        dashboard.setEnabled(true);
        dashboard.setDefinition("{\"def\": \"new value\"}");
        dashboard.setCreatedAt(new Date(1111111111111L));
        dashboard.setUpdatedAt(new Date(1000000000000L));
        int nbDashboardsBeforeUpdate = this.dashboardRepository.findByReferenceType("PLATFORM").size();
        this.dashboardRepository.update((Object)dashboard);
        int nbDashboardsAfterUpdate = this.dashboardRepository.findByReferenceType("PLATFORM").size();
        Assert.assertEquals((long)nbDashboardsBeforeUpdate, (long)nbDashboardsAfterUpdate);
        Optional optionalUpdated = this.dashboardRepository.findById((Object)"6e0d09f0-ba5d-4571-8d09-f0ba5d7571c3");
        Assert.assertTrue((String)"Dashboard to update not found", (boolean)optionalUpdated.isPresent());
        Dashboard dashboardSaved = (Dashboard)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved dashboard reference id.", (Object)"1", (Object)dashboardSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid saved dashboard name.", (Object)"New dashboard", (Object)dashboardSaved.getName());
        Assert.assertEquals((String)"Invalid saved dashboard query filter.", (Object)"api:apiId", (Object)dashboardSaved.getQueryFilter());
        Assert.assertEquals((String)"Invalid saved dashboard order.", (long)3L, (long)dashboardSaved.getOrder());
        Assert.assertTrue((String)"Invalid saved dashboard enabled.", (boolean)dashboardSaved.isEnabled());
        Assert.assertEquals((String)"Invalid saved dashboard definition.", (Object)"{\"def\": \"new value\"}", (Object)dashboardSaved.getDefinition());
        Assert.assertTrue((String)"Invalid saved dashboard created at.", (boolean)DateUtils.compareDate(new Date(1111111111111L), dashboardSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid saved dashboard updated at.", (boolean)DateUtils.compareDate(new Date(1000000000000L), dashboardSaved.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbDashboardsBeforeDeletion = this.dashboardRepository.findByReferenceType("API").size();
        this.dashboardRepository.delete((Object)"7589ef82-02ae-4fc7-89ef-8202ae3fc7cf");
        int nbDashboardsAfterDeletion = this.dashboardRepository.findByReferenceType("API").size();
        Assert.assertEquals((long)(nbDashboardsBeforeDeletion - 1), (long)nbDashboardsAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownDashboard() throws Exception {
        Dashboard unknownDashboard = new Dashboard();
        unknownDashboard.setId("unknown");
        this.dashboardRepository.update((Object)unknownDashboard);
        Assert.fail((String)"An unknown dashboard should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.dashboardRepository.update(null);
        Assert.fail((String)"A null dashboard should not be updated");
    }
}

