/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.DictionaryType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DictionaryRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/dictionary-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set dictionaries = this.dictionaryRepository.findAll();
        Assert.assertNotNull((Object)dictionaries);
        Assert.assertEquals((long)3L, (long)dictionaries.size());
    }

    @Test
    public void shouldFindAllByEnvironment() throws Exception {
        Set dictionaries = this.dictionaryRepository.findAllByEnvironment("DEFAULT");
        Assert.assertNotNull((Object)dictionaries);
        Assert.assertEquals((long)3L, (long)dictionaries.size());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optionalDictionary = this.dictionaryRepository.findById((Object)"dic-1");
        Assert.assertNotNull((Object)optionalDictionary);
        Assert.assertTrue((boolean)optionalDictionary.isPresent());
        Dictionary dictionary = (Dictionary)optionalDictionary.get();
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)"DEFAULT", (Object)dictionary.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved dictionary name.", (Object)"My dic 1", (Object)dictionary.getName());
        Assert.assertEquals((String)"Invalid dictionary description.", (Object)"Description for my dic 1", (Object)dictionary.getDescription());
        Assert.assertTrue((String)"Invalid dictionary createdAt.", (boolean)DateUtils.compareDate(new Date(1000000000000L), dictionary.getCreatedAt()));
        Assert.assertTrue((String)"Invalid dictionary updatedAt.", (boolean)DateUtils.compareDate(new Date(1439032010883L), dictionary.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid dictionary properties.", (long)3L, (long)dictionary.getProperties().size());
        Assert.assertEquals((String)"Invalid dictionary property.", (Object)"127.0.0.1:8082", dictionary.getProperties().get("127.0.0.1:8082"));
    }

    @Test
    public void shouldCreate() throws Exception {
        Dictionary dictionary = new Dictionary();
        dictionary.setId("new-dictionary");
        dictionary.setEnvironmentId("DEFAULT");
        dictionary.setName("My dic 1");
        dictionary.setDescription("Description for my dic 1");
        dictionary.setCreatedAt(new Date(1000000000000L));
        dictionary.setUpdatedAt(new Date(1439032010883L));
        dictionary.setType(DictionaryType.MANUAL);
        int nbDictionariesBeforeCreation = this.dictionaryRepository.findAll().size();
        this.dictionaryRepository.create((Object)dictionary);
        int nbDictionariesAfterCreation = this.dictionaryRepository.findAll().size();
        Assert.assertEquals((long)(nbDictionariesBeforeCreation + 1), (long)nbDictionariesAfterCreation);
        Optional optional = this.dictionaryRepository.findById((Object)"new-dictionary");
        Assert.assertTrue((String)"Dictionary saved not found", (boolean)optional.isPresent());
        Dictionary dictionarySaved = (Dictionary)optional.get();
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)dictionary.getEnvironmentId(), (Object)dictionarySaved.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved dictionary name.", (Object)dictionary.getName(), (Object)dictionarySaved.getName());
        Assert.assertEquals((String)"Invalid dictionary description.", (Object)dictionary.getDescription(), (Object)dictionarySaved.getDescription());
        Assert.assertTrue((String)"Invalid dictionary createdAt.", (boolean)DateUtils.compareDate(dictionary.getCreatedAt(), dictionarySaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid dictionary updatedAt.", (boolean)DateUtils.compareDate(dictionary.getUpdatedAt(), dictionarySaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid dictionary type.", (Object)dictionary.getType(), (Object)dictionarySaved.getType());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.dictionaryRepository.findById((Object)"dic-1");
        Assert.assertTrue((String)"Dictionary to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved dictionary name.", (Object)"My dic 1", (Object)((Dictionary)optional.get()).getName());
        Dictionary dictionary = (Dictionary)optional.get();
        dictionary.setName("My dic 1");
        dictionary.setEnvironmentId("new_DEFAULT");
        dictionary.setDescription("Description for my dic 1");
        dictionary.setCreatedAt(new Date(1000000000000L));
        dictionary.setUpdatedAt(new Date(1486771200000L));
        dictionary.setType(DictionaryType.DYNAMIC);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("localhost", "localhost");
        properties.put("localhost:8082", "localhost:8082");
        properties.put("127.0.0.1:8082", "127.0.0.1:8082");
        dictionary.setProperties(properties);
        int nbDictionariesBeforeUpdate = this.dictionaryRepository.findAll().size();
        this.dictionaryRepository.update((Object)dictionary);
        int nbDictionariesAfterUpdate = this.dictionaryRepository.findAll().size();
        Assert.assertEquals((long)nbDictionariesBeforeUpdate, (long)nbDictionariesAfterUpdate);
        Optional optionalUpdated = this.dictionaryRepository.findById((Object)"dic-1");
        Assert.assertTrue((String)"Dictionary to update not found", (boolean)optionalUpdated.isPresent());
        Dictionary dictionaryUpdated = (Dictionary)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)dictionary.getEnvironmentId(), (Object)dictionaryUpdated.getEnvironmentId());
        Assert.assertEquals((String)"Invalid saved dictionary name.", (Object)dictionary.getName(), (Object)dictionaryUpdated.getName());
        Assert.assertEquals((String)"Invalid dictionary description.", (Object)dictionary.getDescription(), (Object)dictionaryUpdated.getDescription());
        Assert.assertTrue((String)"Invalid dictionary createdAt.", (boolean)DateUtils.compareDate(dictionary.getCreatedAt(), dictionaryUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid dictionary updatedAt.", (boolean)DateUtils.compareDate(dictionary.getUpdatedAt(), dictionaryUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid dictionary type.", (Object)dictionary.getType(), (Object)dictionaryUpdated.getType());
        Assert.assertEquals((String)"Invalid dictionary properties.", (Object)dictionary.getProperties(), (Object)dictionaryUpdated.getProperties());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbDictionariesBeforeDeletion = this.dictionaryRepository.findAll().size();
        this.dictionaryRepository.delete((Object)"dic-3");
        int nbDictionariesAfterDeletion = this.dictionaryRepository.findAll().size();
        Assert.assertEquals((long)(nbDictionariesBeforeDeletion - 1), (long)nbDictionariesAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownView() throws Exception {
        Dictionary unknownDictionary = new Dictionary();
        unknownDictionary.setId("unknown");
        this.dictionaryRepository.update((Object)unknownDictionary);
        Assert.fail((String)"An unknown dictionary should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.dictionaryRepository.update(null);
        Assert.fail((String)"A null dictionary should not be updated");
    }
}

