/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Entrypoint;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class EntrypointRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/entrypoint-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set entrypoints = this.entrypointRepository.findAll();
        Assert.assertNotNull((Object)entrypoints);
        Assert.assertEquals((long)3L, (long)entrypoints.size());
    }

    @Test
    public void shouldFindAllByuEnvironment() throws Exception {
        Set entrypoints = this.entrypointRepository.findAllByEnvironment("DEFAULT");
        Assert.assertNotNull((Object)entrypoints);
        Assert.assertEquals((long)3L, (long)entrypoints.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        Entrypoint entrypoint = new Entrypoint();
        entrypoint.setId("new-entrypoint");
        entrypoint.setEnvironmentId("DEFAULT");
        entrypoint.setValue("Entrypoint value");
        entrypoint.setTags("internal;product");
        int nbEntryPointsBeforeCreation = this.entrypointRepository.findAll().size();
        this.entrypointRepository.create((Object)entrypoint);
        int nbEntryPointsAfterCreation = this.entrypointRepository.findAll().size();
        Assert.assertEquals((long)(nbEntryPointsBeforeCreation + 1), (long)nbEntryPointsAfterCreation);
        Optional optional = this.entrypointRepository.findById((Object)"new-entrypoint");
        Assert.assertTrue((String)"Entrypoint saved not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved entrypoint.", (Object)entrypoint, optional.get());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.entrypointRepository.findById((Object)"fa29c012-a0d2-4721-a9c0-12a0d26721db");
        Assert.assertTrue((String)"EntryPoint to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved entrypoint value.", (Object)"https://public-api.company.com", (Object)((Entrypoint)optional.get()).getValue());
        Entrypoint entrypoint = (Entrypoint)optional.get();
        entrypoint.setValue("New value");
        entrypoint.setEnvironmentId("new_DEFAULT");
        entrypoint.setTags("New tags");
        int nbEntryPointsBeforeUpdate = this.entrypointRepository.findAll().size();
        this.entrypointRepository.update((Object)entrypoint);
        int nbEntryPointsAfterUpdate = this.entrypointRepository.findAll().size();
        Assert.assertEquals((long)nbEntryPointsBeforeUpdate, (long)nbEntryPointsAfterUpdate);
        Optional optionalUpdated = this.entrypointRepository.findById((Object)"fa29c012-a0d2-4721-a9c0-12a0d26721db");
        Assert.assertTrue((String)"Entrypoint saved not found", (boolean)optionalUpdated.isPresent());
        Assert.assertEquals((String)"Invalid saved entrypoint.", (Object)entrypoint, optionalUpdated.get());
        Assert.assertEquals((String)"Invalid saved value.", (Object)"New value", (Object)((Entrypoint)optionalUpdated.get()).getValue());
        Assert.assertEquals((String)"Invalid saved tags.", (Object)"New tags", (Object)((Entrypoint)optionalUpdated.get()).getTags());
        Assert.assertEquals((String)"Invalid saved environment.", (Object)"new_DEFAULT", (Object)((Entrypoint)optionalUpdated.get()).getEnvironmentId());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbEntryPointsBeforeDeletion = this.entrypointRepository.findAll().size();
        this.entrypointRepository.delete((Object)"fa29c012-a0d2-4721-a9c0-12a0d26721db");
        int nbEntryPointsAfterDeletion = this.entrypointRepository.findAll().size();
        Assert.assertEquals((long)(nbEntryPointsBeforeDeletion - 1), (long)nbEntryPointsAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownEntryPoint() throws Exception {
        Entrypoint unknownEntryPoint = new Entrypoint();
        unknownEntryPoint.setId("unknown");
        this.entrypointRepository.update((Object)unknownEntryPoint);
        Assert.fail((String)"An unknown entrypoint should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.entrypointRepository.update(null);
        Assert.fail((String)"A null entrypoint should not be updated");
    }
}

