/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Environment;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/environment-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        Environment environment = new Environment();
        environment.setId("DEFAULT-create");
        environment.setHrids(Arrays.asList("hrid1", "hrid2"));
        environment.setName("Default env for create");
        environment.setDescription("Default env description for create");
        environment.setOrganizationId("DEFAULT-ORG");
        environment.setDomainRestrictions(Arrays.asList("domain", "restriction"));
        Environment createdEnv = (Environment)this.environmentRepository.create((Object)environment);
        Assert.assertEquals((Object)environment.getId(), (Object)createdEnv.getId());
        Assert.assertEquals((Object)environment.getHrids(), (Object)environment.getHrids());
        Assert.assertEquals((Object)environment.getName(), (Object)createdEnv.getName());
        Assert.assertEquals((Object)environment.getDescription(), (Object)createdEnv.getDescription());
        Assert.assertEquals((Object)environment.getOrganizationId(), (Object)createdEnv.getOrganizationId());
        List domainRestrictions = createdEnv.getDomainRestrictions();
        Assert.assertNotNull((Object)domainRestrictions);
        Assert.assertEquals((long)2L, (long)domainRestrictions.size());
        Assert.assertTrue((boolean)domainRestrictions.contains("domain"));
        Assert.assertTrue((boolean)domainRestrictions.contains("restriction"));
        Optional optional = this.environmentRepository.findById((Object)"DEFAULT-create");
        Assert.assertTrue((String)"Environment to create not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.environmentRepository.findById((Object)"DEFAULT-update");
        Assert.assertTrue((String)"Environment to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved Environment name.", (Object)"Default env for update", (Object)((Environment)optional.get()).getName());
        Environment env = (Environment)optional.get();
        env.setName("New name");
        Environment fetchedEnvironment = (Environment)this.environmentRepository.update((Object)env);
        Assert.assertEquals((Object)env.getName(), (Object)fetchedEnvironment.getName());
        optional = this.environmentRepository.findById((Object)"DEFAULT-update");
        Assert.assertTrue((String)"Environment to update not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldDelete() throws Exception {
        Optional optional = this.environmentRepository.findById((Object)"DEFAULT-delete");
        Assert.assertTrue((String)"Environment to delete not found", (boolean)optional.isPresent());
        this.environmentRepository.delete((Object)"DEFAULT-delete");
        optional = this.environmentRepository.findById((Object)"DEFAULT-delete");
        Assert.assertFalse((String)"Environment to delete has not been deleted", (boolean)optional.isPresent());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optional = this.environmentRepository.findById((Object)"DEFAULT-findById");
        Assert.assertTrue((String)"Environment to find not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set allEnvironments = this.environmentRepository.findAll();
        Assert.assertTrue((String)"No environment found", (!allEnvironments.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void shouldFindByOrganization() throws Exception {
        Set orgEnvironments = this.environmentRepository.findByOrganization("DEFAULT-ORG");
        Assert.assertTrue((String)"No environment found", (!orgEnvironments.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)orgEnvironments.size());
    }
}

