/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class EventRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/event-tests/";
    }

    @Test
    public void createEventTest() throws Exception {
        Event event = new Event();
        event.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        event.setEnvironmentId("DEFAULT");
        event.setType(EventType.PUBLISH_API);
        event.setPayload("{}");
        event.setParentId(null);
        event.setCreatedAt(new Date());
        event.setUpdatedAt(event.getCreatedAt());
        Event eventCreated = (Event)this.eventRepository.create((Object)event);
        Assert.assertEquals((String)"Invalid saved event type.", (Object)EventType.PUBLISH_API, (Object)eventCreated.getType());
        Assert.assertEquals((String)"Invalid saved event payload.", (Object)"{}", (Object)eventCreated.getPayload());
        Assert.assertEquals((String)"Invalid saved environment id.", (Object)"DEFAULT", (Object)eventCreated.getEnvironmentId());
    }

    @Test
    public void findByIdTest() throws Exception {
        Optional event = this.eventRepository.findById((Object)"event1");
        Assert.assertTrue((String)"Event not found", (boolean)event.isPresent());
        Assert.assertEquals((Object)EventType.PUBLISH_API, (Object)((Event)event.get()).getType());
    }

    @Test
    public void checkModifiabledMap() throws Exception {
        Optional event = this.eventRepository.findById((Object)"event1");
        Assert.assertTrue((String)"Event not found", (boolean)event.isPresent());
        Assert.assertEquals((Object)EventType.PUBLISH_API, (Object)((Event)event.get()).getType());
        ((Event)event.get()).getProperties().put("key", "value");
    }

    @Test
    public void searchNoResults() {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1420070400000L).to(1422748800000L).types(new EventType[]{EventType.START_API}).build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertEquals((long)0L, (long)eventPage.getTotalElements());
    }

    @Test
    public void searchBySingleEventType() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).types(new EventType[]{EventType.START_API}).build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertTrue((2L == eventPage.getTotalElements() ? 1 : 0) != 0);
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertTrue((boolean)"event6".equals(event.getId()));
    }

    @Test
    public void searchByMultipleEventType() throws Exception {
        EventCriteria eventCriteria = new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).types(new EventType[]{EventType.START_API, EventType.STOP_API}).build();
        Page eventPage = this.eventRepository.search(eventCriteria, new PageableBuilder().pageNumber(0).pageSize(2).build());
        Assert.assertEquals((long)3L, (long)eventPage.getTotalElements());
        Assert.assertEquals((long)2L, (long)eventPage.getPageElements());
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertEquals((Object)"event6", (Object)event.getId());
        eventPage = this.eventRepository.search(eventCriteria, new PageableBuilder().pageNumber(1).pageSize(2).build());
        Assert.assertEquals((long)3L, (long)eventPage.getTotalElements());
        Assert.assertEquals((long)1L, (long)eventPage.getPageElements());
        event = (Event)eventPage.getContent().iterator().next();
        Assert.assertEquals((Object)"event4", (Object)event.getId());
    }

    @Test
    public void searchByMissingType() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().types(new EventType[]{EventType.GATEWAY_STARTED}).build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertEquals((long)0L, (long)eventPage.getTotalElements());
        Assert.assertTrue((boolean)eventPage.getContent().isEmpty());
    }

    @Test
    public void searchByAPIId() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).property(Event.EventProperties.API_ID.getValue(), (Object)"api-1").build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertTrue((2L == eventPage.getTotalElements() ? 1 : 0) != 0);
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertTrue((boolean)"event2".equals(event.getId()));
    }

    @Test
    public void searchByAPI_EmptyPageable() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).property(Event.EventProperties.API_ID.getValue(), (Object)"api-1").build(), null);
        Assert.assertTrue((2L == eventPage.getTotalElements() ? 1 : 0) != 0);
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertTrue((boolean)"event2".equals(event.getId()));
    }

    @Test
    public void searchByMixProperties() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).property(Event.EventProperties.API_ID.getValue(), (Object)"api-3").types(new EventType[]{EventType.START_API, EventType.STOP_API}).build(), new PageableBuilder().pageNumber(0).pageSize(10).build());
        Assert.assertTrue((1L == eventPage.getTotalElements() ? 1 : 0) != 0);
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertTrue((boolean)"event4".equals(event.getId()));
    }

    @Test
    public void searchByCollectionProperty() throws Exception {
        Page eventPage = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).property(Event.EventProperties.API_ID.getValue(), Arrays.asList("api-1", "api-3")).build(), null);
        Assert.assertTrue((3L == eventPage.getTotalElements() ? 1 : 0) != 0);
        Event event = (Event)eventPage.getContent().iterator().next();
        Assert.assertTrue((boolean)"event4".equals(event.getId()));
    }

    @Test
    public void searchByCollectionPropertyWithoutPaging() throws Exception {
        List events = this.eventRepository.search(new EventCriteria.Builder().from(1451606400000L).to(1470157767000L).property(Event.EventProperties.API_ID.getValue(), Arrays.asList("api-1", "api-3")).build());
        Assert.assertTrue((3L == (long)events.size() ? 1 : 0) != 0);
        Event event = (Event)events.iterator().next();
        Assert.assertTrue((boolean)"event4".equals(event.getId()));
    }

    @Test
    public void searchByCollectionPropertyWithoutPagingAndBoundary() throws Exception {
        List events = this.eventRepository.search(new EventCriteria.Builder().property(Event.EventProperties.API_ID.getValue(), Arrays.asList("api-1", "api-3")).build());
        Assert.assertTrue((3L == (long)events.size() ? 1 : 0) != 0);
        Iterator iterator = events.iterator();
        Assert.assertTrue((boolean)"event4".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event2".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event1".equals(((Event)iterator.next()).getId()));
    }

    @Test
    public void searchByEnvironment() throws Exception {
        List events = this.eventRepository.search(new EventCriteria.Builder().environmentId("DEFAULT").build());
        Assert.assertTrue((6L == (long)events.size() ? 1 : 0) != 0);
        Iterator iterator = events.iterator();
        Assert.assertTrue((boolean)"event6".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event5".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event4".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event3".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event2".equals(((Event)iterator.next()).getId()));
        Assert.assertTrue((boolean)"event1".equals(((Event)iterator.next()).getId()));
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((boolean)this.eventRepository.findById((Object)"event5").isPresent());
        this.eventRepository.delete((Object)"event5");
        Assert.assertFalse((boolean)this.eventRepository.findById((Object)"event5").isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownEvent() throws Exception {
        Event unknownEvent = new Event();
        unknownEvent.setId("unknown");
        this.eventRepository.update((Object)unknownEvent);
        Assert.fail((String)"An unknown event should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.eventRepository.update(null);
        Assert.fail((String)"A null event should not be updated");
    }
}

