/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class GenericNotificationConfigRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/genericnotificationConfig-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        GenericNotificationConfig cfg = new GenericNotificationConfig();
        cfg.setId("new-id");
        cfg.setName("new config");
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-created");
        cfg.setNotifier("notifierId");
        cfg.setConfig("my new configuration");
        cfg.setUseSystemProxy(true);
        cfg.setHooks(Arrays.asList("A", "B", "C"));
        cfg.setUpdatedAt(new Date(1439022010883L));
        cfg.setCreatedAt(new Date(1439022010883L));
        GenericNotificationConfig notificationCreated = this.genericNotificationConfigRepository.create(cfg);
        Assert.assertEquals((Object)cfg.getId(), (Object)notificationCreated.getId());
        Assert.assertEquals((Object)cfg.getName(), (Object)notificationCreated.getName());
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationCreated.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationCreated.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationCreated.getReferenceId());
        Assert.assertEquals((Object)cfg.getNotifier(), (Object)notificationCreated.getNotifier());
        Assert.assertEquals((Object)cfg.getConfig(), (Object)notificationCreated.getConfig());
        Assert.assertEquals((Object)cfg.getHooks(), (Object)notificationCreated.getHooks());
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationCreated.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationCreated.getUpdatedAt()));
        Assert.assertTrue((boolean)cfg.isUseSystemProxy());
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((boolean)this.genericNotificationConfigRepository.findById("notif-to-delete").isPresent());
        this.genericNotificationConfigRepository.delete("notif-to-delete");
        Assert.assertFalse((boolean)this.genericNotificationConfigRepository.findById("notif-to-delete").isPresent());
    }

    @Test
    public void shouldUpdate() throws Exception {
        GenericNotificationConfig cfg = new GenericNotificationConfig();
        cfg.setId("notif-to-update");
        cfg.setName("notif-updated");
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-to-update");
        cfg.setNotifier("notifierId");
        cfg.setConfig("updated configuration");
        cfg.setUseSystemProxy(true);
        cfg.setHooks(Arrays.asList("D", "B", "C"));
        cfg.setUpdatedAt(new Date(1479022010883L));
        cfg.setCreatedAt(new Date(1469022010883L));
        GenericNotificationConfig notificationUpdated = this.genericNotificationConfigRepository.update(cfg);
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationUpdated.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationUpdated.getReferenceId());
        Assert.assertEquals((Object)cfg.getNotifier(), (Object)notificationUpdated.getNotifier());
        Assert.assertEquals((Object)cfg.getConfig(), (Object)notificationUpdated.getConfig());
        Assert.assertTrue((boolean)cfg.getHooks().containsAll(notificationUpdated.getHooks()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationUpdated.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationUpdated.getUpdatedAt()));
        Assert.assertTrue((boolean)cfg.isUseSystemProxy());
    }

    @Test
    public void shouldFindById() throws Exception {
        GenericNotificationConfig cfg = new GenericNotificationConfig();
        cfg.setId("notif-to-find");
        cfg.setName("notif-to-find");
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-to-find");
        cfg.setNotifier("notifierId");
        cfg.setConfig("my config");
        cfg.setUseSystemProxy(true);
        cfg.setHooks(Arrays.asList("A", "B"));
        cfg.setUpdatedAt(new Date(1439022010883L));
        cfg.setCreatedAt(new Date(1439022010883L));
        Optional optNotificationFound = this.genericNotificationConfigRepository.findById("notif-to-find");
        Assert.assertTrue((boolean)optNotificationFound.isPresent());
        GenericNotificationConfig notificationFound = (GenericNotificationConfig)optNotificationFound.get();
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationFound.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationFound.getReferenceId());
        Assert.assertEquals((Object)cfg.getNotifier(), (Object)notificationFound.getNotifier());
        Assert.assertEquals((Object)cfg.getConfig(), (Object)notificationFound.getConfig());
        Assert.assertEquals((Object)cfg.isUseSystemProxy(), (Object)notificationFound.isUseSystemProxy());
        Assert.assertEquals((Object)cfg.getHooks(), (Object)notificationFound.getHooks());
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationFound.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationFound.getUpdatedAt()));
    }

    @Test
    public void shouldNotFoundById() throws Exception {
        Optional optNotificationFound = this.genericNotificationConfigRepository.findById("notifierId-unknown");
        Assert.assertFalse((boolean)optNotificationFound.isPresent());
    }

    @Test
    public void shouldFindByHookAndReference() throws Exception {
        List configs = this.genericNotificationConfigRepository.findByReferenceAndHook("B", NotificationReferenceType.APPLICATION, "search");
        Assert.assertEquals((String)"size", (long)2L, (long)configs.size());
        List userIds = configs.stream().map(GenericNotificationConfig::getNotifier).collect(Collectors.toList());
        Assert.assertTrue((String)"notifierA", (boolean)userIds.contains("notifierA"));
        Assert.assertTrue((String)"notifierB", (boolean)userIds.contains("notifierB"));
    }

    @Test
    public void shouldDeleteByEmail() throws Exception {
        this.genericNotificationConfigRepository.deleteByConfig("test@gravitee.io");
        Assert.assertFalse((boolean)this.genericNotificationConfigRepository.findById("config-to-delete").isPresent());
    }
}

