/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class GroupRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/group-tests/";
    }

    @Test
    public void shouldCreateGroup() throws TechnicalException {
        Group group = new Group();
        group.setId("1");
        group.setName("my group");
        group.setEnvironmentId("DEFAULT");
        group.setLockApiRole(true);
        group.setLockApplicationRole(true);
        group.setSystemInvitation(true);
        group.setEmailInvitation(true);
        group.setMaxInvitation(Integer.valueOf(10));
        group.setDisableMembershipNotifications(true);
        Group group1 = (Group)this.groupRepository.create((Object)group);
        Assert.assertNotNull((Object)group1);
        Assert.assertNotNull((Object)group1.getId());
        Assert.assertEquals((Object)group.getId(), (Object)group1.getId());
        Assert.assertEquals((Object)group.getEnvironmentId(), (Object)group1.getEnvironmentId());
        Assert.assertEquals((Object)group.getName(), (Object)group1.getName());
        Assert.assertEquals((Object)group.isLockApiRole(), (Object)group1.isLockApiRole());
        Assert.assertEquals((Object)group.isLockApplicationRole(), (Object)group1.isLockApplicationRole());
        Assert.assertEquals((Object)group.isSystemInvitation(), (Object)group1.isSystemInvitation());
        Assert.assertEquals((Object)group.isEmailInvitation(), (Object)group1.isEmailInvitation());
        Assert.assertEquals((Object)group.getMaxInvitation(), (Object)group1.getMaxInvitation());
        Assert.assertEquals((Object)group.isDisableMembershipNotifications(), (Object)group1.isDisableMembershipNotifications());
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional group = this.groupRepository.findById((Object)"group-application-1");
        Assert.assertNotNull((Object)group);
        Assert.assertTrue((boolean)group.isPresent());
        Assert.assertEquals((Object)"group-application-1", (Object)((Group)group.get()).getId());
        Assert.assertEquals((Object)"group-application-1 environment-id", (Object)((Group)group.get()).getEnvironmentId());
        Assert.assertEquals((Object)"group-application-1 name", (Object)((Group)group.get()).getName());
        Assert.assertTrue((boolean)((Group)group.get()).isLockApiRole());
        Assert.assertTrue((boolean)((Group)group.get()).isLockApplicationRole());
        Assert.assertTrue((boolean)((Group)group.get()).isSystemInvitation());
        Assert.assertTrue((boolean)((Group)group.get()).isEmailInvitation());
        Assert.assertTrue((boolean)((Group)group.get()).isDisableMembershipNotifications());
        Assert.assertEquals((long)99L, (long)((Group)group.get()).getMaxInvitation().intValue());
        Assert.assertEquals((long)2L, (long)((Group)group.get()).getEventRules().size());
    }

    @Test
    public void shouldNotFindByUnknownId() throws TechnicalException {
        Optional group = this.groupRepository.findById((Object)"unknown");
        Assert.assertNotNull((Object)group);
        Assert.assertFalse((boolean)group.isPresent());
    }

    @Test
    public void shouldUpdate() throws TechnicalException {
        Group group = new Group();
        group.setId("group-application-1");
        group.setEnvironmentId("new_DEFAULT");
        group.setName("Modified Name");
        group.setUpdatedAt(new Date(1000000000000L));
        group.setLockApiRole(true);
        group.setLockApplicationRole(true);
        group.setSystemInvitation(true);
        group.setEmailInvitation(true);
        group.setDisableMembershipNotifications(false);
        group.setMaxInvitation(Integer.valueOf(99));
        Group update = (Group)this.groupRepository.update((Object)group);
        Assert.assertEquals((Object)group.getId(), (Object)update.getId());
        Assert.assertEquals((Object)group.getEnvironmentId(), (Object)update.getEnvironmentId());
        Assert.assertEquals((Object)group.getName(), (Object)update.getName());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1000000000000L), update.getUpdatedAt()));
        Assert.assertTrue((boolean)update.isLockApiRole());
        Assert.assertTrue((boolean)update.isLockApplicationRole());
        Assert.assertTrue((boolean)update.isSystemInvitation());
        Assert.assertTrue((boolean)update.isEmailInvitation());
        Assert.assertFalse((boolean)update.isDisableMembershipNotifications());
        Assert.assertEquals((long)99L, (long)update.getMaxInvitation().intValue());
    }

    @Test
    public void shouldFindAll() throws TechnicalException {
        Set groups = this.groupRepository.findAll();
        Assert.assertNotNull((Object)groups);
        Assert.assertFalse((String)"not empty", (boolean)groups.isEmpty());
        Assert.assertEquals((long)2L, (long)groups.size());
    }

    @Test
    public void shouldFindAllByEnvironment() throws TechnicalException {
        Set groups = this.groupRepository.findAllByEnvironment("DEFAULT");
        Assert.assertNotNull((Object)groups);
        Assert.assertFalse((String)"not empty", (boolean)groups.isEmpty());
        Assert.assertEquals((long)1L, (long)groups.size());
    }

    @Test
    public void shouldDelete() throws TechnicalException {
        this.groupRepository.delete((Object)"group-api-to-delete");
        Optional group = this.groupRepository.findById((Object)"group-api-to-delete");
        Assert.assertNotNull((Object)group);
        Assert.assertFalse((boolean)group.isPresent());
    }

    @Test
    public void shouldFindByIds() throws TechnicalException {
        Set groups = this.groupRepository.findByIds(new HashSet<String>(Arrays.asList("group-application-1", "group-api-to-delete", "unknown")));
        Assert.assertNotNull((Object)groups);
        Assert.assertFalse((boolean)groups.isEmpty());
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.stream().map(Group::getId).collect(Collectors.toList()).containsAll(Arrays.asList("group-application-1", "group-api-to-delete")));
    }

    @Test
    public void shouldNotFindByEmptyIds() throws TechnicalException {
        Set groups = this.groupRepository.findByIds(Collections.emptySet());
        Assert.assertNotNull((Object)groups);
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownGroup() throws Exception {
        Group unknownGroup = new Group();
        unknownGroup.setId("unknown");
        this.groupRepository.update((Object)unknownGroup);
        Assert.fail((String)"An unknown group should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.groupRepository.update(null);
        Assert.fail((String)"A null group should not be updated");
    }
}

