/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.IdentityProviderActivation;
import io.gravitee.repository.management.model.IdentityProviderActivationReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class IdentityProviderActivationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/identityprovideractivation-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        IdentityProviderActivation identityProviderActivation = new IdentityProviderActivation();
        identityProviderActivation.setIdentityProviderId("new-idp-act");
        identityProviderActivation.setReferenceId("DEFAULT");
        identityProviderActivation.setReferenceType(IdentityProviderActivationReferenceType.ENVIRONMENT);
        identityProviderActivation.setCreatedAt(new Date(1000000000000L));
        int nbIdentityProviderActivationsBeforeCreation = this.identityProviderActivationRepository.findAll().size();
        this.identityProviderActivationRepository.create(identityProviderActivation);
        int nbIdentityProviderActivationsAfterCreation = this.identityProviderActivationRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProviderActivationsBeforeCreation + 1), (long)nbIdentityProviderActivationsAfterCreation);
        Set identityProviderActivations = this.identityProviderActivationRepository.findAllByIdentityProviderId("new-idp-act");
        Assert.assertTrue((String)"Identity provider activation saved not found", (identityProviderActivations != null && !identityProviderActivations.isEmpty() ? 1 : 0) != 0);
        IdentityProviderActivation identityProviderActivationSaved = (IdentityProviderActivation)identityProviderActivations.iterator().next();
        Assert.assertEquals((String)"Invalid saved identity provider id.", (Object)identityProviderActivationSaved.getIdentityProviderId(), (Object)identityProviderActivation.getIdentityProviderId());
        Assert.assertEquals((String)"Invalid saved reference id.", (Object)identityProviderActivationSaved.getReferenceId(), (Object)identityProviderActivation.getReferenceId());
        Assert.assertEquals((String)"Invalid saved reference type.", (Object)identityProviderActivationSaved.getReferenceType(), (Object)identityProviderActivation.getReferenceType());
        Assert.assertTrue((String)"Invalid saved created date.", (boolean)DateUtils.compareDate(new Date(1000000000000L), identityProviderActivation.getCreatedAt()));
    }

    @Test
    public void shouldDeleteById() throws Exception {
        int nbIdentityProviderActivationsBeforeDeletion = this.identityProviderActivationRepository.findAll().size();
        this.identityProviderActivationRepository.delete("google_DEV", "DEV", IdentityProviderActivationReferenceType.ENVIRONMENT);
        int nbIdentityProviderActivationsAfterDeletion = this.identityProviderActivationRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProviderActivationsBeforeDeletion - 1), (long)nbIdentityProviderActivationsAfterDeletion);
    }

    @Test
    public void shouldDeleteByIdentityProviderId() throws Exception {
        int nbIdentityProviderActivationsBeforeDeletion = this.identityProviderActivationRepository.findAll().size();
        this.identityProviderActivationRepository.deleteByIdentityProviderId("oidc");
        int nbIdentityProviderActivationsAfterDeletion = this.identityProviderActivationRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProviderActivationsBeforeDeletion - 2), (long)nbIdentityProviderActivationsAfterDeletion);
    }

    @Test
    public void shouldDeleteByReferenceIdAndReferenceType() throws Exception {
        int nbIdentityProviderActivationsBeforeDeletion = this.identityProviderActivationRepository.findAll().size();
        this.identityProviderActivationRepository.deleteByReferenceIdAndReferenceType("DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT);
        int nbIdentityProviderActivationsAfterDeletion = this.identityProviderActivationRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProviderActivationsBeforeDeletion - 3), (long)nbIdentityProviderActivationsAfterDeletion);
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set identityProviderActivations = this.identityProviderActivationRepository.findAll();
        Assert.assertNotNull((Object)identityProviderActivations);
        Assert.assertEquals((long)5L, (long)identityProviderActivations.size());
    }

    @Test
    public void shouldFindAllByIdentityProviderId() throws Exception {
        Set identityProviderActivations = this.identityProviderActivationRepository.findAllByIdentityProviderId("oidc");
        Assert.assertNotNull((Object)identityProviderActivations);
        Assert.assertEquals((long)2L, (long)identityProviderActivations.size());
    }

    @Test
    public void shouldFindAllByReferenceIdAndReferenceType() throws Exception {
        Set identityProviderActivations = this.identityProviderActivationRepository.findAllByReferenceIdAndReferenceType("DEFAULT", IdentityProviderActivationReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)identityProviderActivations);
        Assert.assertEquals((long)1L, (long)identityProviderActivations.size());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optIdentityProviderActivation = this.identityProviderActivationRepository.findById("github", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT);
        Assert.assertTrue((boolean)optIdentityProviderActivation.isPresent());
        IdentityProviderActivation identityProviderActivation = (IdentityProviderActivation)optIdentityProviderActivation.get();
        Assert.assertEquals((String)"Invalid identity provider id.", (Object)"github", (Object)identityProviderActivation.getIdentityProviderId());
        Assert.assertEquals((String)"Invalid reference id.", (Object)"DEFAULT", (Object)identityProviderActivation.getReferenceId());
        Assert.assertEquals((String)"Invalid reference type.", (Object)IdentityProviderActivationReferenceType.ENVIRONMENT, (Object)identityProviderActivation.getReferenceType());
        Assert.assertTrue((String)"Invalid created date.", (boolean)DateUtils.compareDate(new Date(1000000000000L), identityProviderActivation.getCreatedAt()));
    }
}

