/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class IdentityProviderRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/identityprovider-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set identityProviders = this.identityProviderRepository.findAll();
        Assert.assertNotNull((Object)identityProviders);
        Assert.assertEquals((long)3L, (long)identityProviders.size());
        for (IdentityProvider idp : identityProviders) {
            Map groupMappings = idp.getGroupMappings();
            Assert.assertNotNull((Object)groupMappings);
            for (Map.Entry gm : groupMappings.entrySet()) {
                Assert.assertNotNull(gm.getValue());
            }
        }
    }

    @Test
    public void shouldFindAllByOrganizationId() throws Exception {
        Set identityProviders = this.identityProviderRepository.findAllByOrganizationId("DEFAULT");
        Assert.assertNotNull((Object)identityProviders);
        Assert.assertEquals((long)3L, (long)identityProviders.size());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional identityProviderOpt = this.identityProviderRepository.findById("idp-3");
        Assert.assertNotNull((Object)identityProviderOpt);
        Assert.assertTrue((boolean)identityProviderOpt.isPresent());
        IdentityProvider identityProvider = (IdentityProvider)identityProviderOpt.get();
        Assert.assertNotNull((Object)identityProvider);
        Assert.assertEquals((Object)"Gravitee.io AM", (Object)identityProvider.getName());
        Assert.assertEquals((Object)"Gravitee.io AM Identity Provider", (Object)identityProvider.getDescription());
        Assert.assertEquals((Object)"DEFAULT", (Object)identityProvider.getOrganizationId());
        Assert.assertFalse((boolean)identityProvider.isEnabled());
        Assert.assertEquals((Object)IdentityProviderType.GRAVITEEIO_AM, (Object)identityProvider.getType());
        Assert.assertNull((Object)identityProvider.getEmailRequired());
        Assert.assertNull((Object)identityProvider.getSyncMappings());
        String condition = "{#jsonPath('$.email_verified')}";
        Assert.assertNotNull((Object)identityProvider.getGroupMappings());
        Assert.assertEquals((long)1L, (long)identityProvider.getGroupMappings().size());
        Assert.assertNotNull(identityProvider.getGroupMappings().get(condition));
        Assert.assertEquals((long)2L, (long)((String[])identityProvider.getGroupMappings().get(condition)).length);
        Assert.assertEquals((Object)"group1", (Object)((String[])identityProvider.getGroupMappings().get(condition))[0]);
        Assert.assertEquals((Object)"group2", (Object)((String[])identityProvider.getGroupMappings().get(condition))[1]);
        Assert.assertNotNull((Object)identityProvider.getRoleMappings());
        Assert.assertEquals((long)1L, (long)identityProvider.getRoleMappings().size());
        Assert.assertNotNull(identityProvider.getRoleMappings().get(condition));
        Assert.assertEquals((long)2L, (long)((String[])identityProvider.getRoleMappings().get(condition)).length);
        Assert.assertEquals((Object)"role1", (Object)((String[])identityProvider.getRoleMappings().get(condition))[0]);
        Assert.assertEquals((Object)"role2", (Object)((String[])identityProvider.getRoleMappings().get(condition))[1]);
        Assert.assertNotNull((Object)identityProvider.getUserProfileMapping());
        Assert.assertEquals((Object)"id", identityProvider.getUserProfileMapping().get("sub"));
        Assert.assertEquals((Object)"firstname", identityProvider.getUserProfileMapping().get("firstname"));
        Assert.assertEquals((Object)"mail", identityProvider.getUserProfileMapping().get("email"));
    }

    @Test
    public void shouldCreate() throws Exception {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setId("new-idp");
        identityProvider.setOrganizationId("DEFAULT");
        identityProvider.setName("My idp 1");
        identityProvider.setDescription("Description for my idp 1");
        identityProvider.setCreatedAt(new Date(1000000000000L));
        identityProvider.setUpdatedAt(new Date(1439032010883L));
        identityProvider.setType(IdentityProviderType.GITHUB);
        identityProvider.setEnabled(true);
        identityProvider.setEmailRequired(Boolean.valueOf(true));
        identityProvider.setSyncMappings(Boolean.valueOf(true));
        int nbIdentityProvidersBeforeCreation = this.identityProviderRepository.findAll().size();
        this.identityProviderRepository.create(identityProvider);
        int nbIdentityProvidersAfterCreation = this.identityProviderRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProvidersBeforeCreation + 1), (long)nbIdentityProvidersAfterCreation);
        Optional optional = this.identityProviderRepository.findById("new-idp");
        Assert.assertTrue((String)"Identity provider saved not found", (boolean)optional.isPresent());
        IdentityProvider identityProviderSaved = (IdentityProvider)optional.get();
        Assert.assertEquals((String)"Invalid saved identity provider name.", (Object)identityProvider.getName(), (Object)identityProviderSaved.getName());
        Assert.assertEquals((String)"Invalid saved identity provider organization id.", (Object)identityProvider.getOrganizationId(), (Object)identityProviderSaved.getOrganizationId());
        Assert.assertEquals((String)"Invalid identity provider description.", (Object)identityProvider.getDescription(), (Object)identityProviderSaved.getDescription());
        Assert.assertTrue((String)"Invalid identity provider createdAt.", (boolean)DateUtils.compareDate(identityProvider.getCreatedAt(), identityProviderSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid identity provider updatedAt.", (boolean)DateUtils.compareDate(identityProvider.getUpdatedAt(), identityProviderSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid identity provider type.", (Object)identityProvider.getType(), (Object)identityProviderSaved.getType());
        Assert.assertEquals((String)"Invalid identity provider enabled.", (Object)identityProvider.isEnabled(), (Object)identityProviderSaved.isEnabled());
        Assert.assertEquals((String)"Invalid identity provider emailRequired.", (Object)identityProvider.getEmailRequired(), (Object)identityProviderSaved.getEmailRequired());
        Assert.assertEquals((String)"Invalid identity provider syncMappings.", (Object)identityProvider.getSyncMappings(), (Object)identityProviderSaved.getSyncMappings());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.identityProviderRepository.findById("idp-1");
        Assert.assertTrue((String)"Identity provider to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved identity provider name.", (Object)"Google", (Object)((IdentityProvider)optional.get()).getName());
        IdentityProvider identityProvider = (IdentityProvider)optional.get();
        identityProvider.setName("Google");
        identityProvider.setOrganizationId("DEFAULT");
        identityProvider.setDescription("Google Identity Provider");
        identityProvider.setCreatedAt(new Date(1000000000000L));
        identityProvider.setUpdatedAt(new Date(1486771200000L));
        identityProvider.setType(IdentityProviderType.GOOGLE);
        identityProvider.setEnabled(true);
        identityProvider.setEmailRequired(Boolean.valueOf(true));
        identityProvider.setSyncMappings(Boolean.valueOf(true));
        int nbIdentityProvidersBeforeUpdate = this.identityProviderRepository.findAll().size();
        this.identityProviderRepository.update(identityProvider);
        int nbIdentityProvidersAfterUpdate = this.identityProviderRepository.findAll().size();
        Assert.assertEquals((long)nbIdentityProvidersBeforeUpdate, (long)nbIdentityProvidersAfterUpdate);
        Optional optionalUpdated = this.identityProviderRepository.findById("idp-1");
        Assert.assertTrue((String)"Identity provider to update not found", (boolean)optionalUpdated.isPresent());
        IdentityProvider identityProviderUpdated = (IdentityProvider)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved identity provider name.", (Object)identityProvider.getName(), (Object)identityProviderUpdated.getName());
        Assert.assertEquals((String)"Invalid saved identity provider organization id.", (Object)identityProvider.getOrganizationId(), (Object)identityProviderUpdated.getOrganizationId());
        Assert.assertEquals((String)"Invalid identity provider description.", (Object)identityProvider.getDescription(), (Object)identityProviderUpdated.getDescription());
        Assert.assertTrue((String)"Invalid identity provider createdAt.", (boolean)DateUtils.compareDate(identityProvider.getCreatedAt(), identityProviderUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid identity provider updatedAt.", (boolean)DateUtils.compareDate(identityProvider.getUpdatedAt(), identityProviderUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid identity provider type.", (Object)identityProvider.getType(), (Object)identityProviderUpdated.getType());
        Assert.assertEquals((String)"Invalid identity provider enabled.", (Object)identityProvider.isEnabled(), (Object)identityProviderUpdated.isEnabled());
        Assert.assertEquals((String)"Invalid identity provider emailRequired.", (Object)identityProvider.getEmailRequired(), (Object)identityProviderUpdated.getEmailRequired());
        Assert.assertEquals((String)"Invalid identity provider syncMappings.", (Object)identityProvider.getSyncMappings(), (Object)identityProviderUpdated.getSyncMappings());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbIdentityProvidersBeforeDeletion = this.identityProviderRepository.findAll().size();
        this.identityProviderRepository.delete("idp-3");
        int nbIdentityProvidersAfterDeletion = this.identityProviderRepository.findAll().size();
        Assert.assertEquals((long)(nbIdentityProvidersBeforeDeletion - 1), (long)nbIdentityProvidersAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownIdentityProvider() throws Exception {
        IdentityProvider unknownIdentityProvider = new IdentityProvider();
        unknownIdentityProvider.setId("unknown");
        unknownIdentityProvider.setOrganizationId("unknown");
        this.identityProviderRepository.update(unknownIdentityProvider);
        Assert.fail((String)"An unknown identity provider should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.identityProviderRepository.update(null);
        Assert.fail((String)"A null identity provider should not be updated");
    }
}

