/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.Installation;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class InstallationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/installation-tests/";
    }

    @Test
    public void shouldCreateInstallation() throws TechnicalException {
        Installation installation = new Installation();
        installation.setId("1");
        installation.setCreatedAt(new Date(1000000000000L));
        installation.setUpdatedAt(new Date(1100000000000L));
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        additionalInformation.put("key1", "value1");
        additionalInformation.put("key2", "value2");
        installation.setAdditionalInformation(additionalInformation);
        Installation createdInstallation = (Installation)this.installationRepository.create((Object)installation);
        Assert.assertNotNull((Object)createdInstallation);
        Assert.assertNotNull((Object)createdInstallation.getId());
        Assert.assertEquals((Object)installation.getId(), (Object)createdInstallation.getId());
        Assert.assertTrue((boolean)DateUtils.compareDate(installation.getCreatedAt(), createdInstallation.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(installation.getUpdatedAt(), createdInstallation.getUpdatedAt()));
        Assert.assertEquals((Object)installation.getAdditionalInformation(), (Object)createdInstallation.getAdditionalInformation());
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional optInstallation = this.installationRepository.findById((Object)"installation-1");
        Assert.assertNotNull((Object)optInstallation);
        Assert.assertTrue((boolean)optInstallation.isPresent());
        Installation installation = (Installation)optInstallation.get();
        Assert.assertEquals((Object)"installation-1", (Object)installation.getId());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1000000000000L), installation.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1100000000000L), installation.getUpdatedAt()));
        Map additionalInformation = installation.getAdditionalInformation();
        Assert.assertNotNull((Object)additionalInformation);
        Assert.assertEquals((long)2L, (long)additionalInformation.size());
        Assert.assertEquals((Object)"value1", additionalInformation.get("key1"));
        Assert.assertEquals((Object)"value2", additionalInformation.get("key2"));
    }

    @Test
    public void shouldNotFindByUnknownId() throws TechnicalException {
        Optional optInstallation = this.installationRepository.findById((Object)"unknown");
        Assert.assertNotNull((Object)optInstallation);
        Assert.assertFalse((boolean)optInstallation.isPresent());
    }

    @Test
    public void shouldUpdate() throws TechnicalException {
        Installation installation = new Installation();
        installation.setId("installation-1");
        installation.setCreatedAt(new Date(1000000000000L));
        installation.setUpdatedAt(new Date(1200000000000L));
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        additionalInformation.put("key1", "value1");
        additionalInformation.put("key2", "value22");
        additionalInformation.put("key3", "value3");
        installation.setAdditionalInformation(additionalInformation);
        Installation updatedInstallation = (Installation)this.installationRepository.update((Object)installation);
        Assert.assertEquals((Object)installation.getId(), (Object)updatedInstallation.getId());
        Assert.assertTrue((boolean)DateUtils.compareDate(installation.getCreatedAt(), updatedInstallation.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(installation.getUpdatedAt(), updatedInstallation.getUpdatedAt()));
        Assert.assertEquals((Object)installation.getAdditionalInformation(), (Object)updatedInstallation.getAdditionalInformation());
    }

    @Test
    public void shouldDelete() throws TechnicalException {
        this.installationRepository.delete((Object)"installation-to-delete");
        Optional optInstallation = this.installationRepository.findById((Object)"installation-to-delete");
        Assert.assertNotNull((Object)optInstallation);
        Assert.assertFalse((boolean)optInstallation.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownInstallation() throws Exception {
        Installation unknownInstallation = new Installation();
        unknownInstallation.setId("unknown");
        this.installationRepository.update((Object)unknownInstallation);
        Assert.fail((String)"An unknown installation should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.installationRepository.update(null);
        Assert.fail((String)"A null installation should not be updated");
    }
}

