/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Invitation;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class InvitationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/invitation-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set invitations = this.invitationRepository.findAll();
        Assert.assertNotNull((Object)invitations);
        Assert.assertEquals((long)3L, (long)invitations.size());
        Optional<Invitation> optionalInvitation = invitations.stream().filter(invitation -> "e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce".equals(invitation.getId())).findAny();
        Assert.assertTrue((boolean)optionalInvitation.isPresent());
        Assert.assertEquals((Object)"APPLICATION", (Object)optionalInvitation.get().getReferenceType());
        Assert.assertEquals((Object)"application-id", (Object)optionalInvitation.get().getReferenceId());
        Assert.assertEquals((Object)"invitation@application.com", (Object)optionalInvitation.get().getEmail());
        Assert.assertTrue((boolean)DateUtils.compareDate(1439022010883L, optionalInvitation.get().getCreatedAt().getTime()));
        Assert.assertTrue((boolean)DateUtils.compareDate(1439022010883L, optionalInvitation.get().getUpdatedAt().getTime()));
    }

    @Test
    public void shouldCreate() throws Exception {
        Invitation invitation = new Invitation();
        invitation.setId("new-invitation");
        invitation.setReferenceType("API");
        invitation.setReferenceId("api-id");
        invitation.setApiRole("USER");
        invitation.setApplicationRole("OWNER");
        invitation.setEmail("new-invitation@email.com");
        Date date = new Date(1439022010883L);
        invitation.setCreatedAt(date);
        invitation.setUpdatedAt(date);
        int nbInvitationsBeforeCreation = this.invitationRepository.findAll().size();
        this.invitationRepository.create((Object)invitation);
        int nbInvitationsAfterCreation = this.invitationRepository.findAll().size();
        Assert.assertEquals((long)(nbInvitationsBeforeCreation + 1), (long)nbInvitationsAfterCreation);
        Optional optional = this.invitationRepository.findById((Object)"new-invitation");
        Assert.assertTrue((String)"Invitation saved not found", (boolean)optional.isPresent());
        Invitation fetchedInvitation = (Invitation)optional.get();
        Assert.assertEquals((Object)invitation.getReferenceType(), (Object)fetchedInvitation.getReferenceType());
        Assert.assertEquals((Object)invitation.getReferenceId(), (Object)fetchedInvitation.getReferenceId());
        Assert.assertEquals((Object)invitation.getApiRole(), (Object)fetchedInvitation.getApiRole());
        Assert.assertEquals((Object)invitation.getApplicationRole(), (Object)fetchedInvitation.getApplicationRole());
        Assert.assertEquals((Object)invitation.getEmail(), (Object)fetchedInvitation.getEmail());
        Assert.assertTrue((boolean)DateUtils.compareDate(invitation.getCreatedAt(), fetchedInvitation.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(invitation.getUpdatedAt(), fetchedInvitation.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.invitationRepository.findById((Object)"e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce");
        Assert.assertTrue((String)"Invitation to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved invitation email.", (Object)"invitation@application.com", (Object)((Invitation)optional.get()).getEmail());
        Invitation invitation = (Invitation)optional.get();
        invitation.setReferenceType("New reference type");
        invitation.setReferenceId("New reference id");
        invitation.setEmail("new-invitation@application.com");
        invitation.setApiRole("USER");
        invitation.setApplicationRole("OWNER");
        Date date = new Date(1439022010883L);
        invitation.setCreatedAt(date);
        invitation.setUpdatedAt(date);
        int nbInvitationsBeforeUpdate = this.invitationRepository.findAll().size();
        this.invitationRepository.update((Object)invitation);
        int nbInvitationsAfterUpdate = this.invitationRepository.findAll().size();
        Assert.assertEquals((long)nbInvitationsBeforeUpdate, (long)nbInvitationsAfterUpdate);
        Optional optionalUpdated = this.invitationRepository.findById((Object)"e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce");
        Assert.assertTrue((String)"Invitation to update not found", (boolean)optionalUpdated.isPresent());
        Invitation fetchedInvitation = (Invitation)optionalUpdated.get();
        Assert.assertEquals((Object)invitation.getReferenceType(), (Object)fetchedInvitation.getReferenceType());
        Assert.assertEquals((Object)invitation.getReferenceId(), (Object)fetchedInvitation.getReferenceId());
        Assert.assertEquals((Object)invitation.getEmail(), (Object)fetchedInvitation.getEmail());
        Assert.assertEquals((Object)invitation.getApiRole(), (Object)fetchedInvitation.getApiRole());
        Assert.assertEquals((Object)invitation.getApplicationRole(), (Object)fetchedInvitation.getApplicationRole());
        Assert.assertTrue((boolean)DateUtils.compareDate(invitation.getCreatedAt(), fetchedInvitation.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(invitation.getUpdatedAt(), fetchedInvitation.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbInvitationsBeforeDeletion = this.invitationRepository.findAll().size();
        this.invitationRepository.delete((Object)"e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce");
        int nbInvitationsAfterDeletion = this.invitationRepository.findAll().size();
        Assert.assertEquals((long)(nbInvitationsBeforeDeletion - 1), (long)nbInvitationsAfterDeletion);
    }

    @Test
    public void shouldFindByReference() throws Exception {
        List invitations = this.invitationRepository.findByReference("API", "api-id");
        Assert.assertNotNull((Object)invitations);
        Assert.assertEquals((long)1L, (long)invitations.size());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownInvitation() throws Exception {
        Invitation unknownInvitation = new Invitation();
        unknownInvitation.setId("unknown");
        this.invitationRepository.update((Object)unknownInvitation);
        Assert.fail((String)"An unknown invitation should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.invitationRepository.update(null);
        Assert.fail((String)"A null invitation should not be updated");
    }
}

