/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.media.model.Media;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class MediaRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/media-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        String fileName = "gravitee_logo_anim.gif";
        byte[] fileBytes = this.getFileBytes(fileName);
        long size = fileBytes.length;
        String hashString = this.getHashString(fileBytes);
        Media mediaCreated = this.createMedia(fileName, fileBytes, size, hashString, "223344", null);
        Assert.assertNotNull((Object)mediaCreated);
        Optional optionalAfter = this.mediaRepository.findByHashAndType(hashString, "image");
        Assert.assertTrue((String)"Image saved not found", (boolean)optionalAfter.isPresent());
        Media imageDataSaved = (Media)optionalAfter.get();
        Assert.assertNotNull((Object)imageDataSaved.getCreatedAt());
        Assert.assertEquals((String)"Invalid saved image id.", (Object)"223344", (Object)imageDataSaved.getId());
        Assert.assertEquals((String)"Invalid saved image name.", (Object)fileName, (Object)imageDataSaved.getFileName());
        Assert.assertEquals((String)"Invalid saved image hash.", (Object)hashString, (Object)imageDataSaved.getHash());
        Assert.assertEquals((String)"Invalid saved image size.", (long)size, (long)imageDataSaved.getSize());
        Assert.assertEquals((String)"Invalid saved image type.", (Object)"image", (Object)imageDataSaved.getType());
        Assert.assertEquals((String)"Invalid saved image SubType.", (Object)"gif", (Object)imageDataSaved.getSubType());
        Assert.assertNotNull((String)"Invalid saved image data.", (Object)imageDataSaved.getData());
        optionalAfter = this.mediaRepository.findByHash(hashString);
        Assert.assertTrue((String)"Image saved not found", (boolean)optionalAfter.isPresent());
    }

    @Test
    public void shouldCreateForAPI() throws Exception {
        String fileName = "stars.png";
        byte[] fileBytes = this.getFileBytes(fileName);
        long size = fileBytes.length;
        String hashString = this.getHashString(fileBytes);
        this.createMedia(fileName, fileBytes, size, hashString, "22334455", "apiId");
        Optional optionalAfter = this.mediaRepository.findByHashAndApiAndType(hashString, "apiId", "image");
        Assert.assertTrue((String)"Image saved not found", (boolean)optionalAfter.isPresent());
        Media imageDataSaved = (Media)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved image id.", (Object)"22334455", (Object)imageDataSaved.getId());
        Assert.assertEquals((String)"Invalid saved image name.", (Object)fileName, (Object)imageDataSaved.getFileName());
        Assert.assertEquals((String)"Invalid saved image size.", (long)size, (long)imageDataSaved.getSize());
        Assert.assertNotNull((String)"Invalid saved image data.", (Object)imageDataSaved.getData());
        optionalAfter = this.mediaRepository.findByHashAndApi(hashString, "apiId");
        Assert.assertTrue((String)"Image saved not found", (boolean)optionalAfter.isPresent());
    }

    @Test
    public void shouldFindMediaWithoutContent() throws Exception {
        String fileName = "stars.png";
        byte[] fileBytes = this.getFileBytes(fileName);
        long size = fileBytes.length;
        String hashString = this.getHashString(fileBytes);
        this.createMedia(fileName, fileBytes, size, hashString, "2233445566", null);
        Optional optionalAfter = this.mediaRepository.findByHash(hashString, false);
        Assert.assertTrue((boolean)optionalAfter.isPresent());
        Assert.assertNull((Object)((Media)optionalAfter.get()).getData());
    }

    @Test
    public void shouldFindAllForAnAPI() throws Exception {
        String fileName = "stars.png";
        byte[] fileBytes = this.getFileBytes(fileName);
        long size = fileBytes.length;
        String hashString = this.getHashString(fileBytes);
        String apiId = "myApi";
        for (int i = 0; i < 2; ++i) {
            String id = "image-" + i;
            this.createMedia(fileName, fileBytes, size, hashString, id, apiId);
        }
        this.createMedia(fileName, fileBytes, size, hashString, "fakeImg", "fakeApi");
        List all = this.mediaRepository.findAllByApi(apiId);
        Assert.assertNotNull((String)"Assets list not found", (Object)all);
        Assert.assertEquals((String)"Invalid assets list", (long)2L, (long)all.size());
        Media imageDataSaved = (Media)all.get(1);
        Assert.assertEquals((String)"Invalid saved image id.", (Object)"image-1", (Object)imageDataSaved.getId());
        Assert.assertNotNull((String)"Invalid saved image size.", (Object)imageDataSaved.getSize());
    }

    @Test
    public void shouldDeleteAllForAnAPI() throws Exception {
        String fileName = "stars.png";
        byte[] fileBytes = this.getFileBytes(fileName);
        long size = fileBytes.length;
        String hashString = this.getHashString(fileBytes);
        String apiId = "myApi";
        for (int i = 0; i < 2; ++i) {
            String id = "image-" + i;
            this.createMedia(fileName, fileBytes, size, hashString, id, apiId);
        }
        List all = this.mediaRepository.findAllByApi(apiId);
        Assert.assertNotNull((String)"Assets list not found", (Object)all);
        Assert.assertEquals((String)"Invalid assets list", (long)2L, (long)all.size());
        this.mediaRepository.deleteAllByApi(apiId);
        Optional image = this.mediaRepository.findByHashAndType(hashString, "image");
        Assert.assertFalse((String)"Invalid asset found", (boolean)image.isPresent());
    }

    private Media createMedia(String fileName, byte[] fileBytes, long size, String hashString, String id, String api) throws TechnicalException {
        Media imageData = new Media();
        imageData.setId(id);
        imageData.setType("image");
        imageData.setSubType(fileName.substring(fileName.lastIndexOf(46) + 1));
        imageData.setFileName(fileName);
        imageData.setData(fileBytes);
        imageData.setSize(Long.valueOf(size));
        imageData.setHash(hashString);
        if (api != null) {
            imageData.setApi(api);
        }
        return this.mediaRepository.create(imageData);
    }

    private String getHashString(byte[] fileBytes) throws NoSuchAlgorithmException {
        byte[] hash = MessageDigest.getInstance("MD5").digest(fileBytes);
        return DatatypeConverter.printHexBinary((byte[])hash);
    }

    private byte[] getFileBytes(String fileName) throws URISyntaxException, IOException {
        File file = new File(MediaRepositoryTest.class.getResource(this.getTestCasesPath() + fileName).toURI());
        FileInputStream fileInputStream = new FileInputStream(file);
        return IOUtils.toByteArray((InputStream)fileInputStream);
    }
}

