/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class MembershipRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/membership-tests/";
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional membership = this.membershipRepository.findById("api1_user1");
        Assert.assertTrue((String)"There is a membership", (boolean)membership.isPresent());
        Assert.assertTrue((boolean)((Membership)membership.get()).getRoleId().equals("API_OWNER"));
        Assert.assertEquals((Object)"api1", (Object)((Membership)membership.get()).getReferenceId());
        Assert.assertEquals((Object)"user1", (Object)((Membership)membership.get()).getMemberId());
        Assert.assertEquals((Object)MembershipReferenceType.API, (Object)((Membership)membership.get()).getReferenceType());
        Assert.assertEquals((Object)"myIdp", (Object)((Membership)membership.get()).getSource());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1439022010883L), ((Membership)membership.get()).getUpdatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1439022010883L), ((Membership)membership.get()).getCreatedAt()));
        Assert.assertEquals((Object)"API_OWNER", (Object)((Membership)membership.get()).getRoleId());
    }

    @Test
    public void shouldNotFindById() throws TechnicalException {
        Optional membership = this.membershipRepository.findById("api1");
        Assert.assertFalse((boolean)membership.isPresent());
    }

    @Test
    public void shouldFindAllApiMembers() throws TechnicalException {
        Set memberships = this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.API, "api1", null);
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"user1", (Object)((Membership)memberships.iterator().next()).getMemberId());
    }

    @Test
    public void shouldFindAllApisMembers() throws TechnicalException {
        Set memberships = this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, Arrays.asList("api2", "api3"), null);
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertEquals((long)2L, (long)memberships.size());
        Membership membership1 = new Membership("api2_user2", "user2", MembershipMemberType.USER, "api2", MembershipReferenceType.API, "API_OWNER");
        membership1.setId("api2_user2");
        Membership membership2 = new Membership("api3_user3", "user3", MembershipMemberType.USER, "api3", MembershipReferenceType.API, "API_USER");
        membership2.setId("api3_user3");
        HashSet<Membership> expectedResult = new HashSet<Membership>(Arrays.asList(membership1, membership2));
        Assert.assertTrue((String)"must contain api2 and api3", (boolean)memberships.containsAll(expectedResult));
    }

    @Test
    public void shouldFindApisOwners() throws TechnicalException {
        Set memberships = this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, Arrays.asList("api2", "api3"), "API_OWNER");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertEquals((long)1L, (long)memberships.size());
        Membership membership1 = new Membership("api2_user2", "user2", MembershipMemberType.USER, "api2", MembershipReferenceType.API, "API_OWNER");
        membership1.setId("api2_user2");
        HashSet<Membership> expectedResult = new HashSet<Membership>(Collections.singletonList(membership1));
        Assert.assertTrue((String)"must contain api2", (boolean)memberships.containsAll(expectedResult));
    }

    @Test
    public void shouldFindMembersApis() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdsAndMemberTypeAndReferenceType(Arrays.asList("user2", "user3"), MembershipMemberType.USER, MembershipReferenceType.API);
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertEquals((long)2L, (long)memberships.size());
        Membership membership2 = new Membership("api2_user2", "user2", MembershipMemberType.USER, "api2", MembershipReferenceType.API, "API_OWNER");
        Membership membership3 = new Membership("api3_user3", "user3", MembershipMemberType.USER, "api3", MembershipReferenceType.API, "API_OWNER");
        HashSet<Membership> expectedResult = new HashSet<Membership>(Arrays.asList(membership2, membership3));
        Assert.assertTrue((String)"must contain api2 and api3", (boolean)memberships.containsAll(expectedResult));
    }

    @Test
    public void shouldFindApiOwner() throws TechnicalException {
        Set memberships = this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.API, "api1", "API_OWNER");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"user1", (Object)((Membership)memberships.iterator().next()).getMemberId());
    }

    @Test
    public void shouldFindByMemberIdAndMemberTypeAndReferenceType() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType("user1", MembershipMemberType.USER, MembershipReferenceType.API);
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"api1", (Object)((Membership)memberships.iterator().next()).getReferenceId());
    }

    @Test
    public void shouldFindByMemberIdAndMemberTypeAndReferenceTypeAndRoleId() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndRoleId("user1", MembershipMemberType.USER, MembershipReferenceType.API, "API_OWNER");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Membership membership = (Membership)memberships.iterator().next();
        Assert.assertEquals((Object)"API_OWNER", (Object)membership.getRoleId());
        Assert.assertEquals((Object)"api1", (Object)membership.getReferenceId());
        Assert.assertEquals((Object)"user1", (Object)membership.getMemberId());
    }

    @Test
    public void shouldFindByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user1", MembershipMemberType.USER, MembershipReferenceType.API, "api1");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Membership membership = (Membership)memberships.iterator().next();
        Assert.assertEquals((Object)"API_OWNER", (Object)membership.getRoleId());
        Assert.assertEquals((Object)"api1", (Object)membership.getReferenceId());
        Assert.assertEquals((Object)"user1", (Object)membership.getMemberId());
        Assert.assertEquals((Object)"API_OWNER", (Object)membership.getRoleId());
    }

    @Test
    public void shouldFindByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId("user1", MembershipMemberType.USER, MembershipReferenceType.API, "api1", "API_OWNER");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Membership membership = (Membership)memberships.iterator().next();
        Assert.assertEquals((Object)"API_OWNER", (Object)membership.getRoleId());
        Assert.assertEquals((Object)"api1", (Object)membership.getReferenceId());
        Assert.assertEquals((Object)"user1", (Object)membership.getMemberId());
        Assert.assertEquals((Object)"API_OWNER", (Object)membership.getRoleId());
    }

    @Test
    public void shouldFindByRoleId() throws TechnicalException {
        Set memberships = this.membershipRepository.findByRoleId("APPLICATION_USER");
        Assert.assertNotNull((String)"result must not be null", (Object)memberships);
        Assert.assertTrue((!memberships.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"size", (long)2L, (long)memberships.size());
    }

    @Test
    public void shouldDelete() throws TechnicalException {
        this.membershipRepository.delete("app1_userToDelete");
        Optional optional = this.membershipRepository.findById("app1_userToDelete");
        Assert.assertFalse((String)"There is no membership", (boolean)optional.isPresent());
    }

    @Test
    public void shouldUpdate() throws TechnicalException {
        Membership membership = new Membership("app1_userToDelete", "userToUpdate", MembershipMemberType.USER, "app1", MembershipReferenceType.APPLICATION, "APPLICATION_USER");
        membership.setId("app1_userToUpdate");
        membership.setCreatedAt(new Date(1000000000000L));
        Membership update = this.membershipRepository.update(membership);
        Assert.assertNotNull((Object)update);
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1000000000000L), update.getCreatedAt()));
    }

    @Test
    public void shouldFindByIds() throws TechnicalException {
        Set memberships = this.membershipRepository.findByIds(new HashSet<String>(Arrays.asList("api1_user_findByIds", "api2_user_findByIds", "unknown")));
        Assert.assertNotNull((Object)memberships);
        Assert.assertFalse((boolean)memberships.isEmpty());
        Assert.assertEquals((long)2L, (long)memberships.size());
        Assert.assertTrue((boolean)memberships.stream().map(Membership::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api1_user_findByIds", "api2_user_findByIds")));
    }

    @Test
    public void shouldFindByMemberIdAndMemberType() throws TechnicalException {
        Set memberships = this.membershipRepository.findByMemberIdAndMemberType("user_findByIds", MembershipMemberType.USER);
        Assert.assertNotNull((Object)memberships);
        Assert.assertFalse((boolean)memberships.isEmpty());
        Assert.assertEquals((long)2L, (long)memberships.size());
        Assert.assertTrue((boolean)memberships.stream().map(Membership::getId).collect(Collectors.toList()).containsAll(Arrays.asList("api1_user_findByIds", "api2_user_findByIds")));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownMembership() throws Exception {
        Membership unknownMembership = new Membership();
        unknownMembership.setId("unknown");
        unknownMembership.setMemberId("unknown");
        unknownMembership.setReferenceId("unknown");
        unknownMembership.setReferenceType(MembershipReferenceType.ENVIRONMENT);
        this.membershipRepository.update(unknownMembership);
        Assert.fail((String)"An unknown membership should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.membershipRepository.update(null);
        Assert.fail((String)"A null membership should not be updated");
    }

    @Test
    public void shouldDeleteMembers() throws TechnicalException {
        int m1 = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_1", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef").size();
        int m2 = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_2", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef").size();
        Assert.assertEquals((String)"m1 exists", (long)1L, (long)m1);
        Assert.assertEquals((String)"m2 exists", (long)1L, (long)m2);
        this.membershipRepository.deleteMembers(MembershipReferenceType.API, "api_deleteRef");
        m1 = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_1", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef").size();
        m2 = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_2", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef").size();
        Assert.assertEquals((String)"m1 doesn't exist", (long)0L, (long)m1);
        Assert.assertEquals((String)"m2 doesn't exist", (long)0L, (long)m2);
    }
}

