/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class MetadataRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/metadata-tests/";
    }

    @Test
    public void shouldFindByReferenceType() throws Exception {
        List metadataList = this.metadataRepository.findByReferenceType(MetadataReferenceType.APPLICATION);
        Assert.assertNotNull((Object)metadataList);
        Assert.assertEquals((long)1L, (long)metadataList.size());
    }

    @Test
    public void shouldFindByReferenceTypeAndId() throws Exception {
        List metadataList = this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.API, "apiId");
        Assert.assertNotNull((Object)metadataList);
        Assert.assertEquals((long)1L, (long)metadataList.size());
    }

    @Test
    public void shouldFindByKeyAndReferenceType() throws Exception {
        List metadataList = this.metadataRepository.findByKeyAndReferenceType("string", MetadataReferenceType.API);
        Assert.assertNotNull((Object)metadataList);
        Assert.assertEquals((long)1L, (long)metadataList.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        Metadata metadata = new Metadata();
        metadata.setKey("new-metadata");
        metadata.setReferenceType(MetadataReferenceType.DEFAULT);
        metadata.setReferenceId("_");
        metadata.setName("Metadata name");
        metadata.setFormat(MetadataFormat.STRING);
        metadata.setValue("String");
        int nbMetadataListBeforeCreation = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).size();
        this.metadataRepository.create(metadata);
        int nbMetadataListAfterCreation = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).size();
        Assert.assertEquals((long)(nbMetadataListBeforeCreation + 1), (long)nbMetadataListAfterCreation);
        Optional optional = this.metadataRepository.findById("new-metadata", "_", MetadataReferenceType.DEFAULT);
        Assert.assertTrue((String)"Metadata saved not found", (boolean)optional.isPresent());
        Metadata metadataSaved = (Metadata)optional.get();
        Assert.assertEquals((String)"Invalid saved metadata name.", (Object)metadata.getName(), (Object)metadataSaved.getName());
        Assert.assertEquals((String)"Invalid metadata format.", (Object)metadata.getFormat(), (Object)metadataSaved.getFormat());
        Assert.assertEquals((String)"Invalid metadata value.", (Object)metadata.getValue(), (Object)metadataSaved.getValue());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.metadataRepository.findById("boolean", "_", MetadataReferenceType.DEFAULT);
        Assert.assertTrue((String)"Metadata to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved metadata name.", (Object)"Boolean", (Object)((Metadata)optional.get()).getName());
        Metadata metadata = (Metadata)optional.get();
        metadata.setName("New metadata");
        metadata.setFormat(MetadataFormat.URL);
        metadata.setValue("New value");
        int nbMetadataListBeforeUpdate = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).size();
        this.metadataRepository.update(metadata);
        int nbMetadataListAfterUpdate = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).size();
        Assert.assertEquals((long)nbMetadataListBeforeUpdate, (long)nbMetadataListAfterUpdate);
        Optional optionalUpdated = this.metadataRepository.findById("boolean", "_", MetadataReferenceType.DEFAULT);
        Assert.assertTrue((String)"Metadata to update not found", (boolean)optionalUpdated.isPresent());
        Metadata metadataUpdated = (Metadata)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved metadata name.", (Object)"New metadata", (Object)metadataUpdated.getName());
        Assert.assertEquals((String)"Invalid metadata value.", (Object)"New value", (Object)metadataUpdated.getValue());
        Assert.assertEquals((String)"Invalid metadata format.", (Object)MetadataFormat.URL, (Object)metadataUpdated.getFormat());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbMetadataListBeforeDeletion = this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.APPLICATION, "applicationId").size();
        this.metadataRepository.delete("mail", "applicationId", MetadataReferenceType.APPLICATION);
        int nbMetadataListAfterDeletion = this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.APPLICATION, "applicationId").size();
        Assert.assertEquals((long)(nbMetadataListBeforeDeletion - 1), (long)nbMetadataListAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownMetadata() throws Exception {
        Metadata unknownMetadata = new Metadata();
        unknownMetadata.setKey("unknown");
        unknownMetadata.setReferenceId("unknown");
        unknownMetadata.setReferenceType(MetadataReferenceType.DEFAULT);
        this.metadataRepository.update(unknownMetadata);
        Assert.fail((String)"An unknown metadata should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.metadataRepository.update(null);
        Assert.fail((String)"A null metadata should not be updated");
    }
}

