/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.NotificationTemplate;
import io.gravitee.repository.management.model.NotificationTemplateReferenceType;
import io.gravitee.repository.management.model.NotificationTemplateType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class NotificationTemplateRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/notificationtemplate-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set notificationTemplates = this.notificationTemplateRepository.findAll();
        Assert.assertNotNull((Object)notificationTemplates);
        Assert.assertEquals((long)4L, (long)notificationTemplates.size());
    }

    @Test
    public void shouldFindByType() throws Exception {
        Set notificationTemplates = this.notificationTemplateRepository.findByTypeAndReferenceIdAndReferenceType(NotificationTemplateType.PORTAL, "DEFAULT", NotificationTemplateReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)notificationTemplates);
        Assert.assertEquals((long)3L, (long)notificationTemplates.size());
    }

    @Test
    public void shouldFindAllByReferenceIdAndReferenceType() throws Exception {
        Set notificationTemplates = this.notificationTemplateRepository.findAllByReferenceIdAndReferenceType("DEFAULT", NotificationTemplateReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)notificationTemplates);
        Assert.assertEquals((long)4L, (long)notificationTemplates.size());
    }

    @Test
    public void shouldFindByHookAndReferenceIdAndReferenceType() throws Exception {
        Set notificationTemplates = this.notificationTemplateRepository.findByHookAndScopeAndReferenceIdAndReferenceType("MY_HOOK_3", "API", "DEFAULT", NotificationTemplateReferenceType.ORGANIZATION);
        Assert.assertNotNull((Object)notificationTemplates);
        Assert.assertEquals((long)2L, (long)notificationTemplates.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        NotificationTemplate notificationTemplate = new NotificationTemplate();
        notificationTemplate.setId("new-notificationTemplate");
        notificationTemplate.setHook("MY_NEW_HOOK");
        notificationTemplate.setScope("API");
        notificationTemplate.setReferenceId("DEFAULT");
        notificationTemplate.setReferenceType(NotificationTemplateReferenceType.ORGANIZATION);
        notificationTemplate.setName("My notif 1");
        notificationTemplate.setDescription("Description for my notif 1");
        notificationTemplate.setTitle("Title of my notif");
        notificationTemplate.setContent("Content of my notif");
        notificationTemplate.setCreatedAt(new Date(1000000000000L));
        notificationTemplate.setUpdatedAt(new Date(1439032010883L));
        notificationTemplate.setType(NotificationTemplateType.PORTAL);
        notificationTemplate.setEnabled(true);
        int nbNotificationTemplatesBeforeCreation = this.notificationTemplateRepository.findAll().size();
        this.notificationTemplateRepository.create(notificationTemplate);
        int nbNotificationTemplatesAfterCreation = this.notificationTemplateRepository.findAll().size();
        Assert.assertEquals((long)(nbNotificationTemplatesBeforeCreation + 1), (long)nbNotificationTemplatesAfterCreation);
        Optional optional = this.notificationTemplateRepository.findById("new-notificationTemplate");
        Assert.assertTrue((String)"NotificationTemplate saved not found", (boolean)optional.isPresent());
        NotificationTemplate notificationTemplateSaved = (NotificationTemplate)optional.get();
        Assert.assertEquals((String)"Invalid saved hook.", (Object)notificationTemplate.getHook(), (Object)notificationTemplateSaved.getHook());
        Assert.assertEquals((String)"Invalid saved scope.", (Object)notificationTemplate.getScope(), (Object)notificationTemplateSaved.getScope());
        Assert.assertEquals((String)"Invalid saved reference id.", (Object)notificationTemplate.getReferenceId(), (Object)notificationTemplateSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid saved reference Type", (Object)notificationTemplate.getReferenceType(), (Object)notificationTemplateSaved.getReferenceType());
        Assert.assertEquals((String)"Invalid saved notificationTemplate name.", (Object)notificationTemplate.getName(), (Object)notificationTemplateSaved.getName());
        Assert.assertEquals((String)"Invalid notificationTemplate description.", (Object)notificationTemplate.getDescription(), (Object)notificationTemplateSaved.getDescription());
        Assert.assertEquals((String)"Invalid saved notificationTemplate title.", (Object)notificationTemplate.getTitle(), (Object)notificationTemplateSaved.getTitle());
        Assert.assertEquals((String)"Invalid notificationTemplate content.", (Object)notificationTemplate.getContent(), (Object)notificationTemplateSaved.getContent());
        Assert.assertTrue((String)"Invalid notificationTemplate createdAt.", (boolean)DateUtils.compareDate(notificationTemplate.getCreatedAt(), notificationTemplateSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid notificationTemplate updatedAt.", (boolean)DateUtils.compareDate(notificationTemplate.getUpdatedAt(), notificationTemplateSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid notificationTemplate type.", (Object)notificationTemplate.getType(), (Object)notificationTemplateSaved.getType());
        Assert.assertEquals((String)"Invalid notificationTemplate enabled.", (Object)notificationTemplate.isEnabled(), (Object)notificationTemplateSaved.isEnabled());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.notificationTemplateRepository.findById("notif-1");
        Assert.assertTrue((String)"NotificationTemplate to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved notificationTemplate name.", (Object)"My notif 1", (Object)((NotificationTemplate)optional.get()).getName());
        NotificationTemplate notificationTemplate = (NotificationTemplate)optional.get();
        notificationTemplate.setHook("MY_HOOK");
        notificationTemplate.setScope("API");
        notificationTemplate.setReferenceId("DEFAULT");
        notificationTemplate.setReferenceType(NotificationTemplateReferenceType.ORGANIZATION);
        notificationTemplate.setName("My notif 1");
        notificationTemplate.setDescription("Description for my notif 1");
        notificationTemplate.setTitle("Title of my notif");
        notificationTemplate.setContent("Content of my notif");
        notificationTemplate.setCreatedAt(new Date(1000000000000L));
        notificationTemplate.setUpdatedAt(new Date(1486771200000L));
        notificationTemplate.setType(NotificationTemplateType.PORTAL);
        notificationTemplate.setEnabled(true);
        int nbNotificationTemplatesBeforeUpdate = this.notificationTemplateRepository.findAll().size();
        this.notificationTemplateRepository.update(notificationTemplate);
        int nbNotificationTemplatesAfterUpdate = this.notificationTemplateRepository.findAll().size();
        Assert.assertEquals((long)nbNotificationTemplatesBeforeUpdate, (long)nbNotificationTemplatesAfterUpdate);
        Optional optionalUpdated = this.notificationTemplateRepository.findById("notif-1");
        Assert.assertTrue((String)"NotificationTemplate to update not found", (boolean)optionalUpdated.isPresent());
        NotificationTemplate notificationTemplateUpdated = (NotificationTemplate)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved hook.", (Object)notificationTemplate.getHook(), (Object)notificationTemplateUpdated.getHook());
        Assert.assertEquals((String)"Invalid saved scope.", (Object)notificationTemplate.getScope(), (Object)notificationTemplateUpdated.getScope());
        Assert.assertEquals((String)"Invalid saved reference id.", (Object)notificationTemplate.getReferenceId(), (Object)notificationTemplateUpdated.getReferenceId());
        Assert.assertEquals((String)"Invalid saved reference type.", (Object)notificationTemplate.getReferenceType(), (Object)notificationTemplateUpdated.getReferenceType());
        Assert.assertEquals((String)"Invalid saved notificationTemplate name.", (Object)notificationTemplate.getName(), (Object)notificationTemplateUpdated.getName());
        Assert.assertEquals((String)"Invalid notificationTemplate description.", (Object)notificationTemplate.getDescription(), (Object)notificationTemplateUpdated.getDescription());
        Assert.assertEquals((String)"Invalid saved notificationTemplate title.", (Object)notificationTemplate.getTitle(), (Object)notificationTemplateUpdated.getTitle());
        Assert.assertEquals((String)"Invalid notificationTemplate content.", (Object)notificationTemplate.getContent(), (Object)notificationTemplateUpdated.getContent());
        Assert.assertTrue((String)"Invalid notificationTemplate createdAt.", (boolean)DateUtils.compareDate(notificationTemplate.getCreatedAt(), notificationTemplateUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid notificationTemplate updatedAt.", (boolean)DateUtils.compareDate(notificationTemplate.getUpdatedAt(), notificationTemplateUpdated.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid notificationTemplate type.", (Object)notificationTemplate.getType(), (Object)notificationTemplateUpdated.getType());
        Assert.assertEquals((String)"Invalid notificationTemplate enabled.", (Object)notificationTemplate.isEnabled(), (Object)notificationTemplateUpdated.isEnabled());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbNotificationTemplatesBeforeDeletion = this.notificationTemplateRepository.findAll().size();
        this.notificationTemplateRepository.delete("notif-3-email");
        int nbNotificationTemplatesAfterDeletion = this.notificationTemplateRepository.findAll().size();
        Assert.assertEquals((long)(nbNotificationTemplatesBeforeDeletion - 1), (long)nbNotificationTemplatesAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownTemplate() throws Exception {
        NotificationTemplate unknownNotificationTemplate = new NotificationTemplate();
        unknownNotificationTemplate.setId("unknown");
        unknownNotificationTemplate.setReferenceId("DEFAULT");
        unknownNotificationTemplate.setReferenceType(NotificationTemplateReferenceType.ORGANIZATION);
        this.notificationTemplateRepository.update(unknownNotificationTemplate);
        Assert.fail((String)"An unknown notificationTemplate should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.notificationTemplateRepository.update(null);
        Assert.fail((String)"A null notificationTemplate should not be updated");
    }
}

