/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Organization;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class OrganizationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/organization-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        Organization organization = new Organization();
        organization.setId("DEFAULT-ORG-create");
        organization.setHrids(Arrays.asList("hrid1", "hrid2"));
        organization.setName("Default org for create");
        organization.setDescription("Default org description for create");
        organization.setDomainRestrictions(Arrays.asList("domain", "restriction"));
        Organization createdOrg = (Organization)this.organizationRepository.create((Object)organization);
        Assert.assertEquals((Object)organization.getId(), (Object)createdOrg.getId());
        Assert.assertEquals((Object)organization.getName(), (Object)createdOrg.getName());
        Assert.assertEquals((Object)organization.getDescription(), (Object)createdOrg.getDescription());
        Assert.assertEquals((Object)organization.getHrids(), (Object)createdOrg.getHrids());
        List domainRestrictions = createdOrg.getDomainRestrictions();
        Assert.assertNotNull((Object)domainRestrictions);
        Assert.assertEquals((long)2L, (long)domainRestrictions.size());
        Assert.assertTrue((boolean)domainRestrictions.contains("domain"));
        Assert.assertTrue((boolean)domainRestrictions.contains("restriction"));
        Optional optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-create");
        Assert.assertTrue((String)"Organization to create not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-update");
        Assert.assertTrue((String)"Organization to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved Organization name.", (Object)"Default org for update", (Object)((Organization)optional.get()).getName());
        Organization org = (Organization)optional.get();
        org.setName("New name");
        Organization fetchedOrganization = (Organization)this.organizationRepository.update((Object)org);
        Assert.assertEquals((Object)org.getName(), (Object)fetchedOrganization.getName());
        optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-update");
        Assert.assertTrue((String)"Organization to update not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldDelete() throws Exception {
        Optional optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-delete");
        Assert.assertTrue((String)"Organization to delete not found", (boolean)optional.isPresent());
        this.organizationRepository.delete((Object)"DEFAULT-ORG-delete");
        optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-delete");
        Assert.assertFalse((String)"Organization to delete has not been deleted", (boolean)optional.isPresent());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optional = this.organizationRepository.findById((Object)"DEFAULT-ORG-findById");
        Assert.assertTrue((String)"Organization to find not found", (boolean)optional.isPresent());
    }

    @Test
    public void shouldCount() throws Exception {
        long count = this.organizationRepository.count();
        Assert.assertEquals((String)"Organization count should be 3", (long)3L, (long)count);
    }
}

