/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageMedia;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class PageRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/page-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        io.gravitee.common.data.domain.Page pages = this.pageRepository.findAll(new PageableBuilder().pageNumber(0).pageSize(100).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)11L, (long)pages.getTotalElements());
        Assert.assertEquals((long)11L, (long)pages.getPageElements());
        Assert.assertEquals((long)11L, (long)pages.getContent().size());
        Page findApiPage = pages.getContent().stream().filter(p -> p.getId().equals("FindApiPage")).findFirst().get();
        this.assertFindPage(findApiPage);
    }

    @Test
    public void shouldFindAll_Paging() throws Exception {
        boolean findApiTested = false;
        HashSet<String> ids = new HashSet<String>();
        int pageNumber = 0;
        do {
            Pageable build = new PageableBuilder().pageNumber(pageNumber).pageSize(1).build();
            io.gravitee.common.data.domain.Page pages = this.pageRepository.findAll(build);
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)11L, (long)pages.getTotalElements());
            Assert.assertEquals((long)1L, (long)pages.getPageElements());
            Assert.assertEquals((long)1L, (long)pages.getContent().size());
            Page foundPage = (Page)pages.getContent().get(0);
            ids.add(foundPage.getId());
            if (!foundPage.getId().equals("FindApiPage")) continue;
            this.assertFindPage(foundPage);
            findApiTested = true;
        } while (++pageNumber < 11);
        Assert.assertTrue((boolean)findApiTested);
        Assert.assertEquals((long)11L, (long)ids.size());
    }

    @Test
    public void shouldFindApiPageById() throws Exception {
        Optional page = this.pageRepository.findById("FindApiPage");
        Assert.assertNotNull((Object)page);
        Assert.assertTrue((boolean)page.isPresent());
        this.assertFindPage((Page)page.get());
    }

    private void assertFindPage(Page page) {
        Assert.assertEquals((String)"id", (Object)"FindApiPage", (Object)page.getId());
        Assert.assertEquals((String)"name", (Object)"Find apiPage by apiId or Id", (Object)page.getName());
        Assert.assertEquals((String)"content", (Object)"Content of the page", (Object)page.getContent());
        Assert.assertEquals((String)"reference id", (Object)"my-api", (Object)page.getReferenceId());
        Assert.assertEquals((String)"reference type", (Object)PageReferenceType.API, (Object)page.getReferenceType());
        Assert.assertEquals((String)"type", (Object)"MARKDOWN", (Object)page.getType());
        Assert.assertEquals((String)"last contributor", (Object)"john_doe", (Object)page.getLastContributor());
        Assert.assertEquals((String)"order", (long)2L, (long)page.getOrder());
        Assert.assertTrue((String)"published", (boolean)page.isPublished());
        Assert.assertEquals((String)"source type", (Object)"sourceType", (Object)page.getSource().getType());
        Assert.assertEquals((String)"source configuration", (Object)"sourceConfiguration", (Object)page.getSource().getConfiguration());
        Assert.assertEquals((String)"configuration try it", (Object)"true", page.getConfiguration().get("tryIt"));
        Assert.assertEquals((String)"configuration try it URL", (Object)"http://company.com", page.getConfiguration().get("tryItURL"));
        Assert.assertEquals((String)"configuration show URL", (Object)"true", page.getConfiguration().get("showURL"));
        Assert.assertEquals((String)"configuration display operation id", (Object)"true", page.getConfiguration().get("displayOperationId"));
        Assert.assertEquals((String)"configuration doc expansion", (Object)"FULL", page.getConfiguration().get("docExpansion"));
        Assert.assertEquals((String)"configuration enable filtering", (Object)"true", page.getConfiguration().get("enableFiltering"));
        Assert.assertEquals((String)"configuration show extensions", (Object)"true", page.getConfiguration().get("showExtensions"));
        Assert.assertEquals((String)"configuration show common extensions", (Object)"true", page.getConfiguration().get("showCommonExtensions"));
        Assert.assertEquals((String)"configuration maxDisplayedTags", (Object)"1234", page.getConfiguration().get("maxDisplayedTags"));
        Assert.assertEquals((String)"metadata edit_url", (Object)"http://provider.com/edit/page", page.getMetadata().get("edit_url"));
        Assert.assertEquals((String)"metadata size", (Object)"256", page.getMetadata().get("size"));
        Assert.assertTrue((String)"homepage", (boolean)page.isHomepage());
        Assert.assertEquals((String)"excludedGroups", Arrays.asList("grp1", "grp2"), (Object)page.getExcludedGroups());
        List attachedMedia = page.getAttachedMedia();
        Assert.assertNotNull((Object)attachedMedia);
        Assert.assertEquals((String)"attachedMedia", (long)2L, (long)attachedMedia.size());
        Assert.assertEquals((String)"attachedMedia", Arrays.asList(new PageMedia("media_id_1", "media_name_1", new Date(1586771200000L)), new PageMedia("media_id_2", "media_name_2", new Date(1587771200000L))), (Object)attachedMedia);
        Assert.assertTrue((String)"created at", (boolean)DateUtils.compareDate(new Date(1486771200000L), page.getCreatedAt()));
        Assert.assertTrue((String)"updated at", (boolean)DateUtils.compareDate(new Date(1486771200000L), page.getUpdatedAt()));
        Assert.assertTrue((String)"no autofetch", (boolean)page.getUseAutoFetch());
    }

    @Test
    public void shouldCreateApiPage() throws Exception {
        Page page = new Page();
        page.setId("new-page");
        page.setName("Page name");
        page.setContent("Page content");
        page.setOrder(3);
        page.setReferenceId("my-api");
        page.setReferenceType(PageReferenceType.API);
        page.setHomepage(true);
        page.setType("MARKDOWN");
        page.setParentId("2");
        page.setCreatedAt(new Date());
        page.setUpdatedAt(new Date());
        page.setUseAutoFetch(Boolean.FALSE);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("displayOperationId", "true");
        configuration.put("docExpansion", "FULL");
        configuration.put("showCommonExtensions", "true");
        configuration.put("maxDisplayedTags", "1234");
        configuration.put("enableFiltering", "true");
        configuration.put("tryItURL", "http://company.com");
        configuration.put("showURL", "true");
        configuration.put("showExtensions", "true");
        configuration.put("tryIt", "true");
        page.setConfiguration(configuration);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        page.setMetadata(metadata);
        Optional optionalBefore = this.pageRepository.findById("new-page");
        this.pageRepository.create(page);
        Optional optionalAfter = this.pageRepository.findById("new-page");
        Assert.assertFalse((String)"Page not found before", (boolean)optionalBefore.isPresent());
        Assert.assertTrue((String)"Page saved not found", (boolean)optionalAfter.isPresent());
        Page pageSaved = (Page)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved page name.", (Object)page.getName(), (Object)pageSaved.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)page.getContent(), (Object)pageSaved.getContent());
        Assert.assertEquals((String)"Invalid page order.", (long)page.getOrder(), (long)pageSaved.getOrder());
        Assert.assertEquals((String)"Invalid page type.", (Object)page.getType(), (Object)pageSaved.getType());
        Assert.assertEquals((String)"Invalid homepage flag.", (Object)page.isHomepage(), (Object)pageSaved.isHomepage());
        Assert.assertEquals((String)"Invalid parentId.", (Object)page.getParentId(), (Object)pageSaved.getParentId());
        Assert.assertNull((String)"Invalid page source.", (Object)page.getSource());
        Assert.assertEquals((String)"Invalid configuration.", (Object)page.getConfiguration(), (Object)pageSaved.getConfiguration());
        Assert.assertEquals((String)"Invalid metadata.", (Object)page.getMetadata(), (Object)pageSaved.getMetadata());
        Assert.assertEquals((String)"Invalid useAutoFetch.", (Object)page.getUseAutoFetch(), (Object)pageSaved.getUseAutoFetch());
    }

    @Test
    public void shouldCreateApiFolderPage() throws Exception {
        Page page = new Page();
        page.setId("new-page-folder");
        page.setName("Folder name");
        page.setOrder(3);
        page.setReferenceId("my-api");
        page.setReferenceType(PageReferenceType.API);
        page.setHomepage(false);
        page.setParentId("");
        page.setType("FOLDER");
        page.setCreatedAt(new Date());
        page.setUpdatedAt(new Date());
        Optional optionalBefore = this.pageRepository.findById("new-page-folder");
        this.pageRepository.create(page);
        Optional optionalAfter = this.pageRepository.findById("new-page-folder");
        Assert.assertFalse((String)"Page not found before", (boolean)optionalBefore.isPresent());
        Assert.assertTrue((String)"Page saved not found", (boolean)optionalAfter.isPresent());
        Page pageSaved = (Page)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved page name.", (Object)page.getName(), (Object)pageSaved.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)page.getContent(), (Object)pageSaved.getContent());
        Assert.assertEquals((String)"Invalid page order.", (long)page.getOrder(), (long)pageSaved.getOrder());
        Assert.assertEquals((String)"Invalid page type.", (Object)page.getType(), (Object)pageSaved.getType());
        Assert.assertEquals((String)"Invalid ParentId.", (Object)page.getParentId(), (Object)pageSaved.getParentId());
        Assert.assertNull((String)"Invalid page source.", (Object)page.getSource());
    }

    @Test
    public void shouldCreatePortalPage() throws Exception {
        Page page = new Page();
        page.setId("new-portal-page");
        page.setReferenceId("DEFAULT");
        page.setReferenceType(PageReferenceType.ENVIRONMENT);
        page.setName("Page name");
        page.setContent("Page content");
        page.setOrder(3);
        page.setType("MARKDOWN");
        page.setParentId("2");
        page.setCreatedAt(new Date());
        page.setUpdatedAt(new Date());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("displayOperationId", "true");
        configuration.put("docExpansion", "FULL");
        configuration.put("showCommonExtensions", "true");
        configuration.put("maxDisplayedTags", "1234");
        configuration.put("enableFiltering", "true");
        configuration.put("tryItURL", "http://company.com");
        configuration.put("showURL", "true");
        configuration.put("showExtensions", "true");
        configuration.put("tryIt", "true");
        page.setConfiguration(configuration);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        page.setMetadata(metadata);
        Optional optionalBefore = this.pageRepository.findById("new-portal-page");
        this.pageRepository.create(page);
        Optional optionalAfter = this.pageRepository.findById("new-portal-page");
        Assert.assertFalse((String)"Page not found before", (boolean)optionalBefore.isPresent());
        Assert.assertTrue((String)"Page saved not found", (boolean)optionalAfter.isPresent());
        Page pageSaved = (Page)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved page name.", (Object)page.getName(), (Object)pageSaved.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)page.getContent(), (Object)pageSaved.getContent());
        Assert.assertEquals((String)"Invalid page order.", (long)page.getOrder(), (long)pageSaved.getOrder());
        Assert.assertEquals((String)"Invalid page type.", (Object)page.getType(), (Object)pageSaved.getType());
        Assert.assertEquals((String)"Invalid parentId.", (Object)page.getParentId(), (Object)pageSaved.getParentId());
        Assert.assertEquals((String)"Invalid homepage flag.", (Object)page.isHomepage(), (Object)pageSaved.isHomepage());
        Assert.assertNull((String)"Invalid page source.", (Object)page.getSource());
        Assert.assertEquals((String)"Invalid configuration.", (Object)page.getConfiguration(), (Object)pageSaved.getConfiguration());
        Assert.assertEquals((String)"Invalid metadata.", (Object)page.getMetadata(), (Object)pageSaved.getMetadata());
    }

    @Test
    public void shouldCreatePortalFolderPage() throws Exception {
        Page page = new Page();
        page.setId("new-portal-page-folder");
        page.setReferenceId("DEFAULT");
        page.setReferenceType(PageReferenceType.ENVIRONMENT);
        page.setName("Folder name");
        page.setOrder(3);
        page.setType("FOLDER");
        page.setCreatedAt(new Date());
        page.setUpdatedAt(new Date());
        page.setParentId("");
        page.setParentId("");
        page.setUseAutoFetch(Boolean.valueOf(false));
        Optional optionalBefore = this.pageRepository.findById("new-portal-page-folder");
        this.pageRepository.create(page);
        Optional optionalAfter = this.pageRepository.findById("new-portal-page-folder");
        Assert.assertFalse((String)"Page not found before", (boolean)optionalBefore.isPresent());
        Assert.assertTrue((String)"Page saved not found", (boolean)optionalAfter.isPresent());
        Page pageSaved = (Page)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved page name.", (Object)page.getName(), (Object)pageSaved.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)page.getContent(), (Object)pageSaved.getContent());
        Assert.assertEquals((String)"Invalid page order.", (long)page.getOrder(), (long)pageSaved.getOrder());
        Assert.assertEquals((String)"Invalid page type.", (Object)page.getType(), (Object)pageSaved.getType());
        Assert.assertEquals((String)"Invalid ParentId.", (Object)page.getParentId(), (Object)pageSaved.getParentId());
        Assert.assertNull((String)"Invalid page source.", (Object)page.getSource());
        Assert.assertFalse((String)"Invalid useAutoFetch.", (boolean)page.getUseAutoFetch());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optionalBefore = this.pageRepository.findById("updatePage");
        Assert.assertTrue((String)"Page to update not found", (boolean)optionalBefore.isPresent());
        Assert.assertEquals((String)"Invalid page name.", (Object)"Update Page", (Object)((Page)optionalBefore.get()).getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)"Content of the update page", (Object)((Page)optionalBefore.get()).getContent());
        Page page = (Page)optionalBefore.get();
        page.setId("updatePage");
        page.setName("New name");
        page.setContent("New content");
        page.setReferenceId("my-api-2");
        page.setReferenceType(PageReferenceType.API);
        page.setType("SWAGGER");
        page.setOrder(1);
        page.setUpdatedAt(new Date(1486771200000L));
        page.setCreatedAt(new Date(1486772200000L));
        page.setParentId("parent-123");
        page.setHomepage(true);
        page.setExcludedGroups(Collections.singletonList("excluded"));
        page.setAttachedMedia(Collections.singletonList(new PageMedia("media_id", "media_name", new Date(1586771200000L))));
        page.setLastContributor("me");
        page.setPublished(true);
        page.setConfiguration(new HashMap());
        page.getConfiguration().put("tryIt", "true");
        page.getConfiguration().put("tryItURL", "http://company.com");
        page.getConfiguration().put("showURL", "true");
        page.getConfiguration().put("displayOperationId", "true");
        page.getConfiguration().put("docExpansion", "FULL");
        page.getConfiguration().put("enableFiltering", "true");
        page.getConfiguration().put("showExtensions", "true");
        page.getConfiguration().put("showCommonExtensions", "true");
        page.getConfiguration().put("maxDisplayedTags", "1234");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        page.setMetadata(metadata);
        this.assertUpdatedPage(this.pageRepository.update(page));
        this.assertUpdatedPage((Page)this.pageRepository.findById("updatePage").get());
    }

    private void assertUpdatedPage(Page updatedPage) {
        Assert.assertNotNull((String)"Page to update not found", (Object)updatedPage);
        Assert.assertEquals((String)"Invalid saved page name.", (Object)"New name", (Object)updatedPage.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)"New content", (Object)updatedPage.getContent());
        Assert.assertEquals((String)"Invalid reference id.", (Object)"my-api-2", (Object)updatedPage.getReferenceId());
        Assert.assertEquals((String)"Invalid reference type.", (Object)PageReferenceType.API, (Object)updatedPage.getReferenceType());
        Assert.assertEquals((String)"Invalid type.", (Object)"SWAGGER", (Object)updatedPage.getType());
        Assert.assertEquals((String)"Invalid order.", (long)1L, (long)updatedPage.getOrder());
        Assert.assertTrue((String)"Invalid updatedAt.", (boolean)DateUtils.compareDate(new Date(1486771200000L), updatedPage.getUpdatedAt()));
        Assert.assertTrue((String)"Invalid createdAt.", (boolean)DateUtils.compareDate(new Date(1486772200000L), updatedPage.getCreatedAt()));
        Assert.assertEquals((String)"Invalid parent id.", (Object)"parent-123", (Object)updatedPage.getParentId());
        Assert.assertTrue((String)"Invalid homepage.", (boolean)updatedPage.isHomepage());
        Assert.assertTrue((String)"Invalid excluded groups.", (!updatedPage.getExcludedGroups().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Invalid attached media.", (!updatedPage.getAttachedMedia().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Invalid last contributor.", (Object)"me", (Object)updatedPage.getLastContributor());
        Assert.assertTrue((String)"Invalid published.", (boolean)updatedPage.isPublished());
        Assert.assertEquals((String)"configuration try it", (Object)"true", updatedPage.getConfiguration().get("tryIt"));
        Assert.assertEquals((String)"configuration try it URL", (Object)"http://company.com", updatedPage.getConfiguration().get("tryItURL"));
        Assert.assertEquals((String)"configuration show URL", (Object)"true", updatedPage.getConfiguration().get("showURL"));
        Assert.assertEquals((String)"configuration display operation id", (Object)"true", updatedPage.getConfiguration().get("displayOperationId"));
        Assert.assertEquals((String)"configuration doc expansion", (Object)"FULL", updatedPage.getConfiguration().get("docExpansion"));
        Assert.assertEquals((String)"configuration enable filtering", (Object)"true", updatedPage.getConfiguration().get("enableFiltering"));
        Assert.assertEquals((String)"configuration show extensions", (Object)"true", updatedPage.getConfiguration().get("showExtensions"));
        Assert.assertEquals((String)"configuration show common extensions", (Object)"true", updatedPage.getConfiguration().get("showCommonExtensions"));
        Assert.assertEquals((String)"configuration maxDisplayedTags", (Object)"1234", updatedPage.getConfiguration().get("maxDisplayedTags"));
        Assert.assertEquals((String)"metadata edit_url", (Object)"url", updatedPage.getMetadata().get("edit_url"));
        Assert.assertEquals((String)"metadata size", (Object)"10", updatedPage.getMetadata().get("size"));
    }

    @Test
    public void shouldUpdateFolderPage() throws Exception {
        Optional optionalBefore = this.pageRepository.findById("updatePageFolder");
        Assert.assertTrue((String)"Page to update not found", (boolean)optionalBefore.isPresent());
        Assert.assertEquals((String)"Invalid page name.", (Object)"Update Page Folder", (Object)((Page)optionalBefore.get()).getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)"Content of the update page folder", (Object)((Page)optionalBefore.get()).getContent());
        Assert.assertEquals((String)"Invalid page parentId.", (Object)"2", (Object)((Page)optionalBefore.get()).getParentId());
        Page page = (Page)optionalBefore.get();
        page.setId("updatePageFolder");
        page.setName("New name page folder");
        page.setContent("New content page folder");
        page.setParentId("3");
        this.assertUpdatePageFolder(this.pageRepository.update(page));
        this.assertUpdatePageFolder((Page)this.pageRepository.findById("updatePageFolder").get());
    }

    private void assertUpdatePageFolder(Page updatedPage) {
        Assert.assertNotNull((String)"Page to update not found", (Object)updatedPage);
        Assert.assertEquals((String)"Invalid saved page name.", (Object)"New name page folder", (Object)updatedPage.getName());
        Assert.assertEquals((String)"Invalid page content.", (Object)"New content page folder", (Object)updatedPage.getContent());
        Assert.assertEquals((String)"Invalid page parentId.", (Object)"3", (Object)updatedPage.getParentId());
        Assert.assertEquals((String)"Invalid page reference type.", (Object)PageReferenceType.API, (Object)updatedPage.getReferenceType());
        Assert.assertEquals((String)"Invalid page reference id.", (Object)"my-api-3", (Object)updatedPage.getReferenceId());
    }

    @Test
    public void shouldDelete() throws Exception {
        Optional pageShouldExists = this.pageRepository.findById("page-to-be-deleted");
        this.pageRepository.delete("page-to-be-deleted");
        Optional pageShouldNotExists = this.pageRepository.findById("page-to-be-deleted");
        Assert.assertTrue((String)"should exists before delete", (boolean)pageShouldExists.isPresent());
        Assert.assertFalse((String)"should not exists after delete", (boolean)pageShouldNotExists.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownPage() throws Exception {
        Page unknownPage = new Page();
        unknownPage.setId("unknown");
        unknownPage.setReferenceId("DEFAULT");
        unknownPage.setReferenceType(PageReferenceType.ENVIRONMENT);
        this.pageRepository.update(unknownPage);
        Assert.fail((String)"An unknown page should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.pageRepository.update(null);
        Assert.fail((String)"A null page should not be updated");
    }

    @Test
    public void shouldFindMaxApiPageOrderByApiId() throws TechnicalException {
        Integer maxApiPageOrderByApiId = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("my-api-2", PageReferenceType.API);
        Assert.assertEquals((Object)2, (Object)maxApiPageOrderByApiId);
    }

    @Test
    public void shouldFindDefaultMaxApiPageOrderByApiId() throws TechnicalException {
        Integer maxApiPageOrderByApiId = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("unknown api id", PageReferenceType.API);
        Assert.assertEquals((Object)0, (Object)maxApiPageOrderByApiId);
    }

    @Test
    public void shouldFindMaxPortalPageOrder() throws TechnicalException {
        Integer maxPortalPageOrder = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("DEFAULT", PageReferenceType.ENVIRONMENT);
        Assert.assertEquals((Object)20, (Object)maxPortalPageOrder);
    }
}

