/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class PageRepository_searchTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/page-tests/";
    }

    @Test
    public void shouldFindApiPageByApiId() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("my-api").referenceType("API").build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)1L, (long)pages.size());
        this.assertFindPage((Page)pages.get(0));
    }

    private void assertFindPage(Page page) {
        Assert.assertEquals((String)"id", (Object)"FindApiPage", (Object)page.getId());
        Assert.assertEquals((String)"name", (Object)"Find apiPage by apiId or Id", (Object)page.getName());
        Assert.assertEquals((String)"content", (Object)"Content of the page", (Object)page.getContent());
        Assert.assertEquals((String)"reference id", (Object)"my-api", (Object)page.getReferenceId());
        Assert.assertEquals((String)"reference type", (Object)PageReferenceType.API, (Object)page.getReferenceType());
        Assert.assertEquals((String)"type", (Object)"MARKDOWN", (Object)page.getType());
        Assert.assertEquals((String)"last contributor", (Object)"john_doe", (Object)page.getLastContributor());
        Assert.assertEquals((String)"order", (long)2L, (long)page.getOrder());
        Assert.assertTrue((String)"published", (boolean)page.isPublished());
        Assert.assertEquals((String)"source type", (Object)"sourceType", (Object)page.getSource().getType());
        Assert.assertEquals((String)"source configuration", (Object)"sourceConfiguration", (Object)page.getSource().getConfiguration());
        Assert.assertEquals((String)"configuration try it", (Object)"true", page.getConfiguration().get("tryIt"));
        Assert.assertEquals((String)"configuration try it URL", (Object)"http://company.com", page.getConfiguration().get("tryItURL"));
        Assert.assertEquals((String)"configuration show URL", (Object)"true", page.getConfiguration().get("showURL"));
        Assert.assertEquals((String)"configuration display operation id", (Object)"true", page.getConfiguration().get("displayOperationId"));
        Assert.assertEquals((String)"configuration doc expansion", (Object)"FULL", page.getConfiguration().get("docExpansion"));
        Assert.assertEquals((String)"configuration enable filtering", (Object)"true", page.getConfiguration().get("enableFiltering"));
        Assert.assertEquals((String)"configuration show extensions", (Object)"true", page.getConfiguration().get("showExtensions"));
        Assert.assertEquals((String)"configuration show common extensions", (Object)"true", page.getConfiguration().get("showCommonExtensions"));
        Assert.assertEquals((String)"configuration maxDisplayedTags", (Object)"1234", page.getConfiguration().get("maxDisplayedTags"));
        Assert.assertTrue((String)"homepage", (boolean)page.isHomepage());
        Assert.assertEquals((String)"excludedGroups", Arrays.asList("grp1", "grp2"), (Object)page.getExcludedGroups());
        Assert.assertTrue((String)"created at", (boolean)DateUtils.compareDate(new Date(1486771200000L), page.getCreatedAt()));
        Assert.assertTrue((String)"updated at", (boolean)DateUtils.compareDate(new Date(1486771200000L), page.getUpdatedAt()));
    }

    @Test
    public void shouldFindApiPageByApiIdAndHomepageFalse() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("my-api-2").referenceType("API").homepage(Boolean.FALSE).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void shouldFindApiPageByApiIdAndHomepageTrue() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("my-api-2").referenceType("API").homepage(Boolean.TRUE).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)1L, (long)pages.size());
        Assert.assertEquals((Object)"home", (Object)((Page)pages.iterator().next()).getId());
    }

    @Test
    public void shouldReturnPageWithAutoFetch() throws Exception {
        List autofetchPages = this.pageRepository.search(new PageCriteria.Builder().withAutoFetch().build());
        Assert.assertNotNull((Object)autofetchPages);
        Assert.assertEquals((String)"Should have One page with autofetch", (long)1L, (long)autofetchPages.size());
        Assert.assertEquals((String)"AutoFetch Page should be FindApiPage", (Object)"FindApiPage", (Object)((Page)autofetchPages.get(0)).getId());
    }

    @Test
    public void shouldFindPortalPages() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("DEFAULT").referenceType("ENVIRONMENT").build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)2L, (long)pages.size());
        Set ids = pages.stream().map(Page::getId).collect(Collectors.toSet());
        Assert.assertTrue((boolean)ids.contains("FindPortalPage-homepage"));
        Assert.assertTrue((boolean)ids.contains("FindPortalPage-nothomepage"));
    }

    @Test
    public void shouldFindPortalPageByHomepageFalse() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("DEFAULT").referenceType("ENVIRONMENT").homepage(Boolean.FALSE).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)1L, (long)pages.size());
        Assert.assertEquals((Object)"FindPortalPage-nothomepage", (Object)((Page)pages.iterator().next()).getId());
    }

    @Test
    public void shouldFindPortalPageByHomepageTrue() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId("DEFAULT").referenceType("ENVIRONMENT").homepage(Boolean.TRUE).build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)1L, (long)pages.size());
        Assert.assertEquals((Object)"FindPortalPage-homepage", (Object)((Page)pages.iterator().next()).getId());
    }

    @Test
    public void shouldFindPortalPageWithoutCriteria() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)11L, (long)pages.size());
    }

    @Test
    public void shouldFindAllWhenCriteriaIsEmpty() throws Exception {
        List pages = this.pageRepository.search(new PageCriteria.Builder().build());
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((long)11L, (long)pages.size());
    }
}

