/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.PageRevision;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class PageRevisionRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/page-revision-tests/";
    }

    @Test
    public void shouldFindApiPageRevisionById() throws Exception {
        Optional pageRevision = this.pageRevisionRepository.findById("FindApiPage", 1);
        Assert.assertNotNull((Object)pageRevision);
        Assert.assertTrue((boolean)pageRevision.isPresent());
        this.assertFindPageRevision((PageRevision)pageRevision.get());
    }

    private void assertFindPageRevision(PageRevision pageRevision) {
        Assert.assertEquals((String)"page id", (Object)"FindApiPage", (Object)pageRevision.getPageId());
        Assert.assertEquals((String)"hash algo", (Object)"hexstring", (Object)pageRevision.getHash());
        Assert.assertEquals((String)"revision", (long)1L, (long)pageRevision.getRevision());
        Assert.assertEquals((String)"name", (Object)"Find apiPage by apiId or Id", (Object)pageRevision.getName());
        Assert.assertEquals((String)"content", (Object)"Content of the page", (Object)pageRevision.getContent());
        Assert.assertTrue((String)"created at", (boolean)DateUtils.compareDate(new Date(1486771200000L), pageRevision.getCreatedAt()));
    }

    @Test
    public void shouldFindAll_MaxInteger() throws TechnicalException {
        Page revisions = this.pageRevisionRepository.findAll(new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build());
        Assert.assertNotNull((Object)revisions);
        Assert.assertNotNull((Object)revisions.getContent());
        Assert.assertEquals((long)revisions.getPageNumber(), (long)0L);
        Assert.assertEquals((long)revisions.getPageElements(), (long)6L);
        Assert.assertEquals((long)revisions.getTotalElements(), (long)6L);
        Assert.assertEquals((long)revisions.getContent().size(), (long)6L);
    }

    @Test
    public void shouldFindAll_PageSize3() throws TechnicalException {
        int pageNumber = 0;
        HashSet accumulator = new HashSet();
        do {
            Page revisions = this.pageRevisionRepository.findAll(new PageableBuilder().pageNumber(pageNumber).pageSize(3).build());
            Assert.assertNotNull((Object)revisions);
            Assert.assertNotNull((Object)revisions.getContent());
            Assert.assertEquals((long)revisions.getPageNumber(), (long)pageNumber);
            Assert.assertEquals((long)revisions.getPageElements(), (long)3L);
            Assert.assertEquals((long)revisions.getTotalElements(), (long)6L);
            Assert.assertEquals((long)revisions.getContent().size(), (long)3L);
            revisions.getContent().stream().forEach(rev -> accumulator.add(rev.getPageId() + "-" + rev.getRevision()));
        } while (++pageNumber < 2);
    }

    @Test
    public void shouldCreateApiPageRevision() throws Exception {
        PageRevision pageRevision = new PageRevision();
        pageRevision.setPageId("new-page");
        pageRevision.setRevision(5);
        pageRevision.setName("Page name");
        pageRevision.setContent("Page content");
        pageRevision.setHash("54646446654");
        pageRevision.setCreatedAt(new Date());
        Optional optionalBefore = this.pageRevisionRepository.findById("new-page", 5);
        this.pageRevisionRepository.create(pageRevision);
        Optional optionalAfter = this.pageRevisionRepository.findById("new-page", 5);
        Assert.assertFalse((String)"Page not found before", (boolean)optionalBefore.isPresent());
        Assert.assertTrue((String)"Page saved not found", (boolean)optionalAfter.isPresent());
        PageRevision pageSaved = (PageRevision)optionalAfter.get();
        Assert.assertEquals((String)"Invalid saved pageRevision name.", (Object)pageRevision.getName(), (Object)pageSaved.getName());
        Assert.assertEquals((String)"Invalid pageRevision content.", (Object)pageRevision.getContent(), (Object)pageSaved.getContent());
        Assert.assertEquals((String)"Invalid pageRevision pageId.", (Object)pageRevision.getPageId(), (Object)pageSaved.getPageId());
        Assert.assertEquals((String)"Invalid pageRevision hash.", (Object)pageRevision.getHash(), (Object)pageSaved.getHash());
        Assert.assertEquals((String)"Invalid pageRevision revision.", (long)pageRevision.getRevision(), (long)pageSaved.getRevision());
    }

    @Test
    public void shouldFindAllByPageId() throws Exception {
        List pageShouldExists = this.pageRevisionRepository.findAllByPageId("findByPageId");
        Assert.assertNotNull((Object)pageShouldExists);
        Assert.assertEquals((long)3L, (long)pageShouldExists.size());
        for (PageRevision rev : pageShouldExists) {
            Assert.assertEquals((Object)"findByPageId", (Object)rev.getPageId());
        }
    }

    @Test
    public void shouldNotFindAllByPageId() throws Exception {
        List pageShouldExists = this.pageRevisionRepository.findAllByPageId("findByPageId_unknown");
        Assert.assertNotNull((Object)pageShouldExists);
        Assert.assertEquals((long)0L, (long)pageShouldExists.size());
    }

    @Test
    public void shouldFindLastByPageId() throws Exception {
        Optional pageShouldExists = this.pageRevisionRepository.findLastByPageId("findByPageId");
        Assert.assertNotNull((Object)pageShouldExists);
        Assert.assertTrue((boolean)pageShouldExists.isPresent());
        Assert.assertEquals((Object)"findByPageId", (Object)((PageRevision)pageShouldExists.get()).getPageId());
        Assert.assertEquals((long)3L, (long)((PageRevision)pageShouldExists.get()).getRevision());
        Assert.assertEquals((Object)"lorem ipsum", (Object)((PageRevision)pageShouldExists.get()).getContent());
        Assert.assertEquals((Object)"revision 3", (Object)((PageRevision)pageShouldExists.get()).getName());
        Assert.assertEquals((Object)"findByPageId", (Object)((PageRevision)pageShouldExists.get()).getPageId());
    }

    @Test
    public void shouldNotFindLastByPageId() throws Exception {
        Optional pageShouldExists = this.pageRevisionRepository.findLastByPageId("findByPageId_unknown");
        Assert.assertNotNull((Object)pageShouldExists);
        Assert.assertFalse((boolean)pageShouldExists.isPresent());
    }
}

