/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.repository.management.model.ParameterReferenceType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class ParameterRepositoryTest
extends AbstractRepositoryTest {
    private static final String REFERENCE_ID = "DEFAULT";
    private static final ParameterReferenceType REFERENCE_TYPE = ParameterReferenceType.ENVIRONMENT;

    @Override
    protected String getTestCasesPath() {
        return "/data/parameter-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        Parameter parameter = new Parameter();
        parameter.setKey("new-parameter");
        parameter.setValue("Parameter value");
        parameter.setReferenceId(REFERENCE_ID);
        parameter.setReferenceType(REFERENCE_TYPE);
        Assert.assertFalse((String)"Parameter already exists", (boolean)this.parameterRepository.findById("new-parameter", REFERENCE_ID, REFERENCE_TYPE).isPresent());
        this.parameterRepository.create(parameter);
        Assert.assertTrue((String)"Parameter not created", (boolean)this.parameterRepository.findById("new-parameter", REFERENCE_ID, REFERENCE_TYPE).isPresent());
        Optional optional = this.parameterRepository.findById("new-parameter", REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertTrue((String)"Parameter saved not found", (boolean)optional.isPresent());
        Parameter parameterSaved = (Parameter)optional.get();
        Assert.assertEquals((String)"Invalid saved parameter value.", (Object)parameter.getValue(), (Object)parameterSaved.getValue());
        Assert.assertEquals((String)"Invalid saved parameter referenceId.", (Object)parameter.getReferenceId(), (Object)parameterSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid saved parameter referenceType.", (Object)parameter.getReferenceType(), (Object)parameterSaved.getReferenceType());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.parameterRepository.findById("portal.top-apis", REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertTrue((String)"Parameter to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved parameter value.", (Object)"api1;api2;api2", (Object)((Parameter)optional.get()).getValue());
        Parameter parameter = (Parameter)optional.get();
        parameter.setValue("New value");
        Assert.assertTrue((String)"Parameter does not exist", (boolean)this.parameterRepository.findById("portal.top-apis", REFERENCE_ID, REFERENCE_TYPE).isPresent());
        this.parameterRepository.update(parameter);
        Optional optionalUpdated = this.parameterRepository.findById("portal.top-apis", REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertTrue((String)"Parameter to update not found", (boolean)optionalUpdated.isPresent());
        Parameter parameterUpdated = (Parameter)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved parameter name.", (Object)"New value", (Object)parameterUpdated.getValue());
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((String)"Parameter to delete does not exist", (boolean)this.parameterRepository.findById("management.oAuth.clientId", REFERENCE_ID, REFERENCE_TYPE).isPresent());
        this.parameterRepository.delete("management.oAuth.clientId", REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertFalse((String)"Parameter not deleted", (boolean)this.parameterRepository.findById("management.oAuth.clientId", REFERENCE_ID, REFERENCE_TYPE).isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownParameter() throws Exception {
        Parameter unknownParameter = new Parameter();
        unknownParameter.setKey("unknown");
        unknownParameter.setReferenceId("unknown");
        unknownParameter.setReferenceType(REFERENCE_TYPE);
        this.parameterRepository.update(unknownParameter);
        Assert.fail((String)"An unknown parameter should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.parameterRepository.update(null);
        Assert.fail((String)"A null parameter should not be updated");
    }

    @Test
    public void shouldFindAll() throws Exception {
        List parameters = this.parameterRepository.findByKeys(Arrays.asList("management.oAuth.clientId", "management.oAuth.clientSecret", "unknown"), REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertNotNull((Object)parameters);
        Assert.assertFalse((boolean)parameters.isEmpty());
        Assert.assertEquals((long)2L, (long)parameters.size());
    }

    @Test
    public void shouldFindAllByReferenceIdAndReferenceType() throws Exception {
        List parameters = this.parameterRepository.findAll(REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertNotNull((Object)parameters);
        Assert.assertFalse((boolean)parameters.isEmpty());
        Assert.assertEquals((long)3L, (long)parameters.size());
    }
}

