/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class PlanRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/plan-tests/";
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional plan = this.planRepository.findById((Object)"my-plan");
        Assert.assertNotNull((Object)plan);
        Assert.assertTrue((boolean)plan.isPresent());
        Assert.assertEquals((Object)"my-plan", (Object)((Plan)plan.get()).getId());
        Assert.assertEquals((Object)"GCU-my-plan", (Object)((Plan)plan.get()).getGeneralConditions());
        Assert.assertEquals((Object)"Free plan", (Object)((Plan)plan.get()).getName());
        Assert.assertEquals((Object)"Description of the free plan", (Object)((Plan)plan.get()).getDescription());
        Assert.assertEquals((Object)"api1", (Object)((Plan)plan.get()).getApi());
        Assert.assertEquals((Object)Plan.PlanSecurityType.API_KEY, (Object)((Plan)plan.get()).getSecurity());
        Assert.assertEquals((Object)Plan.PlanValidationType.AUTO, (Object)((Plan)plan.get()).getValidation());
        Assert.assertEquals((Object)Plan.PlanType.API, (Object)((Plan)plan.get()).getType());
        Assert.assertEquals((Object)Plan.Status.PUBLISHED, (Object)((Plan)plan.get()).getStatus());
        Assert.assertEquals((long)2L, (long)((Plan)plan.get()).getOrder());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1506964899000L), ((Plan)plan.get()).getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1507032062000L), ((Plan)plan.get()).getUpdatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1506878460000L), ((Plan)plan.get()).getPublishedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1507611600000L), ((Plan)plan.get()).getClosedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1507611670000L), ((Plan)plan.get()).getNeedRedeployAt()));
        Assert.assertEquals(Arrays.asList("charac 1", "charac 2"), (Object)((Plan)plan.get()).getCharacteristics());
        Assert.assertEquals((Object)"grp1", ((Plan)plan.get()).getExcludedGroups().get(0));
        Assert.assertEquals((Object)"tag1", ((Plan)plan.get()).getTags().iterator().next());
        Assert.assertTrue((boolean)((Plan)plan.get()).isCommentRequired());
        Assert.assertEquals((Object)"What is your project code?", (Object)((Plan)plan.get()).getCommentMessage());
        Assert.assertNull((Object)((Plan)plan.get()).getSelectionRule());
    }

    @Test
    public void shouldFindOAuth2PlanById() throws TechnicalException {
        Optional planOAuth2 = this.planRepository.findById((Object)"plan-oauth2");
        Assert.assertNotNull((Object)planOAuth2);
        Assert.assertTrue((boolean)planOAuth2.isPresent());
        Assert.assertEquals((Object)"plan-oauth2", (Object)((Plan)planOAuth2.get()).getId());
        Assert.assertEquals((Object)"oauth2", (Object)((Plan)planOAuth2.get()).getName());
        Assert.assertEquals((Object)"Description of oauth2", (Object)((Plan)planOAuth2.get()).getDescription());
        Assert.assertEquals((Object)"4e0db366-f772-4489-8db3-66f772b48989", (Object)((Plan)planOAuth2.get()).getApi());
        Assert.assertEquals((Object)Plan.PlanSecurityType.OAUTH2, (Object)((Plan)planOAuth2.get()).getSecurity());
        Assert.assertEquals((Object)Plan.PlanValidationType.MANUAL, (Object)((Plan)planOAuth2.get()).getValidation());
        Assert.assertEquals((Object)Plan.PlanType.API, (Object)((Plan)planOAuth2.get()).getType());
        Assert.assertEquals((Object)Plan.Status.STAGING, (Object)((Plan)planOAuth2.get()).getStatus());
        Assert.assertEquals((long)0L, (long)((Plan)planOAuth2.get()).getOrder());
        Assert.assertTrue((boolean)DateUtils.compareDate("11/02/2016", ((Plan)planOAuth2.get()).getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate("12/02/2016", ((Plan)planOAuth2.get()).getUpdatedAt()));
        Assert.assertNull((Object)((Plan)planOAuth2.get()).getPublishedAt());
        Assert.assertNull((Object)((Plan)planOAuth2.get()).getClosedAt());
        Assert.assertEquals(Collections.emptyList(), (Object)((Plan)planOAuth2.get()).getCharacteristics());
        Assert.assertEquals((Object)"7c546c6b-2f2f-4487-946c-6b2f2f648784", ((Plan)planOAuth2.get()).getExcludedGroups().get(0));
        Assert.assertEquals((Object)"{\"extractPayload\":false,\"checkRequiredScopes\":false,\"requiredScopes\":[],\"oauthResource\":\"OAuth\"}", (Object)((Plan)planOAuth2.get()).getSecurityDefinition());
        Assert.assertEquals((Object)"{  \"/\" : [ {    \"methods\" : [ \"GET\", \"POST\", \"PUT\", \"DELETE\", \"HEAD\", \"PATCH\", \"OPTIONS\", \"TRACE\", \"CONNECT\" ],    \"resource-filtering\" : {\"whitelist\":[{\"pattern\":\"/**\",\"methods\":[\"GET\"]}]},    \"enabled\" : true  } ]}", (Object)((Plan)planOAuth2.get()).getDefinition());
        Assert.assertEquals((Object)"#context.attributes['jwt'].claims['iss'] == 'toto'", (Object)((Plan)planOAuth2.get()).getSelectionRule());
    }

    @Test
    public void shouldNotFindById() throws TechnicalException {
        Optional unknown = this.planRepository.findById((Object)"unknown");
        Assert.assertNotNull((Object)unknown);
        Assert.assertFalse((boolean)unknown.isPresent());
    }

    @Test
    public void shouldFindByApi() throws Exception {
        Set plans = this.planRepository.findByApi("api1");
        Assert.assertNotNull((Object)plans);
        Assert.assertEquals((long)2L, (long)plans.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        String planName = "new-plan";
        Plan plan = new Plan();
        plan.setId(planName);
        plan.setName("Plan name");
        plan.setDescription("Description for the new plan");
        plan.setValidation(Plan.PlanValidationType.AUTO);
        plan.setType(Plan.PlanType.API);
        plan.setStatus(Plan.Status.STAGING);
        plan.setApi("my-api");
        plan.setGeneralConditions("general_conditions");
        plan.setCreatedAt(DateUtils.parse("11/02/2016"));
        plan.setUpdatedAt(DateUtils.parse("12/02/2016"));
        plan.setPublishedAt(DateUtils.parse("13/02/2016"));
        plan.setClosedAt(DateUtils.parse("14/02/2016"));
        plan.setSecurity(Plan.PlanSecurityType.KEY_LESS);
        this.planRepository.create((Object)plan);
        Optional optional = this.planRepository.findById((Object)planName);
        Assert.assertTrue((String)"New plan not found", (boolean)optional.isPresent());
        Plan createdPlan = (Plan)optional.get();
        Assert.assertEquals((String)"Invalid plan name.", (Object)plan.getName(), (Object)createdPlan.getName());
        Assert.assertEquals((String)"Invalid GeneralCondition.", (Object)plan.getGeneralConditions(), (Object)createdPlan.getGeneralConditions());
        Assert.assertEquals((String)"Invalid plan description.", (Object)plan.getDescription(), (Object)createdPlan.getDescription());
        Assert.assertEquals((String)"Invalid plan validation.", (Object)plan.getValidation(), (Object)createdPlan.getValidation());
        Assert.assertEquals((String)"Invalid plan type.", (Object)plan.getType(), (Object)createdPlan.getType());
        Assert.assertEquals((String)"Invalid plan API.", (Object)plan.getApi(), (Object)createdPlan.getApi());
        Assert.assertTrue((String)"Invalid plan created date.", (boolean)DateUtils.compareDate(plan.getCreatedAt(), createdPlan.getCreatedAt()));
        Assert.assertTrue((String)"Invalid plan updated date.", (boolean)DateUtils.compareDate(plan.getUpdatedAt(), createdPlan.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid plan status.", (Object)plan.getStatus(), (Object)createdPlan.getStatus());
        Assert.assertTrue((String)"Invalid plan published date.", (boolean)DateUtils.compareDate(plan.getPublishedAt(), createdPlan.getPublishedAt()));
        Assert.assertTrue((String)"Invalid plan closed date.", (boolean)DateUtils.compareDate(plan.getClosedAt(), createdPlan.getClosedAt()));
        Assert.assertEquals((String)"Invalid plan security.", (Object)plan.getSecurity(), (Object)createdPlan.getSecurity());
    }

    @Test
    public void shouldCreateOAuth2Plan() throws Exception {
        String planName = "new-oauth2-plan";
        Plan plan = new Plan();
        plan.setId(planName);
        plan.setName("Plan oauth2 name");
        plan.setDescription("Description for the new oauth2 plan");
        plan.setValidation(Plan.PlanValidationType.AUTO);
        plan.setType(Plan.PlanType.API);
        plan.setStatus(Plan.Status.STAGING);
        plan.setApi("my-api");
        plan.setCreatedAt(DateUtils.parse("11/02/2016"));
        plan.setUpdatedAt(DateUtils.parse("12/02/2016"));
        plan.setPublishedAt(DateUtils.parse("13/02/2016"));
        plan.setClosedAt(DateUtils.parse("14/02/2016"));
        plan.setSecurity(Plan.PlanSecurityType.OAUTH2);
        plan.setSecurityDefinition("{\"extractPayload\":false,\"checkRequiredScopes\":false,\"requiredScopes\":[],\"oauthResource\":\"OAuth\"}");
        plan.setCommentRequired(true);
        this.planRepository.create((Object)plan);
        Optional optional = this.planRepository.findById((Object)planName);
        Assert.assertTrue((String)"New oauth2 plan not found", (optional != null && optional.isPresent() ? 1 : 0) != 0);
        Plan createdPlan = (Plan)optional.get();
        Assert.assertEquals((String)"Invalid oauth2 plan name.", (Object)plan.getName(), (Object)createdPlan.getName());
        Assert.assertEquals((String)"Invalid oauth2 plan description.", (Object)plan.getDescription(), (Object)createdPlan.getDescription());
        Assert.assertEquals((String)"Invalid oauth2 plan validation.", (Object)plan.getValidation(), (Object)createdPlan.getValidation());
        Assert.assertEquals((String)"Invalid oauth2 plan type.", (Object)plan.getType(), (Object)createdPlan.getType());
        Assert.assertEquals((String)"Invalid oauth2 plan API.", (Object)plan.getApi(), (Object)createdPlan.getApi());
        Assert.assertTrue((String)"Invalid oauth2 plan created date.", (boolean)DateUtils.compareDate(plan.getCreatedAt(), createdPlan.getCreatedAt()));
        Assert.assertTrue((String)"Invalid oauth2 plan updated date.", (boolean)DateUtils.compareDate(plan.getUpdatedAt(), createdPlan.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid oauth2 plan status.", (Object)plan.getStatus(), (Object)createdPlan.getStatus());
        Assert.assertTrue((String)"Invalid oauth2 plan published date.", (boolean)DateUtils.compareDate(plan.getPublishedAt(), createdPlan.getPublishedAt()));
        Assert.assertTrue((String)"Invalid oauth2 plan closed date.", (boolean)DateUtils.compareDate(plan.getClosedAt(), createdPlan.getClosedAt()));
        Assert.assertEquals((String)"Invalid oauth2 plan security.", (Object)plan.getSecurity(), (Object)createdPlan.getSecurity());
        Assert.assertEquals((String)"Invalid oauth2 plan security definition.", (Object)plan.getSecurityDefinition(), (Object)createdPlan.getSecurityDefinition());
        Assert.assertEquals((String)"Invalid oauth2 plan comment required.", (Object)plan.isCommentRequired(), (Object)createdPlan.isCommentRequired());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.planRepository.findById((Object)"updated-plan");
        Assert.assertTrue((String)"Plan to update not found", (optional != null && optional.isPresent() ? 1 : 0) != 0);
        Plan plan = (Plan)optional.get();
        plan.setName("New plan");
        plan.setDescription("New description");
        plan.setGeneralConditions("New GCU");
        plan.setStatus(Plan.Status.CLOSED);
        plan.setTags(Collections.singleton("tag1"));
        this.planRepository.update((Object)plan);
        Optional optionalUpdated = this.planRepository.findById((Object)"updated-plan");
        Assert.assertTrue((String)"Plan to update not found", (optionalUpdated != null && optionalUpdated.isPresent() ? 1 : 0) != 0);
        Plan planUpdated = (Plan)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved plan name.", (Object)plan.getName(), (Object)planUpdated.getName());
        Assert.assertEquals((String)"Invalid saved general conditions.", (Object)plan.getGeneralConditions(), (Object)planUpdated.getGeneralConditions());
        Assert.assertEquals((String)"Invalid plan description.", (Object)plan.getDescription(), (Object)planUpdated.getDescription());
        Assert.assertEquals((String)"Invalid plan status.", (Object)plan.getStatus(), (Object)planUpdated.getStatus());
        Assert.assertEquals((String)"Invalid plan tags.", (long)plan.getTags().size(), (long)planUpdated.getTags().size());
    }

    @Test
    public void shouldUpdateOAuth2Plan() throws Exception {
        Optional optional = this.planRepository.findById((Object)"plan-oauth2");
        Assert.assertTrue((String)"Plan to update not found", (optional != null && optional.isPresent() ? 1 : 0) != 0);
        Plan plan = (Plan)optional.get();
        plan.setName("New oauth2 plan");
        plan.setDescription("New oauth2 description");
        plan.setStatus(Plan.Status.CLOSED);
        plan.setSecurityDefinition("{}");
        this.planRepository.update((Object)plan);
        Optional optionalUpdated = this.planRepository.findById((Object)"plan-oauth2");
        Assert.assertTrue((String)"Plan to update not found", (optionalUpdated != null && optionalUpdated.isPresent() ? 1 : 0) != 0);
        Plan planUpdated = (Plan)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved plan name.", (Object)plan.getName(), (Object)planUpdated.getName());
        Assert.assertEquals((String)"Invalid plan description.", (Object)plan.getDescription(), (Object)planUpdated.getDescription());
        Assert.assertEquals((String)"Invalid plan status.", (Object)plan.getStatus(), (Object)planUpdated.getStatus());
        Assert.assertEquals((String)"Invalid plan security definition.", (Object)plan.getSecurityDefinition(), (Object)planUpdated.getSecurityDefinition());
    }

    @Test
    public void shouldDelete() throws Exception {
        this.planRepository.delete((Object)"stores");
        Optional optional = this.planRepository.findById((Object)"stores");
        Assert.assertFalse((String)"Plan must not be found", (boolean)optional.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownPlan() throws Exception {
        Plan unknownPlan = new Plan();
        unknownPlan.setId("unknown");
        this.planRepository.update((Object)unknownPlan);
        Assert.fail((String)"An unknown plan should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.planRepository.update(null);
        Assert.fail((String)"A null plan should not be updated");
    }
}

