/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class PortalNotificationConfigRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/portalnotificationConfig-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        PortalNotificationConfig cfg = new PortalNotificationConfig();
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-created");
        cfg.setUser("userid");
        cfg.setHooks(Arrays.asList("A", "B", "C"));
        cfg.setUpdatedAt(new Date(1439022010883L));
        cfg.setCreatedAt(new Date(1439022010883L));
        PortalNotificationConfig notificationCreated = this.portalNotificationConfigRepository.create(cfg);
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationCreated.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationCreated.getReferenceId());
        Assert.assertEquals((Object)cfg.getUser(), (Object)notificationCreated.getUser());
        Assert.assertEquals((Object)cfg.getHooks(), (Object)notificationCreated.getHooks());
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationCreated.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationCreated.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((boolean)this.portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-delete").isPresent());
        PortalNotificationConfig cfg = new PortalNotificationConfig();
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-to-delete");
        cfg.setUser("userid");
        this.portalNotificationConfigRepository.delete(cfg);
        Assert.assertFalse((boolean)this.portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-delete").isPresent());
    }

    @Test
    public void shouldUpdate() throws Exception {
        PortalNotificationConfig cfg = new PortalNotificationConfig();
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-to-update");
        cfg.setUser("userid");
        cfg.setHooks(Arrays.asList("D", "B", "C"));
        cfg.setUpdatedAt(new Date(1479022010883L));
        cfg.setCreatedAt(new Date(1469022010883L));
        PortalNotificationConfig notificationUpdated = this.portalNotificationConfigRepository.update(cfg);
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationUpdated.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationUpdated.getReferenceId());
        Assert.assertEquals((Object)cfg.getUser(), (Object)notificationUpdated.getUser());
        Assert.assertTrue((boolean)cfg.getHooks().containsAll(notificationUpdated.getHooks()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationUpdated.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationUpdated.getUpdatedAt()));
    }

    @Test
    public void shouldFindById() throws Exception {
        PortalNotificationConfig cfg = new PortalNotificationConfig();
        cfg.setReferenceType(NotificationReferenceType.API);
        cfg.setReferenceId("config-to-find");
        cfg.setUser("userid");
        cfg.setHooks(Arrays.asList("A", "B"));
        cfg.setUpdatedAt(new Date(1439022010883L));
        cfg.setCreatedAt(new Date(1439022010883L));
        Optional optNotificationFound = this.portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-find");
        Assert.assertTrue((boolean)optNotificationFound.isPresent());
        PortalNotificationConfig notificationFound = (PortalNotificationConfig)optNotificationFound.get();
        Assert.assertEquals((Object)cfg.getReferenceType(), (Object)notificationFound.getReferenceType());
        Assert.assertEquals((Object)cfg.getReferenceId(), (Object)notificationFound.getReferenceId());
        Assert.assertEquals((Object)cfg.getUser(), (Object)notificationFound.getUser());
        Assert.assertEquals((Object)cfg.getHooks(), (Object)notificationFound.getHooks());
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getCreatedAt(), notificationFound.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(cfg.getUpdatedAt(), notificationFound.getUpdatedAt()));
    }

    @Test
    public void shouldNotFoundById() throws Exception {
        Optional optNotificationFound = this.portalNotificationConfigRepository.findById("userid-unknown", NotificationReferenceType.API, "config-to-find");
        Assert.assertFalse((boolean)optNotificationFound.isPresent());
        optNotificationFound = this.portalNotificationConfigRepository.findById("userid", NotificationReferenceType.APPLICATION, "config-to-find");
        Assert.assertFalse((boolean)optNotificationFound.isPresent());
        optNotificationFound = this.portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-not-find");
        Assert.assertFalse((boolean)optNotificationFound.isPresent());
    }

    @Test
    public void shouldFindByHookAndReference() throws Exception {
        List configs = this.portalNotificationConfigRepository.findByReferenceAndHook("B", NotificationReferenceType.APPLICATION, "search");
        Assert.assertEquals((String)"size", (long)2L, (long)configs.size());
        List userIds = configs.stream().map(PortalNotificationConfig::getUser).collect(Collectors.toList());
        Assert.assertTrue((String)"userA", (boolean)userIds.contains("userA"));
        Assert.assertTrue((String)"userB", (boolean)userIds.contains("userB"));
    }

    @Test
    public void shouldNotFindByHookAndReference() throws Exception {
        List configs = this.portalNotificationConfigRepository.findByReferenceAndHook("D", NotificationReferenceType.APPLICATION, "search");
        Assert.assertTrue((String)"size", (boolean)configs.isEmpty());
    }

    @Test
    public void shouldDeleteByUser() throws Exception {
        this.portalNotificationConfigRepository.deleteByUser("useridToDelete");
        Assert.assertFalse((boolean)this.portalNotificationConfigRepository.findById("useridToDelete", NotificationReferenceType.API, "config").isPresent());
    }

    @Test
    public void shouldDeleteReference() throws Exception {
        Assert.assertTrue((String)"should exists before delete {apiToDelete-1}", (boolean)this.portalNotificationConfigRepository.findById("apiToDelete-1", NotificationReferenceType.API, "apiToDelete").isPresent());
        Assert.assertTrue((String)"should exists before delete {apiToDelete-2}", (boolean)this.portalNotificationConfigRepository.findById("apiToDelete-2", NotificationReferenceType.API, "apiToDelete").isPresent());
        this.portalNotificationConfigRepository.deleteReference(NotificationReferenceType.API, "apiToDelete");
        Assert.assertFalse((String)"should be deleted {apiToDelete-1}", (boolean)this.portalNotificationConfigRepository.findById("apiToDelete-1", NotificationReferenceType.API, "apiToDelete").isPresent());
        Assert.assertFalse((String)"should be deleted {apiToDelete-2}", (boolean)this.portalNotificationConfigRepository.findById("apiToDelete-2", NotificationReferenceType.API, "apiToDelete").isPresent());
    }
}

