/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.PortalNotification;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class PortalNotificationRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/portalnotification-tests/";
    }

    @Test
    public void shouldCreate() throws Exception {
        PortalNotification notification = new PortalNotification();
        notification.setId("notif-create");
        notification.setTitle("notif-title");
        notification.setMessage("notif-message");
        notification.setUser("notif-userId");
        notification.setCreatedAt(new Date(1439022010883L));
        PortalNotification notificationCreated = (PortalNotification)this.portalNotificationRepository.create((Object)notification);
        Assert.assertEquals((Object)notification.getId(), (Object)notificationCreated.getId());
        Assert.assertEquals((Object)notification.getTitle(), (Object)notificationCreated.getTitle());
        Assert.assertEquals((Object)notification.getMessage(), (Object)notificationCreated.getMessage());
        Assert.assertEquals((Object)notification.getUser(), (Object)notificationCreated.getUser());
        Assert.assertTrue((boolean)DateUtils.compareDate(notification.getCreatedAt(), notificationCreated.getCreatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertEquals((long)1L, (long)this.portalNotificationRepository.findByUser("notif-userId-toDelete").size());
        this.portalNotificationRepository.delete((Object)"notif-toDelete");
        Assert.assertTrue((boolean)this.portalNotificationRepository.findByUser("notif-userId-toDelete").isEmpty());
    }

    @Test
    public void shouldDeleteAllUser() throws Exception {
        Assert.assertEquals((long)1L, (long)this.portalNotificationRepository.findByUser("notif-userId-toDelete").size());
        this.portalNotificationRepository.deleteAll("notif-userId-toDelete");
        Assert.assertTrue((boolean)this.portalNotificationRepository.findByUser("notif-userId-toDelete").isEmpty());
    }

    @Test
    public void shouldFindByUserId() throws Exception {
        List notifications = this.portalNotificationRepository.findByUser("notif-userId-findByUserId");
        Assert.assertEquals((long)1L, (long)notifications.size());
        PortalNotification notification = (PortalNotification)notifications.get(0);
        Assert.assertEquals((Object)"notif-findByUserId", (Object)notification.getId());
        Assert.assertEquals((Object)"notif-title-findByUserId", (Object)notification.getTitle());
        Assert.assertEquals((Object)"notif-message-findByUserId", (Object)notification.getMessage());
        Assert.assertEquals((Object)"notif-userId-findByUserId", (Object)notification.getUser());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1439022010883L), notification.getCreatedAt()));
    }

    @Test
    public void shouldNotFindByUsername() throws Exception {
        List notifications = this.portalNotificationRepository.findByUser("unknown");
        Assert.assertTrue((boolean)notifications.isEmpty());
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional notification = this.portalNotificationRepository.findById("notif-findById");
        Assert.assertTrue((boolean)notification.isPresent());
        PortalNotification portalNotification = (PortalNotification)notification.get();
        Assert.assertEquals((Object)"notif-findById", (Object)portalNotification.getId());
        Assert.assertEquals((Object)"notif-title-findById", (Object)portalNotification.getTitle());
        Assert.assertEquals((Object)"notif-message-findById", (Object)portalNotification.getMessage());
        Assert.assertEquals((Object)"notif-userId-findById", (Object)portalNotification.getUser());
        Assert.assertTrue((boolean)DateUtils.compareDate(new Date(1439022010883L), portalNotification.getCreatedAt()));
    }
}

