/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.QualityRule;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class QualityRuleRepositoryTest
extends AbstractRepositoryTest {
    public static final Date DATE = new Date(1439022010883L);

    @Override
    protected String getTestCasesPath() {
        return "/data/qualityrule-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set qualityRules = this.qualityRuleRepository.findAll();
        Assert.assertNotNull((Object)qualityRules);
        Assert.assertEquals((long)3L, (long)qualityRules.size());
        QualityRule qualityRuleProduct = qualityRules.stream().filter(qualityRule -> "quality-rule3".equals(qualityRule.getId())).findAny().get();
        Assert.assertEquals((Object)"Api-key plan", (Object)qualityRuleProduct.getName());
        Assert.assertEquals((Object)"A plan api-key is published", (Object)qualityRuleProduct.getDescription());
        Assert.assertEquals((long)3L, (long)qualityRuleProduct.getWeight());
        Assert.assertTrue((boolean)DateUtils.compareDate(DATE, qualityRuleProduct.getCreatedAt()));
        Assert.assertTrue((boolean)DateUtils.compareDate(DATE, qualityRuleProduct.getUpdatedAt()));
    }

    @Test
    public void shouldCreate() throws Exception {
        QualityRule qualityRule = new QualityRule();
        qualityRule.setId("new-qualityRule");
        qualityRule.setName("QualityRule name");
        qualityRule.setDescription("QualityRule description");
        qualityRule.setWeight(10);
        qualityRule.setCreatedAt(DATE);
        qualityRule.setUpdatedAt(DATE);
        int nbQualityRulesBeforeCreation = this.qualityRuleRepository.findAll().size();
        this.qualityRuleRepository.create((Object)qualityRule);
        int nbQualityRulesAfterCreation = this.qualityRuleRepository.findAll().size();
        Assert.assertEquals((long)(nbQualityRulesBeforeCreation + 1), (long)nbQualityRulesAfterCreation);
        Optional optional = this.qualityRuleRepository.findById((Object)"new-qualityRule");
        Assert.assertTrue((String)"QualityRule saved not found", (boolean)optional.isPresent());
        QualityRule qualityRuleSaved = (QualityRule)optional.get();
        Assert.assertEquals((String)"Invalid saved qualityRule name.", (Object)qualityRule.getName(), (Object)qualityRuleSaved.getName());
        Assert.assertEquals((String)"Invalid saved qualityRule description.", (Object)qualityRule.getDescription(), (Object)qualityRuleSaved.getDescription());
        Assert.assertEquals((String)"Invalid weight.", (long)qualityRule.getWeight(), (long)qualityRuleSaved.getWeight());
        Assert.assertTrue((String)"Invalid createdAt.", (boolean)DateUtils.compareDate(qualityRule.getCreatedAt(), qualityRuleSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid updatedAt.", (boolean)DateUtils.compareDate(qualityRule.getUpdatedAt(), qualityRuleSaved.getUpdatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.qualityRuleRepository.findById((Object)"quality-rule1");
        Assert.assertTrue((String)"QualityRule to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved qualityRule name.", (Object)"Description in english", (Object)((QualityRule)optional.get()).getName());
        Assert.assertEquals((String)"Invalid saved qualityRule name.", (Object)"Description must be in english", (Object)((QualityRule)optional.get()).getDescription());
        QualityRule qualityRule = (QualityRule)optional.get();
        qualityRule.setName("New name");
        qualityRule.setDescription("New description");
        qualityRule.setWeight(5);
        qualityRule.setCreatedAt(DATE);
        qualityRule.setUpdatedAt(DATE);
        int nbQualityRulesBeforeUpdate = this.qualityRuleRepository.findAll().size();
        this.qualityRuleRepository.update((Object)qualityRule);
        int nbQualityRulesAfterUpdate = this.qualityRuleRepository.findAll().size();
        Assert.assertEquals((long)nbQualityRulesBeforeUpdate, (long)nbQualityRulesAfterUpdate);
        Optional optionalUpdated = this.qualityRuleRepository.findById((Object)"quality-rule1");
        Assert.assertTrue((String)"QualityRule to update not found", (boolean)optionalUpdated.isPresent());
        QualityRule qualityRuleUpdated = (QualityRule)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved qualityRule name.", (Object)"New name", (Object)qualityRuleUpdated.getName());
        Assert.assertEquals((String)"Invalid saved qualityRule description.", (Object)"New description", (Object)qualityRuleUpdated.getDescription());
        Assert.assertEquals((String)"Invalid weight.", (long)5L, (long)qualityRuleUpdated.getWeight());
        Assert.assertTrue((String)"Invalid createdAt.", (boolean)DateUtils.compareDate(DATE, qualityRuleUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid updatedAt.", (boolean)DateUtils.compareDate(DATE, qualityRuleUpdated.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbQualityRulesBeforeDeletion = this.qualityRuleRepository.findAll().size();
        this.qualityRuleRepository.delete((Object)"quality-rule2");
        int nbQualityRulesAfterDeletion = this.qualityRuleRepository.findAll().size();
        Assert.assertEquals((long)(nbQualityRulesBeforeDeletion - 1), (long)nbQualityRulesAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownQualityRule() throws Exception {
        QualityRule unknownQualityRule = new QualityRule();
        unknownQualityRule.setId("unknown");
        this.qualityRuleRepository.update((Object)unknownQualityRule);
        Assert.fail((String)"An unknown qualityRule should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.qualityRuleRepository.update(null);
        Assert.fail((String)"A null qualityRule should not be updated");
    }
}

