/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Rating;
import io.gravitee.repository.management.model.RatingAnswer;
import io.gravitee.repository.management.model.RatingReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RatingRepositoryTest
extends AbstractRepositoryTest {
    private final Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));

    @Override
    protected String getTestCasesPath() {
        return "/data/rating-tests/";
    }

    @Before
    public void init() {
        this.cal.set(1, 2017);
        this.cal.set(2, 1);
        this.cal.set(5, 11);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional ratingOptional = this.ratingRepository.findById("rating-id");
        Assert.assertTrue((boolean)ratingOptional.isPresent());
        Rating rating = (Rating)ratingOptional.get();
        Assert.assertEquals((Object)"api", (Object)rating.getReferenceId());
        Assert.assertEquals((Object)RatingReferenceType.API, (Object)rating.getReferenceType());
        Assert.assertEquals((Object)"user", (Object)rating.getUser());
        Assert.assertEquals((Object)"title", (Object)rating.getTitle());
        Assert.assertEquals((Object)"My comment", (Object)rating.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(this.cal.getTime(), rating.getCreatedAt()));
        Assert.assertEquals((long)1L, (long)rating.getRate());
        List ratingAnswers = this.ratingAnswerRepository.findByRating(rating.getId());
        RatingAnswer ratingAnswer = (RatingAnswer)ratingAnswers.get(0);
        Assert.assertEquals((Object)"user", (Object)ratingAnswer.getUser());
        Assert.assertEquals((Object)"Answer", (Object)ratingAnswer.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(this.cal.getTime(), ratingAnswer.getCreatedAt()));
    }

    @Test
    public void shouldFindByApiAndUser() throws Exception {
        Optional ratingOptional = this.ratingRepository.findByReferenceIdAndReferenceTypeAndUser("api", RatingReferenceType.API, "user");
        Assert.assertTrue((boolean)ratingOptional.isPresent());
        Rating rating = (Rating)ratingOptional.get();
        Assert.assertEquals((Object)"api", (Object)rating.getReferenceId());
        Assert.assertEquals((Object)RatingReferenceType.API, (Object)rating.getReferenceType());
        Assert.assertEquals((Object)"user", (Object)rating.getUser());
        Assert.assertEquals((Object)"title", (Object)rating.getTitle());
        Assert.assertEquals((Object)"My comment", (Object)rating.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(this.cal.getTime(), rating.getCreatedAt()));
        Assert.assertEquals((long)1L, (long)rating.getRate());
        List ratingAnswers = this.ratingAnswerRepository.findByRating(rating.getId());
        RatingAnswer ratingAnswer = (RatingAnswer)ratingAnswers.get(0);
        Assert.assertEquals((Object)"user", (Object)ratingAnswer.getUser());
        Assert.assertEquals((Object)"Answer", (Object)ratingAnswer.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(this.cal.getTime(), ratingAnswer.getCreatedAt()));
    }

    @Test
    public void shouldFindByApiPageable() throws Exception {
        Page ratingPage = this.ratingRepository.findByReferenceIdAndReferenceTypePageable("api", RatingReferenceType.API, new PageableBuilder().pageNumber(0).pageSize(2).build());
        Assert.assertEquals((long)0L, (long)ratingPage.getPageNumber());
        Assert.assertEquals((long)2L, (long)ratingPage.getPageElements());
        Assert.assertEquals((long)3L, (long)ratingPage.getTotalElements());
        Assert.assertEquals((long)2L, (long)ratingPage.getContent().size());
        Assert.assertEquals((Object)"rating4-id", (Object)((Rating)ratingPage.getContent().get(0)).getId());
        Assert.assertEquals((Object)"rating-id", (Object)((Rating)ratingPage.getContent().get(1)).getId());
        ratingPage = this.ratingRepository.findByReferenceIdAndReferenceTypePageable("api", RatingReferenceType.API, new PageableBuilder().pageNumber(1).pageSize(2).build());
        Assert.assertEquals((long)1L, (long)ratingPage.getPageNumber());
        Assert.assertEquals((long)1L, (long)ratingPage.getPageElements());
        Assert.assertEquals((long)3L, (long)ratingPage.getTotalElements());
        Assert.assertEquals((long)1L, (long)ratingPage.getContent().size());
        Assert.assertEquals((Object)"rating2-id", (Object)((Rating)ratingPage.getContent().get(0)).getId());
    }

    @Test
    public void shouldFindByReferenceIdAndReferenceType() throws Exception {
        List ratings = this.ratingRepository.findByReferenceIdAndReferenceType("api", RatingReferenceType.API);
        Assert.assertEquals((long)3L, (long)ratings.size());
        Assert.assertEquals((long)1L, (long)ratings.stream().filter(rating -> "rating-id".equals(rating.getId())).count());
        Assert.assertEquals((long)1L, (long)ratings.stream().filter(rating -> "rating2-id".equals(rating.getId())).count());
        Assert.assertEquals((long)1L, (long)ratings.stream().filter(rating -> "rating4-id".equals(rating.getId())).count());
    }

    @Test
    public void shouldCreate() throws Exception {
        Rating rating = new Rating();
        rating.setId("new-rating");
        rating.setReferenceId("api");
        rating.setReferenceType(RatingReferenceType.API);
        rating.setUser("user");
        rating.setTitle("title");
        rating.setComment("comment");
        rating.setRate(new Byte("5").byteValue());
        rating.setCreatedAt(this.cal.getTime());
        rating.setUpdatedAt(this.cal.getTime());
        RatingAnswer ratingAnswer = new RatingAnswer();
        ratingAnswer.setId("new-answer-id");
        ratingAnswer.setRating(rating.getId());
        ratingAnswer.setUser("user");
        ratingAnswer.setComment("My answer");
        ratingAnswer.setCreatedAt(this.cal.getTime());
        this.ratingAnswerRepository.create(ratingAnswer);
        Assert.assertFalse((boolean)this.ratingRepository.findById("new-rating").isPresent());
        this.ratingRepository.create(rating);
        Optional optional = this.ratingRepository.findById("new-rating");
        Assert.assertTrue((String)"Rating saved not found", (boolean)optional.isPresent());
        Rating ratingSaved = (Rating)optional.get();
        Assert.assertEquals((String)"Invalid rating api.", (Object)rating.getReferenceId(), (Object)ratingSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid rating api.", (Object)rating.getReferenceType(), (Object)ratingSaved.getReferenceType());
        Assert.assertEquals((String)"Invalid rating user.", (Object)rating.getUser(), (Object)ratingSaved.getUser());
        Assert.assertEquals((String)"Invalid rating title.", (Object)rating.getTitle(), (Object)ratingSaved.getTitle());
        Assert.assertEquals((String)"Invalid rating comment.", (Object)rating.getComment(), (Object)ratingSaved.getComment());
        Assert.assertEquals((String)"Invalid rating rate.", (long)rating.getRate(), (long)ratingSaved.getRate());
        Assert.assertTrue((String)"Invalid rating created date.", (boolean)DateUtils.compareDate(rating.getCreatedAt(), ratingSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid rating updated date.", (boolean)DateUtils.compareDate(rating.getUpdatedAt(), ratingSaved.getUpdatedAt()));
        Assert.assertEquals((String)"Invalid rating answers.", Collections.singletonList(ratingAnswer), (Object)this.ratingAnswerRepository.findByRating(rating.getId()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Rating rating = new Rating();
        rating.setId("rating-id");
        rating.setReferenceId("api");
        rating.setReferenceType(RatingReferenceType.API);
        rating.setUser("user10");
        rating.setTitle("title10");
        rating.setComment("comment10");
        rating.setRate(new Byte("3").byteValue());
        rating.setCreatedAt(this.cal.getTime());
        rating.setUpdatedAt(this.cal.getTime());
        Rating ratingSaved = this.ratingRepository.update(rating);
        Assert.assertEquals((String)"Invalid rating api.", (Object)rating.getReferenceId(), (Object)ratingSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid rating api.", (Object)rating.getReferenceType(), (Object)ratingSaved.getReferenceType());
        Assert.assertEquals((String)"Invalid rating user.", (Object)rating.getUser(), (Object)ratingSaved.getUser());
        Assert.assertEquals((String)"Invalid rating title.", (Object)rating.getTitle(), (Object)ratingSaved.getTitle());
        Assert.assertEquals((String)"Invalid rating comment.", (Object)rating.getComment(), (Object)ratingSaved.getComment());
        Assert.assertEquals((String)"Invalid rating rate.", (long)rating.getRate(), (long)ratingSaved.getRate());
        Assert.assertTrue((String)"Invalid rating created date.", (boolean)DateUtils.compareDate(rating.getCreatedAt(), ratingSaved.getCreatedAt()));
        Assert.assertTrue((String)"Invalid rating updated date.", (boolean)DateUtils.compareDate(rating.getUpdatedAt(), ratingSaved.getUpdatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((boolean)this.ratingRepository.findById("rating3-id").isPresent());
        this.ratingRepository.delete("rating3-id");
        Assert.assertFalse((String)"Rating not deleted", (boolean)this.ratingRepository.findById("rating3-id").isPresent());
    }

    @Test
    public void shouldDeleteAnswer() throws Exception {
        Assert.assertTrue((boolean)this.ratingAnswerRepository.findById("answer-id").isPresent());
        this.ratingAnswerRepository.delete("answer-id");
        Assert.assertFalse((String)"Rating answer not deleted", (boolean)this.ratingAnswerRepository.findById("answer-id").isPresent());
    }
}

