/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class RoleRepositoryTest
extends AbstractRepositoryTest {
    private static final RoleReferenceType REFERENCE_TYPE = RoleReferenceType.ORGANIZATION;
    private static final String REFERENCE_ID = "DEFAULT";

    @Override
    protected String getTestCasesPath() {
        return "/data/role-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set roles = this.roleRepository.findAll();
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)4L, (long)roles.size());
    }

    @Test
    public void shouldFindAllByReferenceIdAndReferenceType() throws Exception {
        Set roles = this.roleRepository.findAllByReferenceIdAndReferenceType(REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertNotNull((Object)roles);
        Assert.assertEquals((long)3L, (long)roles.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        Role role = new Role();
        role.setId("API_to_create");
        role.setName("to create");
        role.setScope(RoleScope.API);
        role.setReferenceId(REFERENCE_ID);
        role.setReferenceType(REFERENCE_TYPE);
        role.setPermissions(new int[]{3});
        boolean presentBefore = this.roleRepository.findById("API_to_create").isPresent();
        Role newRole = this.roleRepository.create(role);
        boolean presentAfter = this.roleRepository.findById("API_to_create").isPresent();
        Assert.assertFalse((String)"must not exists before creation", (boolean)presentBefore);
        Assert.assertTrue((String)"must exists after creation", (boolean)presentAfter);
        Assert.assertEquals((String)"Invalid name", (Object)role.getName(), (Object)newRole.getName());
        Assert.assertEquals((String)"Invalid reference id", (Object)role.getReferenceId(), (Object)newRole.getReferenceId());
        Assert.assertEquals((String)"Invalid reference type", (Object)role.getReferenceType(), (Object)newRole.getReferenceType());
        Assert.assertEquals((String)"Invalid scope", (Object)role.getScope(), (Object)newRole.getScope());
        Assert.assertEquals((String)"Invalid permissions", (long)role.getPermissions()[0], (long)newRole.getPermissions()[0]);
    }

    @Test
    public void shouldUpdate() throws Exception {
        Role role = new Role();
        role.setId("ENVIRONMENT_to_update");
        role.setScope(RoleScope.ENVIRONMENT);
        role.setName("to update");
        role.setReferenceId(REFERENCE_ID);
        role.setReferenceType(REFERENCE_TYPE);
        role.setDescription("new description");
        role.setPermissions(new int[]{4, 5});
        role.setDefaultRole(true);
        Role update = this.roleRepository.update(role);
        Assert.assertNotNull((Object)update);
        Assert.assertEquals((String)"invalid name", (Object)role.getName(), (Object)update.getName());
        Assert.assertEquals((String)"invalid scope", (Object)role.getScope(), (Object)update.getScope());
        Assert.assertEquals((String)"invalid reference id", (Object)role.getReferenceId(), (Object)update.getReferenceId());
        Assert.assertEquals((String)"invalid reference type", (Object)role.getReferenceType(), (Object)update.getReferenceType());
        Assert.assertEquals((String)"invalid description", (Object)role.getDescription(), (Object)update.getDescription());
        Assert.assertEquals((String)"invalid default role", (Object)role.isDefaultRole(), (Object)update.isDefaultRole());
        Assert.assertEquals((String)"invalid system attribute", (Object)role.isSystem(), (Object)update.isSystem());
        List updatePermissions = IntStream.of(update.getPermissions()).boxed().collect(Collectors.toList());
        Assert.assertTrue((String)"invalid permission", (boolean)updatePermissions.contains(4));
        Assert.assertTrue((String)"invalid permission", (boolean)updatePermissions.contains(5));
    }

    @Test
    public void shouldDelete() throws Exception {
        boolean presentBefore = this.roleRepository.findById("ORGANIZATION_to_delete").isPresent();
        this.roleRepository.delete("ORGANIZATION_to_delete");
        boolean presentAfter = this.roleRepository.findById("ORGANIZATION_to_delete").isPresent();
        Assert.assertTrue((String)"must exists before creation", (boolean)presentBefore);
        Assert.assertFalse((String)"must not exists after creation", (boolean)presentAfter);
    }

    @Test
    public void shouldFindByScopeAndName() throws Exception {
        Optional role = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, "find by scope 1", REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertNotNull((Object)role);
        Assert.assertTrue((String)"No roles found", (boolean)role.isPresent());
        Assert.assertTrue((String)"not contains scope1", (boolean)"find by scope 1".equals(((Role)role.get()).getName()));
    }

    @Test
    public void shouldFindByScopeAndRef() throws Exception {
        Set roles = this.roleRepository.findByScopeAndReferenceIdAndReferenceType(RoleScope.API, REFERENCE_ID, REFERENCE_TYPE);
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((String)"No roles found", (boolean)roles.isEmpty());
        Assert.assertEquals((String)"invalid roles count", (long)1L, (long)roles.size());
        List names = roles.stream().map(Role::getName).collect(Collectors.toList());
        Assert.assertTrue((String)"not contains scope1", (boolean)names.contains("find by scope 1"));
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional role = this.roleRepository.findById("API_find_by_scope_1");
        Assert.assertTrue((String)"role not found", (boolean)role.isPresent());
        Assert.assertEquals((String)"invalid name", (Object)"find by scope 1", (Object)((Role)role.get()).getName());
        Assert.assertEquals((String)"invalid description", (Object)"role description", (Object)((Role)role.get()).getDescription());
        Assert.assertEquals((String)"invalid scope", (Object)RoleScope.API, (Object)((Role)role.get()).getScope());
        Assert.assertTrue((String)"invalid defaultRole", (boolean)((Role)role.get()).isDefaultRole());
        Assert.assertTrue((String)"invalid system attribute", (boolean)((Role)role.get()).isSystem());
        Assert.assertEquals((String)"invalid permissions", (long)1L, (long)((Role)role.get()).getPermissions().length);
        Assert.assertEquals((String)"invalid permissions", (long)1L, (long)((Role)role.get()).getPermissions()[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownRole() throws Exception {
        Role unknownRole = new Role();
        unknownRole.setId("unknown");
        unknownRole.setName("unknown");
        unknownRole.setReferenceId("unknown");
        unknownRole.setReferenceType(REFERENCE_TYPE);
        this.roleRepository.update(unknownRole);
        Assert.fail((String)"An unknown role should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.roleRepository.update(null);
        Assert.fail((String)"A null role should not be updated");
    }
}

