/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.repository.utils.DateUtils;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/subscription-tests/";
    }

    @Test
    public void shouldFindByPlan() throws TechnicalException {
        List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().plans(Collections.singleton("plan1")).build());
        Assert.assertNotNull((Object)subscriptions);
        Assert.assertFalse((boolean)subscriptions.isEmpty());
        Assert.assertEquals((String)"Subscriptions size", (long)1L, (long)subscriptions.size());
        Subscription subscription = (Subscription)subscriptions.iterator().next();
        Assert.assertEquals((String)"Subscription id", (Object)"sub1", (Object)subscription.getId());
        Assert.assertEquals((String)"Subscription plan", (Object)"plan1", (Object)subscription.getPlan());
        Assert.assertEquals((String)"Subscription application", (Object)"app1", (Object)subscription.getApplication());
        Assert.assertEquals((String)"Subscription api", (Object)"api1", (Object)subscription.getApi());
        Assert.assertEquals((String)"Subscription reason", (Object)"reason", (Object)subscription.getReason());
        Assert.assertEquals((String)"Subscription request", (Object)"request", (Object)subscription.getRequest());
        Assert.assertEquals((String)"Subscription status", (Object)Subscription.Status.PENDING, (Object)subscription.getStatus());
        Assert.assertEquals((String)"Subscription processed by", (Object)"user1", (Object)subscription.getProcessedBy());
        Assert.assertEquals((String)"Subscription subscribed by", (Object)"user2", (Object)subscription.getSubscribedBy());
        Assert.assertTrue((String)"Subscription starting at", (boolean)DateUtils.compareDate(1439022010883L, subscription.getStartingAt().getTime()));
        Assert.assertTrue((String)"Subscription ending at", (boolean)DateUtils.compareDate(1449022010883L, subscription.getEndingAt().getTime()));
        Assert.assertTrue((String)"Subscription created at", (boolean)DateUtils.compareDate(1459022010883L, subscription.getCreatedAt().getTime()));
        Assert.assertTrue((String)"Subscription updated at", (boolean)DateUtils.compareDate(1469022010883L, subscription.getUpdatedAt().getTime()));
        Assert.assertTrue((String)"Subscription processed at", (boolean)DateUtils.compareDate(1479022010883L, subscription.getProcessedAt().getTime()));
        Assert.assertTrue((String)"Subscription paused at", (boolean)DateUtils.compareDate(1479022010883L, subscription.getPausedAt().getTime()));
        Assert.assertEquals((String)"Subscription client id", (Object)"my-client-id", (Object)subscription.getClientId());
        Assert.assertTrue((String)"Subscription GCU accepted", (boolean)subscription.getGeneralConditionsAccepted());
        Assert.assertEquals((String)"Subscription GCU content pageId", (Object)"ref", (Object)subscription.getGeneralConditionsContentPageId());
        Assert.assertEquals((String)"Subscription GCU content revision", (Object)2, (Object)subscription.getGeneralConditionsContentRevision());
    }

    @Test
    public void shouldNotFindByPlan() throws TechnicalException {
        List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().plans(Collections.singleton("unknown-plan")).build());
        Assert.assertNotNull((Object)subscriptions);
        Assert.assertTrue((boolean)subscriptions.isEmpty());
    }

    @Test
    public void shouldFindByApplication() throws TechnicalException {
        List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton("app1")).build());
        Assert.assertNotNull((Object)subscriptions);
        Assert.assertFalse((boolean)subscriptions.isEmpty());
        Assert.assertEquals((String)"Subscriptions size", (long)3L, (long)subscriptions.size());
        Iterator iterator = subscriptions.iterator();
        Assert.assertEquals((String)"Subscription id", (Object)"sub3", (Object)((Subscription)iterator.next()).getId());
        Assert.assertEquals((String)"Subscription id", (Object)"sub4", (Object)((Subscription)iterator.next()).getId());
        Assert.assertEquals((String)"Subscription id", (Object)"sub1", (Object)((Subscription)iterator.next()).getId());
    }

    @Test
    public void shoulNotFindByApplication() throws TechnicalException {
        List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton("unknown-app")).build());
        Assert.assertNotNull((Object)subscriptions);
        Assert.assertTrue((boolean)subscriptions.isEmpty());
    }

    @Test
    public void shouldFindById() throws TechnicalException {
        Optional optionalSubscription = this.subscriptionRepository.findById((Object)"sub1");
        Assert.assertNotNull((Object)optionalSubscription);
        Assert.assertTrue((boolean)optionalSubscription.isPresent());
        Subscription subscription = (Subscription)optionalSubscription.get();
        Assert.assertEquals((String)"Subscription id", (Object)"sub1", (Object)subscription.getId());
        Assert.assertEquals((String)"Subscription plan", (Object)"plan1", (Object)subscription.getPlan());
        Assert.assertEquals((String)"Subscription application", (Object)"app1", (Object)subscription.getApplication());
        Assert.assertEquals((String)"Subscription api", (Object)"api1", (Object)subscription.getApi());
        Assert.assertEquals((String)"Subscription reason", (Object)"reason", (Object)subscription.getReason());
        Assert.assertEquals((String)"Subscription status", (Object)Subscription.Status.PENDING, (Object)subscription.getStatus());
        Assert.assertEquals((String)"Subscription processed by", (Object)"user1", (Object)subscription.getProcessedBy());
        Assert.assertEquals((String)"Subscription subscribed by", (Object)"user2", (Object)subscription.getSubscribedBy());
        Assert.assertTrue((String)"Subscription starting at", (boolean)DateUtils.compareDate(1439022010883L, subscription.getStartingAt().getTime()));
        Assert.assertTrue((String)"Subscription ending at", (boolean)DateUtils.compareDate(1449022010883L, subscription.getEndingAt().getTime()));
        Assert.assertTrue((String)"Subscription created at", (boolean)DateUtils.compareDate(1459022010883L, subscription.getCreatedAt().getTime()));
        Assert.assertTrue((String)"Subscription updated at", (boolean)DateUtils.compareDate(1469022010883L, subscription.getUpdatedAt().getTime()));
        Assert.assertTrue((String)"Subscription processed at", (boolean)DateUtils.compareDate(1479022010883L, subscription.getProcessedAt().getTime()));
        Assert.assertEquals((String)"Subscription client id", (Object)"my-client-id", (Object)subscription.getClientId());
    }

    @Test
    public void shouldNotFindById() throws TechnicalException {
        Optional subscription = this.subscriptionRepository.findById((Object)"unknown-sub");
        Assert.assertNotNull((Object)subscription);
        Assert.assertFalse((boolean)subscription.isPresent());
    }

    @Test
    public void shouldUpdate() throws TechnicalException {
        Optional subscription = this.subscriptionRepository.findById((Object)"sub1");
        ((Subscription)subscription.get()).setUpdatedAt(new Date(1000000000000L));
        Subscription update = (Subscription)this.subscriptionRepository.update(subscription.get());
        Assert.assertNotNull((Object)update);
        Assert.assertTrue((boolean)DateUtils.compareDate(update.getUpdatedAt(), new Date(1000000000000L)));
    }

    @Test
    public void shouldDelete() throws TechnicalException {
        this.subscriptionRepository.delete((Object)"sub2");
        Optional subscription = this.subscriptionRepository.findById((Object)"sub2");
        Assert.assertNotNull((Object)subscription);
        Assert.assertFalse((boolean)subscription.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownSubscription() throws Exception {
        Subscription unknownSubscription = new Subscription();
        unknownSubscription.setId("unknown");
        this.subscriptionRepository.update((Object)unknownSubscription);
        Assert.fail((String)"An unknown subscription should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.subscriptionRepository.update(null);
        Assert.fail((String)"A null subscription should not be updated");
    }

    @Test
    public void shouldFindBetweenDates() throws TechnicalException {
        List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().from(1469022010883L).to(1569022010883L).build());
        Assert.assertNotNull((Object)subscriptions);
        Assert.assertFalse((boolean)subscriptions.isEmpty());
        Assert.assertEquals((String)"Subscriptions size", (long)1L, (long)subscriptions.size());
        Assert.assertEquals((String)"Subscription id", (Object)"sub1", (Object)((Subscription)subscriptions.iterator().next()).getId());
    }

    @Test
    public void shouldFindBetweenDatesPageable() throws Exception {
        Page subscriptionPage = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().from(1339022010883L).to(1839022010883L).build(), new PageableBuilder().pageNumber(0).pageSize(2).build());
        Assert.assertEquals((long)0L, (long)subscriptionPage.getPageNumber());
        Assert.assertEquals((long)2L, (long)subscriptionPage.getPageElements());
        Assert.assertEquals((long)2L, (long)subscriptionPage.getTotalElements());
        Assert.assertEquals((long)2L, (long)subscriptionPage.getContent().size());
        Assert.assertEquals((Object)"sub3", (Object)((Subscription)subscriptionPage.getContent().get(0)).getId());
        Assert.assertEquals((Object)"sub1", (Object)((Subscription)subscriptionPage.getContent().get(1)).getId());
        subscriptionPage = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().from(1339022010883L).to(1839022010883L).build(), new PageableBuilder().pageNumber(1).pageSize(2).build());
        Assert.assertEquals((long)1L, (long)subscriptionPage.getPageNumber());
        Assert.assertEquals((long)0L, (long)subscriptionPage.getPageElements());
        Assert.assertEquals((long)2L, (long)subscriptionPage.getTotalElements());
        Assert.assertEquals((long)0L, (long)subscriptionPage.getContent().size());
    }
}

