/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TagRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/tag-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set tags = this.tagRepository.findAll();
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)3L, (long)tags.size());
        Tag tagProduct = tags.stream().filter(tag -> "products".equals(tag.getId())).findAny().get();
        Assert.assertEquals((Object)"Products", (Object)tagProduct.getName());
        Assert.assertEquals((Object)"Description for products tag", (Object)tagProduct.getDescription());
        Assert.assertEquals(Arrays.asList("group1", "group2"), (Object)tagProduct.getRestrictedGroups());
    }

    @Test
    public void shouldCreate() throws Exception {
        Tag tag = new Tag();
        tag.setId("new-tag");
        tag.setName("Tag name");
        tag.setDescription("Description for the new tag");
        tag.setRestrictedGroups(Arrays.asList("g1", "groupNew"));
        int nbTagsBeforeCreation = this.tagRepository.findAll().size();
        this.tagRepository.create((Object)tag);
        int nbTagsAfterCreation = this.tagRepository.findAll().size();
        Assert.assertEquals((long)(nbTagsBeforeCreation + 1), (long)nbTagsAfterCreation);
        Optional optional = this.tagRepository.findById((Object)"new-tag");
        Assert.assertTrue((String)"Tag saved not found", (boolean)optional.isPresent());
        Tag tagSaved = (Tag)optional.get();
        Assert.assertEquals((String)"Invalid saved tag name.", (Object)tag.getName(), (Object)tagSaved.getName());
        Assert.assertEquals((String)"Invalid tag description.", (Object)tag.getDescription(), (Object)tagSaved.getDescription());
        Assert.assertEquals((String)"Invalid tag groups.", (Object)tag.getRestrictedGroups(), (Object)tagSaved.getRestrictedGroups());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.tagRepository.findById((Object)"products");
        Assert.assertTrue((String)"Tag to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved tag name.", (Object)"Products", (Object)((Tag)optional.get()).getName());
        Tag tag = (Tag)optional.get();
        tag.setName("New product");
        tag.setDescription("New description");
        tag.setRestrictedGroups(Collections.singletonList("group"));
        int nbTagsBeforeUpdate = this.tagRepository.findAll().size();
        this.tagRepository.update((Object)tag);
        int nbTagsAfterUpdate = this.tagRepository.findAll().size();
        Assert.assertEquals((long)nbTagsBeforeUpdate, (long)nbTagsAfterUpdate);
        Optional optionalUpdated = this.tagRepository.findById((Object)"products");
        Assert.assertTrue((String)"Tag to update not found", (boolean)optionalUpdated.isPresent());
        Tag tagUpdated = (Tag)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved tag name.", (Object)"New product", (Object)tagUpdated.getName());
        Assert.assertEquals((String)"Invalid tag description.", (Object)"New description", (Object)tagUpdated.getDescription());
        Assert.assertEquals((String)"Invalid tag groups.", Collections.singletonList("group"), (Object)tagUpdated.getRestrictedGroups());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbTagsBeforeDeletion = this.tagRepository.findAll().size();
        this.tagRepository.delete((Object)"international");
        int nbTagsAfterDeletion = this.tagRepository.findAll().size();
        Assert.assertEquals((long)(nbTagsBeforeDeletion - 1), (long)nbTagsAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownTag() throws Exception {
        Tag unknownTag = new Tag();
        unknownTag.setId("unknown");
        this.tagRepository.update((Object)unknownTag);
        Assert.fail((String)"An unknown tag should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.tagRepository.update(null);
        Assert.fail((String)"A null tag should not be updated");
    }
}

