/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Tenant;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TenantRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/tenant-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set tenants = this.tenantRepository.findAll();
        Assert.assertNotNull((Object)tenants);
        Assert.assertEquals((long)3L, (long)tenants.size());
    }

    @Test
    public void shouldCreate() throws Exception {
        Tenant tenant = new Tenant();
        tenant.setId("new-tenant");
        tenant.setName("Tenant name");
        tenant.setDescription("Description for the new tenant");
        int nbTenantsBeforeCreation = this.tenantRepository.findAll().size();
        this.tenantRepository.create((Object)tenant);
        int nbTenantsAfterCreation = this.tenantRepository.findAll().size();
        Assert.assertEquals((long)(nbTenantsBeforeCreation + 1), (long)nbTenantsAfterCreation);
        Optional optional = this.tenantRepository.findById((Object)"new-tenant");
        Assert.assertTrue((String)"Tenant saved not found", (boolean)optional.isPresent());
        Tenant tenantSaved = (Tenant)optional.get();
        Assert.assertEquals((String)"Invalid saved tenant name.", (Object)tenant.getName(), (Object)tenantSaved.getName());
        Assert.assertEquals((String)"Invalid tenant description.", (Object)tenant.getDescription(), (Object)tenantSaved.getDescription());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.tenantRepository.findById((Object)"asia");
        Assert.assertTrue((String)"Tenant to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved tenant name.", (Object)"Asia", (Object)((Tenant)optional.get()).getName());
        Tenant tenant = (Tenant)optional.get();
        tenant.setName("New tenant");
        tenant.setDescription("New description");
        int nbTenantsBeforeUpdate = this.tenantRepository.findAll().size();
        this.tenantRepository.update((Object)tenant);
        int nbTenantsAfterUpdate = this.tenantRepository.findAll().size();
        Assert.assertEquals((long)nbTenantsBeforeUpdate, (long)nbTenantsAfterUpdate);
        Optional optionalUpdated = this.tenantRepository.findById((Object)"asia");
        Assert.assertTrue((String)"Tenant to update not found", (boolean)optionalUpdated.isPresent());
        Tenant tenantUpdated = (Tenant)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved tenant name.", (Object)"New tenant", (Object)tenantUpdated.getName());
        Assert.assertEquals((String)"Invalid tenant description.", (Object)"New description", (Object)tenantUpdated.getDescription());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbTenantsBeforeDeletion = this.tenantRepository.findAll().size();
        this.tenantRepository.delete((Object)"us");
        int nbTenantsAfterDeletion = this.tenantRepository.findAll().size();
        Assert.assertEquals((long)(nbTenantsBeforeDeletion - 1), (long)nbTenantsAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownTenant() throws Exception {
        Tenant unknownTenant = new Tenant();
        unknownTenant.setId("unknown");
        this.tenantRepository.update((Object)unknownTenant);
        Assert.fail((String)"An unknown tenant should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.tenantRepository.update(null);
        Assert.fail((String)"A null tenant should not be updated");
    }
}

