/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ThemeRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/theme-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set themes = this.themeRepository.findAll();
        Assert.assertNotNull((Object)themes);
        Assert.assertEquals((long)3L, (long)themes.size());
        Theme themeSimple = themes.stream().filter(theme -> "simple".equals(theme.getId())).findAny().get();
        Assert.assertEquals((Object)"Theme simple", (Object)themeSimple.getName());
        Assert.assertEquals((Object)"backgroundImage", (Object)themeSimple.getBackgroundImage());
        Assert.assertEquals((Object)"{\"def\": \"value\"}", (Object)themeSimple.getDefinition());
        Assert.assertEquals((Object)"logo", (Object)themeSimple.getLogo());
        Assert.assertEquals((Object)"optionalLogo", (Object)themeSimple.getOptionalLogo());
        Assert.assertEquals((Object)"TEST", (Object)themeSimple.getReferenceId());
        Assert.assertEquals((Object)"ENVIRONMENT", (Object)themeSimple.getReferenceType());
        Assert.assertTrue((boolean)DateUtils.compareDate(1111111111111L, themeSimple.getUpdatedAt().getTime()));
        Assert.assertTrue((boolean)DateUtils.compareDate(1000002222222L, themeSimple.getCreatedAt().getTime()));
        Assert.assertEquals((Object)false, (Object)themeSimple.isEnabled());
    }

    @Test
    public void shouldFindByReference() throws Exception {
        Set themes = this.themeRepository.findByReferenceIdAndReferenceType("DEFAULT", "ENVIRONMENT");
        Assert.assertNotNull((Object)themes);
        Assert.assertEquals((long)2L, (long)themes.size());
        Theme darkTheme = themes.stream().filter(theme -> "dark".equals(theme.getId())).findAny().get();
        Assert.assertEquals((Object)"Theme dark", (Object)darkTheme.getName());
        Theme lightTheme = themes.stream().filter(theme -> "light".equals(theme.getId())).findAny().get();
        Assert.assertEquals((Object)"Light", (Object)lightTheme.getName());
    }

    @Test
    public void shouldCreate() throws Exception {
        Theme theme = new Theme();
        theme.setId("new-theme");
        theme.setName("Theme dark");
        theme.setCreatedAt(new Date(1000000000000L));
        theme.setUpdatedAt(new Date(1111111111111L));
        theme.setReferenceId("DEFAULT");
        theme.setDefinition("{\"def\": \"value\"}");
        theme.setReferenceType("ENVIRONMENT");
        theme.setLogo("logo");
        theme.setOptionalLogo("optionalLogo");
        theme.setBackgroundImage("backgroundImage");
        theme.setEnabled(true);
        int nbThemesBeforeCreation = this.themeRepository.findAll().size();
        this.themeRepository.create((Object)theme);
        int nbThemesAfterCreation = this.themeRepository.findAll().size();
        Assert.assertEquals((long)(nbThemesBeforeCreation + 1), (long)nbThemesAfterCreation);
        Optional optional = this.themeRepository.findById((Object)"new-theme");
        Assert.assertTrue((String)"Theme saved not found", (boolean)optional.isPresent());
        Theme themeSaved = (Theme)optional.get();
        Assert.assertEquals((String)"Invalid saved theme name.", (Object)theme.getName(), (Object)themeSaved.getName());
        Assert.assertEquals((Object)"backgroundImage", (Object)themeSaved.getBackgroundImage());
        Assert.assertEquals((Object)"{\"def\": \"value\"}", (Object)themeSaved.getDefinition());
        Assert.assertEquals((Object)"logo", (Object)themeSaved.getLogo());
        Assert.assertEquals((Object)"optionalLogo", (Object)themeSaved.getOptionalLogo());
        Assert.assertEquals((Object)"DEFAULT", (Object)themeSaved.getReferenceId());
        Assert.assertEquals((Object)"ENVIRONMENT", (Object)themeSaved.getReferenceType());
        Assert.assertTrue((boolean)DateUtils.compareDate(1111111111111L, themeSaved.getUpdatedAt().getTime()));
        Assert.assertTrue((boolean)DateUtils.compareDate(1000000000000L, themeSaved.getCreatedAt().getTime()));
        Assert.assertEquals((Object)true, (Object)themeSaved.isEnabled());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.themeRepository.findById((Object)"light");
        Assert.assertTrue((String)"Theme to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved theme name.", (Object)"Light", (Object)((Theme)optional.get()).getName());
        Theme theme = (Theme)optional.get();
        theme.setName("Awesome");
        theme.setLogo("updateLogo");
        theme.setOptionalLogo(null);
        theme.setBackgroundImage("updateBackground");
        theme.setEnabled(true);
        theme.setDefinition("{\"def\": \"test\"}");
        theme.setReferenceType("PLATFORM");
        theme.setReferenceId("TEST");
        theme.setCreatedAt(new Date(1010101010101L));
        theme.setUpdatedAt(new Date(1030141710801L));
        int nbThemeBeforeUpdate = this.themeRepository.findAll().size();
        this.themeRepository.update((Object)theme);
        int nbThemeAfterUpdate = this.themeRepository.findAll().size();
        Assert.assertEquals((long)nbThemeBeforeUpdate, (long)nbThemeAfterUpdate);
        Optional optionalUpdated = this.themeRepository.findById((Object)"light");
        Assert.assertTrue((String)"Theme to update not found", (boolean)optionalUpdated.isPresent());
        Theme themeUpdated = (Theme)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved theme name.", (Object)"Awesome", (Object)themeUpdated.getName());
        Assert.assertEquals((Object)"updateBackground", (Object)themeUpdated.getBackgroundImage());
        Assert.assertEquals((Object)"{\"def\": \"test\"}", (Object)themeUpdated.getDefinition());
        Assert.assertEquals((Object)"updateLogo", (Object)themeUpdated.getLogo());
        Assert.assertEquals(null, (Object)themeUpdated.getOptionalLogo());
        Assert.assertEquals((Object)"TEST", (Object)themeUpdated.getReferenceId());
        Assert.assertEquals((Object)"PLATFORM", (Object)themeUpdated.getReferenceType());
        Assert.assertTrue((boolean)DateUtils.compareDate(1030141710801L, themeUpdated.getUpdatedAt().getTime()));
        Assert.assertTrue((boolean)DateUtils.compareDate(1010101010101L, themeUpdated.getCreatedAt().getTime()));
        Assert.assertEquals((Object)true, (Object)themeUpdated.isEnabled());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbThemesBeforeDeletion = this.themeRepository.findAll().size();
        this.themeRepository.delete((Object)"dark");
        int nbThemesAfterDeletion = this.themeRepository.findAll().size();
        Assert.assertEquals((long)(nbThemesBeforeDeletion - 1), (long)nbThemesAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownTheme() throws Exception {
        Theme unknownTheme = new Theme();
        unknownTheme.setId("unknown");
        this.themeRepository.update((Object)unknownTheme);
        Assert.fail((String)"An unknown theme should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.themeRepository.update(null);
        Assert.fail((String)"A null theme should not be updated");
    }
}

