/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.TicketCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.Ticket;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TicketRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/ticket-tests/";
    }

    @Test
    public void shouldSearchWithNullCriteria() throws TechnicalException {
        List tickets = this.ticketRepository.search(null, null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)tickets);
        Assert.assertEquals((String)"Invalid tickets numbers in search", (long)4L, (long)tickets.size());
        Assert.assertEquals((Object)"ticket0", (Object)((Ticket)tickets.get(0)).getId());
        Assert.assertEquals((Object)"ticket1", (Object)((Ticket)tickets.get(1)).getId());
        Assert.assertEquals((Object)"ticket2", (Object)((Ticket)tickets.get(2)).getId());
        Assert.assertEquals((Object)"ticket3", (Object)((Ticket)tickets.get(3)).getId());
    }

    @Test
    public void shouldSearchAllWithEmptyCriteria() throws Exception {
        List tickets = this.ticketRepository.search(new TicketCriteria.Builder().build(), null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)tickets);
        Assert.assertEquals((String)"Invalid tickets numbers in search", (long)4L, (long)tickets.size());
        Assert.assertEquals((Object)"ticket0", (Object)((Ticket)tickets.get(0)).getId());
        Assert.assertEquals((Object)"ticket1", (Object)((Ticket)tickets.get(1)).getId());
        Assert.assertEquals((Object)"ticket2", (Object)((Ticket)tickets.get(2)).getId());
        Assert.assertEquals((Object)"ticket3", (Object)((Ticket)tickets.get(3)).getId());
    }

    @Test
    public void shouldSearchAllWithCriteriaFromUserEmpty() throws Exception {
        List tickets = this.ticketRepository.search(new TicketCriteria.Builder().fromUser("").build(), null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)tickets);
        Assert.assertEquals((String)"Invalid tickets numbers in search", (long)4L, (long)tickets.size());
        Assert.assertEquals((Object)"ticket0", (Object)((Ticket)tickets.get(0)).getId());
        Assert.assertEquals((Object)"ticket1", (Object)((Ticket)tickets.get(1)).getId());
        Assert.assertEquals((Object)"ticket2", (Object)((Ticket)tickets.get(2)).getId());
        Assert.assertEquals((Object)"ticket3", (Object)((Ticket)tickets.get(3)).getId());
    }

    @Test
    public void shouldSearchAllWithCriteriaFromUser0SortedBySubjectDescendingOnThreeElements() throws Exception {
        List tickets = this.ticketRepository.search(new TicketCriteria.Builder().fromUser("user0").api("api0").build(), new SortableBuilder().field("subject").order(Order.DESC).build(), new PageableBuilder().pageNumber(0).pageSize(3).build()).getContent();
        Assert.assertNotNull((Object)tickets);
        Assert.assertEquals((String)"Invalid tickets numbers in search", (long)3L, (long)tickets.size());
        Assert.assertEquals((Object)"ticket3", (Object)((Ticket)tickets.get(0)).getId());
        Assert.assertEquals((Object)"ticket2", (Object)((Ticket)tickets.get(1)).getId());
        Assert.assertEquals((Object)"ticket1", (Object)((Ticket)tickets.get(2)).getId());
    }

    @Test
    public void shouldCreateTicketTest() throws Exception {
        Ticket ticket = new Ticket();
        ticket.setId("createticket1");
        ticket.setApi("api1");
        ticket.setApplication("application1");
        ticket.setFromUser("creationUser");
        ticket.setSubject("createticket1_subject");
        ticket.setContent("createticket1_content");
        ticket.setCreatedAt(new Date(1439052010883L));
        Ticket ticketCreated = this.ticketRepository.create(ticket);
        Assert.assertNotNull((String)"Ticket created is null", (Object)ticketCreated);
        List tickets = this.ticketRepository.search(new TicketCriteria.Builder().fromUser("creationUser").build(), null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertTrue((String)"Unable to find saved ticket", (tickets.size() == 1 ? 1 : 0) != 0);
        Ticket ticketFound = (Ticket)tickets.get(0);
        Assert.assertEquals((String)"Invalid saved ticket id.", (Object)ticket.getId(), (Object)ticketFound.getId());
        Assert.assertEquals((String)"Invalid saved ticket api.", (Object)ticket.getApi(), (Object)ticketFound.getApi());
        Assert.assertEquals((String)"Invalid saved ticket application.", (Object)ticket.getApplication(), (Object)ticketFound.getApplication());
        Assert.assertEquals((String)"Invalid saved ticket fromUser.", (Object)ticket.getFromUser(), (Object)ticketFound.getFromUser());
        Assert.assertEquals((String)"Invalid saved ticket subject.", (Object)ticket.getSubject(), (Object)ticketFound.getSubject());
        Assert.assertEquals((String)"Invalid saved ticket content.", (Object)ticket.getContent(), (Object)ticketFound.getContent());
        Assert.assertTrue((boolean)DateUtils.compareDate(ticket.getCreatedAt(), ticketFound.getCreatedAt()));
    }
}

