/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Token;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TokenRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/token-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set tokens = this.tokenRepository.findAll();
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((long)4L, (long)tokens.size());
        Token token123 = tokens.stream().filter(token -> "token123".equals(token.getId())).findAny().get();
        this.assertToken(token123);
    }

    @Test
    public void shouldFindByReference() throws Exception {
        List tokens = this.tokenRepository.findByReference("USER", "123");
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((long)2L, (long)tokens.size());
        Token token123 = tokens.stream().filter(token -> "token123".equals(token.getId())).findAny().get();
        this.assertToken(token123);
    }

    private void assertToken(Token tokenProduct) {
        Assert.assertEquals((Object)"My personal token", (Object)tokenProduct.getName());
        Assert.assertEquals((Object)"USER", (Object)tokenProduct.getReferenceType());
        Assert.assertEquals((Object)"123", (Object)tokenProduct.getReferenceId());
        Assert.assertEquals((String)"created at", (Object)new Date(1486771200000L), (Object)tokenProduct.getCreatedAt());
        Assert.assertEquals((String)"expire at", (Object)new Date(1486772200000L), (Object)tokenProduct.getExpiresAt());
        Assert.assertEquals((String)"last use at", (Object)new Date(1486773200000L), (Object)tokenProduct.getLastUseAt());
    }

    @Test
    public void shouldCreate() throws Exception {
        Token token = new Token();
        token.setId("new-token");
        token.setToken("token0");
        token.setName("Token name");
        token.setCreatedAt(new Date(1486771200000L));
        token.setExpiresAt(new Date(1486772200000L));
        token.setLastUseAt(new Date(1486773200000L));
        token.setReferenceType("USER");
        token.setReferenceId("456");
        int nbTokensBeforeCreation = this.tokenRepository.findByReference("USER", "456").size();
        this.tokenRepository.create((Object)token);
        int nbTokensAfterCreation = this.tokenRepository.findByReference("USER", "456").size();
        Assert.assertEquals((long)(nbTokensBeforeCreation + 1), (long)nbTokensAfterCreation);
        Optional optional = this.tokenRepository.findById((Object)"new-token");
        Assert.assertTrue((String)"Token saved not found", (boolean)optional.isPresent());
        Token tokenSaved = (Token)optional.get();
        Assert.assertEquals((String)"Invalid saved token.", (Object)token.getToken(), (Object)tokenSaved.getToken());
        Assert.assertEquals((String)"Invalid saved token name.", (Object)token.getName(), (Object)tokenSaved.getName());
        Assert.assertEquals((String)"Invalid token ref type.", (Object)token.getReferenceType(), (Object)tokenSaved.getReferenceType());
        Assert.assertEquals((String)"Invalid token ref id.", (Object)token.getReferenceId(), (Object)tokenSaved.getReferenceId());
        Assert.assertEquals((String)"Invalid token created date.", (Object)token.getCreatedAt(), (Object)tokenSaved.getCreatedAt());
        Assert.assertEquals((String)"Invalid token expire date.", (Object)token.getExpiresAt(), (Object)tokenSaved.getExpiresAt());
        Assert.assertEquals((String)"Invalid token last use date.", (Object)token.getLastUseAt(), (Object)tokenSaved.getLastUseAt());
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.tokenRepository.findById((Object)"token123");
        Assert.assertTrue((String)"Token to update not found", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Invalid saved token name.", (Object)"My personal token", (Object)((Token)optional.get()).getName());
        Token token = (Token)optional.get();
        token.setToken("new_token");
        token.setName("New token name");
        token.setReferenceType("New ref type");
        token.setReferenceId("New ref id");
        token.setCreatedAt(new Date(1486774200000L));
        token.setExpiresAt(new Date(1486775200000L));
        token.setLastUseAt(new Date(1486776200000L));
        int nbTokensBeforeUpdate = this.tokenRepository.findByReference("USER", "token123").size();
        this.tokenRepository.update((Object)token);
        int nbTokensAfterUpdate = this.tokenRepository.findByReference("USER", "token123").size();
        Assert.assertEquals((long)nbTokensBeforeUpdate, (long)nbTokensAfterUpdate);
        Optional optionalUpdated = this.tokenRepository.findById((Object)"token123");
        Assert.assertTrue((String)"Token to update not found", (boolean)optionalUpdated.isPresent());
        Token tokenUpdated = (Token)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved token.", (Object)"new_token", (Object)tokenUpdated.getToken());
        Assert.assertEquals((String)"Invalid saved token name.", (Object)"New token name", (Object)tokenUpdated.getName());
        Assert.assertEquals((String)"Invalid token ref type.", (Object)"New ref type", (Object)tokenUpdated.getReferenceType());
        Assert.assertEquals((String)"Invalid token ref id.", (Object)"New ref id", (Object)tokenUpdated.getReferenceId());
        Assert.assertEquals((String)"Invalid token created date.", (Object)new Date(1486774200000L), (Object)tokenUpdated.getCreatedAt());
        Assert.assertEquals((String)"Invalid token expire date.", (Object)new Date(1486775200000L), (Object)tokenUpdated.getExpiresAt());
        Assert.assertEquals((String)"Invalid token expire date.", (Object)new Date(1486776200000L), (Object)tokenUpdated.getLastUseAt());
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbTokensBeforeDeletion = this.tokenRepository.findByReference("USER", "123").size();
        this.tokenRepository.delete((Object)"token_to_delete");
        int nbTokensAfterDeletion = this.tokenRepository.findByReference("USER", "123").size();
        Assert.assertEquals((long)(nbTokensBeforeDeletion - 1), (long)nbTokensAfterDeletion);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownToken() throws Exception {
        Token unknownToken = new Token();
        unknownToken.setToken("unknown");
        this.tokenRepository.update((Object)unknownToken);
        Assert.fail((String)"An unknown token should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.tokenRepository.update(null);
        Assert.fail((String)"A null token should not be updated");
    }
}

